/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.jmsinjector;

import java.util.Hashtable;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SampleAction;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.storage.api.ActionEvent;
import org.ow2.clif.supervisor.api.ClifException;

public class SessionObject
implements SessionObjectAction,
DataProvider,
SampleAction {
    static final int SAMPLE_START_PRODUCER = 0;
    static final int SAMPLE_START_CONSUMER = 1;
    static final String PLUGIN_NBMSG = "nbMsg";
    static final String PLUGIN_CONSWEIGHT = "consWeight";
    static final String PLUGIN_PRODWEIGHT = "prodWeight";
    static final String PLUGIN_MESSAGESIZE = "messageSize";
    static final String PLUGIN_CLUSTERQUEUENAME = "clusterQueueName";
    static final String PLUGIN_CONNECTIONFACTORYNAME = "connectionFactoryName";
    static final String PLUGIN_JNDIHOST = "jndiHost";
    static final String PLUGIN_JNDIPORT = "jndiPort";
    private String jndiHost;
    private String jndiPort;
    private int nbMsg;
    private int consWeight;
    private String clusterQueueName;
    private String connectionFactoryName;
    private int messageSize;
    private int prodWeight;

    public SessionObject(Map<String, String> params) throws ClifException {
        String value = params.get(PLUGIN_NBMSG);
        value = params.get(PLUGIN_CLUSTERQUEUENAME);
        System.out.println("clusterQueueName : " + value);
        if (value != null && value.length() > 0) {
            try {
                this.clusterQueueName = value;
            }
            catch (Exception ex) {
                throw new ClifException("ISAC can't get clusterQueueName because the specified clusterQueueName is not valid: " + value, (Throwable)ex);
            }
        } else {
            throw new ClifException("ISAC can't get clusterQueueName because the specified clusterQueueName is not valid: " + value);
        }
        value = params.get(PLUGIN_CONNECTIONFACTORYNAME);
        System.out.println("connectionFactoryName : " + value);
        if (value != null && value.length() > 0) {
            try {
                this.connectionFactoryName = value;
            }
            catch (Exception ex) {
                throw new ClifException("ISAC can't get connectionFactoryName because the specified connectionFactoryName is not valid: " + value, (Throwable)ex);
            }
        } else {
            throw new ClifException("ISAC can't get connectionFactoryName because the specified connectionFactoryName is not valid: " + value);
        }
        value = params.get(PLUGIN_MESSAGESIZE);
        System.out.println("messageSize : " + value);
        if (value != null && value.length() > 0) {
            try {
                this.messageSize = Integer.parseInt(value);
            }
            catch (Exception ex) {
                throw new ClifException("ISAC can't get messageSize because the specified messageSize is not valid: " + value, (Throwable)ex);
            }
        } else {
            throw new ClifException("ISAC can't get messageSize because the specified messageSize is not valid: " + value);
        }
        value = params.get(PLUGIN_JNDIHOST);
        System.out.println("jndiHost : " + value);
        if (value != null && value.length() > 0) {
            try {
                this.jndiHost = value;
            }
            catch (Exception ex) {
                throw new ClifException("ISAC can't get jndiHost because the specified jndiHost is not valid: " + value, (Throwable)ex);
            }
        } else {
            throw new ClifException("ISAC can't get jndiHost because the specified jndiHost is not valid: " + value);
        }
        value = params.get(PLUGIN_JNDIPORT);
        System.out.println("jndiPort : " + value);
        if (value != null && value.length() > 0) {
            try {
                this.jndiPort = value;
            }
            catch (Exception ex) {
                throw new ClifException("ISAC can't get jndiPort because the specified jndiPort is not valid: " + value, (Throwable)ex);
            }
        } else {
            throw new ClifException("ISAC can't get jndiPort because the specified jndiPort is not valid: " + value);
        }
    }

    private SessionObject(SessionObject so) {
        this.nbMsg = so.nbMsg;
        this.consWeight = so.consWeight;
        this.clusterQueueName = so.clusterQueueName;
        this.connectionFactoryName = so.connectionFactoryName;
        this.messageSize = so.messageSize;
        this.prodWeight = so.prodWeight;
        this.jndiHost = so.jndiHost;
        this.jndiPort = so.jndiPort;
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
    }

    public void reset() {
    }

    public String doGet(String var) {
        throw new IsacRuntimeException("Unknown parameter value in ~JMSInjector~ ISAC plugin: " + var);
    }

    public ActionEvent doSample(int number, Map<String, String> params, ActionEvent report) {
        switch (number) {
            case 1: {
                return this.doStartConsumer(number, params, report);
            }
            case 0: {
                return this.doStartProducer(number, params, report);
            }
        }
        throw new Error("Unable to find this sample in ~JMSInjector~ ISAC plugin: " + number);
    }

    public ActionEvent doStartConsumer(int number, Map<String, String> params, ActionEvent report) {
        try {
            int i;
            this.consWeight = new Integer(params.get(PLUGIN_CONSWEIGHT));
            this.nbMsg = new Integer(params.get(PLUGIN_NBMSG));
            if (this.consWeight == 0) {
                this.consWeight = 1;
            }
            this.prodWeight = 0;
            System.setProperty("joram.clusterQueue", this.clusterQueueName);
            System.setProperty("joram.prodWeight", "" + this.prodWeight);
            System.setProperty("joram.consWeight", "" + this.consWeight);
            System.setProperty("registry.hostname", this.jndiHost);
            System.out.println();
            System.out.println("Consumes " + this.nbMsg + " messages on the cluster queue " + this.clusterQueueName);
            System.out.println("prodWeight = " + this.prodWeight + ", consWeight = " + this.consWeight);
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "fr.dyade.aaa.jndi2.client.NamingContextFactory");
            env.put("java.naming.factory.host", this.jndiHost);
            env.put("java.naming.factory.port", this.jndiPort);
            InitialContext ictx = new InitialContext(env);
            Destination clusterQueue = (Destination)ictx.lookup(this.clusterQueueName);
            ConnectionFactory ccf = (ConnectionFactory)ictx.lookup(this.connectionFactoryName);
            ictx.close();
            System.out.println("RMIRegistry for manager on " + System.getProperty("registry.hostname"));
            Connection cnx = ccf.createConnection("user", "user");
            Session sess = cnx.createSession(true, 0);
            MessageConsumer recv = sess.createConsumer(clusterQueue);
            long firstTime = System.currentTimeMillis();
            System.out.println("First time = " + firstTime);
            cnx.start();
            System.out.println("location = " + System.getProperty("location"));
            String loc = System.getProperty("location");
            for (i = 0; i < this.nbMsg; ++i) {
                recv.receive();
                try {
                    sess.commit();
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Failed on Message number " + i);
                    e.printStackTrace();
                }
            }
            long lastTime = System.currentTimeMillis();
            System.out.println("Last time = " + lastTime);
            float average = (float)(lastTime - firstTime) * 1.0f / (float)this.nbMsg;
            System.out.println("Average time between each reading: " + average);
            System.out.println("Message number" + i + " read");
            System.out.println("location = " + System.getProperty("location"));
            System.setProperty("joram.clusterQueue", this.clusterQueueName);
            System.setProperty("joram.prodWeight", "" + this.prodWeight);
            System.setProperty("joram.consWeight", "" + this.consWeight);
            System.setProperty("location", "" + loc);
            cnx.close();
            report.successful = true;
            report.comment = "Consumer succeded";
            System.out.println("Consumer succeded");
        }
        catch (Exception e) {
            report.successful = false;
            report.result = e.toString();
            report.comment = "ISAC JMSInjector error occured";
            System.out.println("ISAC JMSInjector error occured. ");
            e.printStackTrace();
        }
        return report;
    }

    public ActionEvent doStartProducer(int number, Map<String, String> params, ActionEvent report) {
        try {
            int i;
            this.prodWeight = new Integer(params.get(PLUGIN_PRODWEIGHT));
            this.nbMsg = new Integer(params.get(PLUGIN_NBMSG));
            if (this.prodWeight == 0) {
                this.prodWeight = 1;
            }
            this.consWeight = 0;
            System.setProperty("joram.clusterQueue", this.clusterQueueName);
            System.setProperty("joram.prodWeight", "" + this.prodWeight);
            System.setProperty("joram.consWeight", "" + this.consWeight);
            System.setProperty("registry.hostname", this.jndiHost);
            System.out.println();
            System.out.println("Produces " + this.nbMsg + " messages on the cluster queue " + this.clusterQueueName);
            System.out.println("prodWeight = " + this.prodWeight + ", consWeight = " + this.consWeight);
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "fr.dyade.aaa.jndi2.client.NamingContextFactory");
            env.put("java.naming.factory.host", this.jndiHost);
            env.put("java.naming.factory.port", this.jndiPort);
            InitialContext ictx = new InitialContext(env);
            Destination clusterQueue = (Destination)ictx.lookup(this.clusterQueueName);
            ConnectionFactory ccf = (ConnectionFactory)ictx.lookup(this.connectionFactoryName);
            ictx.close();
            Connection cnx = ccf.createConnection("user", "user");
            Session sess = cnx.createSession(true, 0);
            MessageProducer producer = sess.createProducer(clusterQueue);
            TextMessage msg = sess.createTextMessage();
            long firstTime = System.currentTimeMillis();
            System.out.println("location = " + System.getProperty("location"));
            System.out.println("First time = " + firstTime);
            String loc = System.getProperty("location");
            for (i = 0; i < this.nbMsg; ++i) {
                msg.setText("Location: " + System.getProperty("location") + ", Test number " + i + new String(new char[this.messageSize - 30]));
                producer.send((Message)msg);
                try {
                    sess.commit();
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Failed on Message number " + i);
                    e.printStackTrace();
                }
            }
            long lastTime = System.currentTimeMillis();
            System.out.println("Last time = " + lastTime);
            float average = (float)(lastTime - firstTime) * 1.0f / (float)this.nbMsg;
            System.out.println("Average time between each writing: " + average);
            System.out.println("Message number " + i + " writed");
            System.setProperty("joram.clusterQueue", this.clusterQueueName);
            System.setProperty("joram.prodWeight", "" + this.prodWeight);
            System.setProperty("joram.consWeight", "" + this.consWeight);
            System.setProperty("location", "" + loc);
            cnx.close();
            report.successful = true;
            report.comment = "Producer succeded";
            System.out.println("Producer succeded");
        }
        catch (Exception e) {
            report.successful = false;
            report.result = e.toString();
            report.comment = "ISAC JMSInjector error occured";
            System.out.println("ISAC JMSInjector error occured. ");
            e.printStackTrace();
        }
        return report;
    }
}

