/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.random;

import java.util.Map;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SampleAction;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TimerAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;
import org.ow2.clif.storage.api.ActionEvent;
import org.ow2.clif.util.Random;

public class SessionObject
extends Random
implements SessionObjectAction,
SampleAction,
TimerAction,
ControlAction,
DataProvider {
    static final int CONTROL_SETDIRAC = 0;
    static final String CONTROL_SETDIRAC_VALUE = "value";
    static final int CONTROL_SETUNIFORM = 1;
    static final String CONTROL_SETUNIFORM_MAX = "max";
    static final String CONTROL_SETUNIFORM_MIN = "min";
    static final int CONTROL_SETPOISSON = 2;
    static final String CONTROL_SETPOISSON_PARAMETER = "parameter";
    static final String CONTROL_SETPOISSON_UNIT = "unit";
    static final int CONTROL_SETGAUSSIAN = 3;
    static final String CONTROL_SETGAUSSIAN_DEVIATION = "deviation";
    static final String CONTROL_SETGAUSSIAN_MEAN = "mean";
    static final String CONTROL_SETGAUSSIAN_MAX = "max";
    static final String CONTROL_SETGAUSSIAN_MIN = "min";
    static final int CONTROL_SETNEGATIVEEXPO = 4;
    static final String CONTROL_SETNEGATIVEEXPO_MEAN = "mean";
    static final String CONTROL_SETNEGATIVEEXPO_MIN = "min";
    static final int TIMER_SLEEP = 0;
    static final int SAMPLE_ACTION = 0;
    static final String SAMPLE_ACTION_TYPE = "type";
    static final String SAMPLE_ACTION_COMMENT = "comment";
    static final String SAMPLE_ACTION_SUCCESSFUL = "successful";
    static final String GET_STRING = "string";
    static final String GET_INT = "int";
    public static final String ENABLE_CBX = "enable";
    private static final long serialVersionUID = -592953548394386633L;
    private int min = 0;
    private int max = 0;
    private int unit = 1;
    private double mean = 0.0;
    private double deviation = 0.0;
    private int mode = 0;

    private long random() {
        switch (this.mode) {
            case 0: {
                return this.min;
            }
            case 1: {
                return this.nextUniform(this.min, this.max);
            }
            case 2: {
                return this.nextPoisson(this.mean, this.unit);
            }
            case 3: {
                return this.nextGaussian(this.min, this.max, (int)this.mean, (int)this.deviation);
            }
            case 4: {
                return this.nextNegativeExponential(this.min, (int)this.mean);
            }
        }
        throw new Error("unknown random mode " + this.mode);
    }

    public SessionObject() {
    }

    public SessionObject(Map<String, String> params) {
        this();
    }

    public Object createNewSessionObject() {
        return new SessionObject();
    }

    public void reset() {
    }

    public void close() {
    }

    public ActionEvent doSample(int number, Map<String, String> params, ActionEvent report) {
        report.setDate(System.currentTimeMillis());
        long value = this.random();
        try {
            Thread.sleep(value);
        }
        catch (UnknownIdentifierError e) {
            e.setAction("sample");
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        report.duration = (int)(System.currentTimeMillis() - report.getDate());
        report.successful = ParameterParser.getCheckBox((String)params.get(SAMPLE_ACTION_SUCCESSFUL)).contains(ENABLE_CBX);
        report.result = Long.valueOf(value);
        report.type = params.get(SAMPLE_ACTION_TYPE);
        if (report.type == null || report.type.trim().isEmpty()) {
            report.type = "dummy action";
        }
        report.comment = params.get(SAMPLE_ACTION_COMMENT);
        if (report.comment == null) {
            report.comment = "";
        }
        return report;
    }

    public long doTimer(int number, Map<String, String> params) {
        try {
            return this.random();
        }
        catch (UnknownIdentifierError e) {
            e.setAction("timer");
            throw e;
        }
    }

    public String doGet(String arg) {
        long value = this.random();
        if (arg.equals(GET_INT)) {
            return String.valueOf(value);
        }
        if (arg.equals(GET_STRING)) {
            return this.nextStringBuilder((int)value).toString();
        }
        throw new IsacRuntimeException("Unknown variable in ISAC plug-in Random: " + arg);
    }

    public void doControl(int id, Map<String, String> params) {
        switch (id) {
            case 0: {
                this.min = Integer.parseInt(params.get(CONTROL_SETDIRAC_VALUE));
                this.mode = 0;
                break;
            }
            case 1: {
                this.min = Integer.parseInt(params.get("min"));
                this.max = Integer.parseInt(params.get("max"));
                this.mode = 1;
                break;
            }
            case 2: {
                this.mean = Double.parseDouble(params.get(CONTROL_SETPOISSON_PARAMETER));
                this.unit = params.containsKey(CONTROL_SETPOISSON_UNIT) ? Integer.parseInt(params.get(CONTROL_SETPOISSON_UNIT)) : 1;
                this.mode = 2;
                break;
            }
            case 3: {
                this.min = Integer.parseInt(params.get("min"));
                this.max = Integer.parseInt(params.get("max"));
                this.mean = Integer.parseInt(params.get("mean"));
                this.deviation = Integer.parseInt(params.get(CONTROL_SETGAUSSIAN_DEVIATION));
                this.mode = 3;
                break;
            }
            case 4: {
                this.min = Integer.parseInt(params.get("min"));
                this.mean = Integer.parseInt(params.get("mean"));
                this.mode = 4;
                break;
            }
            default: {
                throw new UnknownIdentifierError(id);
            }
        }
    }

    private static class UnknownIdentifierError
    extends Error {
        private static final long serialVersionUID = -859973658854852340L;
        private final int number;
        private String action;

        private UnknownIdentifierError(int number) {
            this.number = number;
        }

        private void setAction(String action) {
            this.action = action;
        }

        @Override
        public String getMessage() {
            return "Fatal error in plug-in " + SessionObject.class.getName() + ": unknown " + (this.action != null ? this.action + " " : "") + "identifier: " + this.number;
        }
    }
}

