/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.rtpinjector;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.ow2.clif.probe.rtp.AppPacket;
import org.ow2.clif.probe.rtp.ByePacket;
import org.ow2.clif.probe.rtp.ParticipantStats;
import org.ow2.clif.probe.rtp.RTCPPacket;
import org.ow2.clif.probe.rtp.RTPInformation;
import org.ow2.clif.probe.rtp.RTPListener;
import org.ow2.clif.probe.rtp.RTPPacket;
import org.ow2.clif.probe.rtp.RTPSession;
import org.ow2.clif.probe.rtp.RTPStats;
import org.ow2.clif.probe.rtp.ReportPacket;
import org.ow2.clif.probe.rtp.SDESPacket;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SampleAction;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;
import org.ow2.clif.storage.api.ActionEvent;
import org.ow2.clif.supervisor.api.ClifException;
import org.ow2.clif.util.ClifClassLoader;
import org.ow2.isac.plugin.rtpinjector.RTPInstance;

public class SessionObject
implements SessionObjectAction,
DataProvider,
TestAction,
ControlAction,
SampleAction {
    static final int TEST_ISRTCPBYE = 22;
    static final String TEST_ISRTCPBYE_SESSION_ID = "Session ID";
    static final String TEST_ISRTCPBYE_NOTCHOICE = "notChoice";
    static final int CONTROL_SEND = 8;
    static final String CONTROL_SEND_SESSION_ID = "Session ID";
    static final String CONTROL_SEND_PAYLOADTYPE = "payloadType";
    static final String CONTROL_SEND_MARKER = "marker";
    static final String CONTROL_SEND_CSRCCOUNT = "csrcCount";
    static final String CONTROL_SEND_EXTENSION = "extension";
    static final String CONTROL_SEND_PADDING = "padding";
    static final String CONTROL_SEND_VERSION = "version";
    static final String CONTROL_SEND_TIME = "time";
    static final String CONTROL_SEND_CONTENT = "content";
    static final int CONTROL_FORWARD = 9;
    static final String CONTROL_FORWARD_SESSION_ID = "Session ID";
    static final String CONTROL_FORWARD_PACKETSIZE = "packetSize";
    static final String CONTROL_FORWARD_DURATION = "duration";
    static final String CONTROL_FORWARD_LISTENINGPORT = "listeningPort";
    static final int CONTROL_INITRTP = 11;
    static final String CONTROL_INITRTP_SESSION_ID = "Session ID";
    static final String CONTROL_INITRTP_DURATION = "duration";
    static final String CONTROL_INITRTP_TIMEOUT = "timeOut";
    static final String CONTROL_INITRTP_REMOTEPORT = "remotePort";
    static final String CONTROL_INITRTP_REMOTEADDRESS = "remoteAddress";
    static final String CONTROL_INITRTP_LOCALPORT = "localPort";
    static final String CONTROL_INITRTP_LOCALIPADDRESS = "localIpAddress";
    static final int CONTROL_DTMF = 12;
    static final String CONTROL_DTMF_SESSION_ID = "Session ID";
    static final String CONTROL_DTMF_PAYLOADTYPE = "payloadType";
    static final String CONTROL_DTMF_MARKER = "marker";
    static final String CONTROL_DTMF_CSRCCOUNT = "csrcCount";
    static final String CONTROL_DTMF_EXTENSION = "extension";
    static final String CONTROL_DTMF_PADDING = "padding";
    static final String CONTROL_DTMF_VERSION = "version";
    static final String CONTROL_DTMF_DTMFTYPE = "dtmfType";
    static final String CONTROL_DTMF_VOLUME = "volume";
    static final String CONTROL_DTMF_TIME = "time";
    static final String CONTROL_DTMF_DIGIT = "digit";
    static final int CONTROL_ENABLERTCP = 13;
    static final String CONTROL_ENABLERTCP_SESSION_ID = "Session ID";
    static final String CONTROL_ENABLERTCP_TIMEINTERVAL = "timeInterval";
    static final int CONTROL_ADDREPORT = 14;
    static final String CONTROL_ADDREPORT_SESSION_ID = "Session ID";
    static final int CONTROL_ADDSDES = 16;
    static final String CONTROL_ADDSDES_SESSION_ID = "Session ID";
    static final String CONTROL_ADDSDES_ITEMS = "items";
    static final int CONTROL_ADDBYE = 17;
    static final String CONTROL_ADDBYE_SESSION_ID = "Session ID";
    static final String CONTROL_ADDBYE_REASON = "reason";
    static final int CONTROL_ADDAPP = 18;
    static final String CONTROL_ADDAPP_SESSION_ID = "Session ID";
    static final String CONTROL_ADDAPP_SUBTYPE = "subtype";
    static final String CONTROL_ADDAPP_DATA = "data";
    static final String CONTROL_ADDAPP_NAME = "name";
    static final int CONTROL_RESETRTCPPACKET = 19;
    static final String CONTROL_RESETRTCPPACKET_SESSION_ID = "Session ID";
    static final int CONTROL_SENDBYE = 20;
    static final String CONTROL_SENDBYE_SESSION_ID = "Session ID";
    static final String CONTROL_SENDBYE_REASON = "reason";
    static final int CONTROL_SENDRECEIVERREPORT = 21;
    static final String CONTROL_SENDRECEIVERREPORT_SESSION_ID = "Session ID";
    private LinkedList<RTPInstance> rtpSessions = new LinkedList();
    public RTPListener rtpListener;
    public RTPStats rtpStats;

    private RTPInstance findMyInstance(String myInstanceId) {
        RTPInstance myInst = null;
        for (RTPInstance currentInst : this.rtpSessions) {
            if (currentInst.sipSession.compareTo(myInstanceId) != 0) continue;
            myInst = currentInst;
            break;
        }
        return myInst;
    }

    public SessionObject(Hashtable<String, String> params) {
    }

    private SessionObject(SessionObject so) {
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
        boolean rtpStatsInUse = false;
        for (RTPInstance currentInst : this.rtpSessions) {
            currentInst.rtpSession.close();
            if (!currentInst.enableRtcp) continue;
            rtpStatsInUse = true;
        }
        if (this.rtpListener != null) {
            if (rtpStatsInUse) {
                this.rtpStats.close();
            } else {
                this.rtpListener.close();
            }
        }
        this.rtpSessions.clear();
    }

    public void reset() {
    }

    public String doGet(String var) {
        throw new IsacRuntimeException("Unknown parameter value in ~RtpInjector~ ISAC plugin: " + var);
    }

    public boolean doTest(int number, Map params) {
        boolean result = false;
        switch (number) {
            case 22: {
                RTPInstance myInstance = this.findMyInstance((String)params.get("Session ID"));
                if (!myInstance.enableRtcp) break;
                if (((String)params.get(TEST_ISRTCPBYE_NOTCHOICE)).compareTo("") == 0) {
                    result = this.isRtcpBye(myInstance);
                    break;
                }
                result = this.isNotRtcpBye(myInstance);
                break;
            }
            default: {
                throw new Error("Unable to find this test in ~RtpInjector~ ISAC plugin: " + number);
            }
        }
        return result;
    }

    public boolean isRtcpBye(RTPInstance myInstance) {
        ArrayList byeList = this.rtpStats.getByeList();
        boolean result = false;
        for (int i = 0; i < byeList.size(); ++i) {
            if (myInstance.remotePort.compareTo(((ParticipantStats)byeList.get(i)).getPort()) != 0) continue;
            result = true;
        }
        return result;
    }

    public boolean isNotRtcpBye(RTPInstance myInstance) {
        ArrayList byeList = this.rtpStats.getByeList();
        boolean result = true;
        for (int i = 0; i < byeList.size(); ++i) {
            if (myInstance.remotePort.compareTo(((ParticipantStats)byeList.get(i)).getPort()) != 0) continue;
            result = false;
        }
        return result;
    }

    public void doControl(int number, Map params) {
        switch (number) {
            case 21: {
                this.sendReceiverReport(params);
                break;
            }
            case 20: {
                this.sendBye(params);
                break;
            }
            case 19: {
                this.resetRtcp(params);
                break;
            }
            case 18: {
                this.addApp(params);
                break;
            }
            case 17: {
                this.addBye(params);
                break;
            }
            case 16: {
                this.addSdes(params);
                break;
            }
            case 14: {
                this.addReport(params);
                break;
            }
            case 13: {
                this.enableRtcp(params);
                break;
            }
            case 12: {
                this.dtmf(params);
                break;
            }
            case 11: {
                this.initRtp(params);
                break;
            }
            case 9: {
                this.forwardStream(params);
                break;
            }
            case 8: {
                this.sendFile(params);
                break;
            }
            default: {
                throw new Error("Unable to find this control in ~RtpInjector~ ISAC plugin: " + number);
            }
        }
    }

    public void initRtp(Map params) {
        RTPInstance newInstance = new RTPInstance();
        newInstance.sipSession = ((String)params.get("Session ID")).compareTo("") != 0 ? (String)params.get("Session ID") : null;
        try {
            newInstance.localIp = ((String)params.get(CONTROL_INITRTP_LOCALIPADDRESS)).compareTo("") != 0 ? InetAddress.getByName((String)params.get(CONTROL_INITRTP_LOCALIPADDRESS)) : null;
            newInstance.localPort = new Integer((String)params.get(CONTROL_INITRTP_LOCALPORT));
            newInstance.remoteIp = InetAddress.getByName((String)params.get(CONTROL_INITRTP_REMOTEADDRESS));
            newInstance.remotePort = new Integer((String)params.get(CONTROL_INITRTP_REMOTEPORT));
        }
        catch (UnknownHostException e) {
            throw new IsacRuntimeException("Unable to create InetAddress : " + e);
        }
        newInstance.timeout = new Integer((String)params.get(CONTROL_INITRTP_TIMEOUT));
        newInstance.durationPacket = new Integer((String)params.get("duration"));
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.add(newInstance.localPort);
        this.rtpListener = RTPListener.getInstance();
        this.rtpListener.openSocket(newInstance.localIp, ports);
        this.rtpListener.startListener();
        Double duration = new Double(newInstance.durationPacket.intValue());
        newInstance.rtpSession = new RTPSession(Integer.valueOf(0), Long.valueOf(0L), Long.valueOf(0L), duration, newInstance.localPort);
        this.rtpSessions.add(newInstance);
    }

    public void sendFile(Map params) {
        URL soundUrl;
        RTPInstance myInstance = this.findMyInstance((String)params.get("Session ID"));
        Integer version = 2;
        Integer padding = 0;
        Integer extension = 0;
        Integer csrcCount = 1;
        Integer marker = 0;
        Integer payloadType = 0;
        if (((String)params.get("version")).compareTo("") != 0) {
            version = new Integer((String)params.get("version"));
        }
        if (((String)params.get("padding")).compareTo("") != 0) {
            padding = new Integer((String)params.get("padding"));
        }
        if (((String)params.get("extension")).compareTo("") != 0) {
            extension = new Integer((String)params.get("extension"));
        }
        if (((String)params.get("csrcCount")).compareTo("") != 0) {
            csrcCount = new Integer((String)params.get("csrcCount"));
        }
        if (((String)params.get("marker")).compareTo("") != 0) {
            marker = new Integer((String)params.get("marker"));
        }
        if (((String)params.get("payloadType")).compareTo("") != 0) {
            payloadType = new Integer((String)params.get("payloadType"));
        }
        AudioInputStream audioInputStream = null;
        try {
            soundUrl = ClifClassLoader.getClassLoader().findResource((String)params.get(CONTROL_SEND_CONTENT));
        }
        catch (ClifException e1) {
            throw new IsacRuntimeException("ClifException : " + (Object)((Object)e1), (Exception)((Object)e1));
        }
        Long startTime = System.currentTimeMillis();
        Long stopTime = new Long((String)params.get("time"));
        int availableSize = 0;
        Long packetSum = 0L;
        Long octetSum = 0L;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(soundUrl);
            availableSize = audioInputStream.available();
        }
        catch (IOException e) {
            throw new IsacRuntimeException("IOException : " + e, (Exception)e);
        }
        catch (UnsupportedAudioFileException e) {
            throw new IsacRuntimeException("UnsupportedAudioFileException : " + e, (Exception)e);
        }
        AudioFormat audioFormat = audioInputStream.getFormat();
        int size = new Double((double)((float)myInstance.durationPacket.intValue() * audioFormat.getSampleRate()) * 0.001).intValue();
        byte[] buffer = new byte[size];
        myInstance.rtpSession.setSampling(Float.valueOf(audioFormat.getSampleRate()));
        int packetNumber = availableSize / size;
        while (System.currentTimeMillis() - startTime < stopTime) {
            try {
                audioInputStream = AudioSystem.getAudioInputStream(soundUrl);
            }
            catch (IOException e) {
                throw new IsacRuntimeException("IOException : " + e);
            }
            catch (UnsupportedAudioFileException e) {
                throw new IsacRuntimeException("UnsupportedAudioFileException : " + e);
            }
            for (int i = 0; i <= packetNumber && System.currentTimeMillis() - startTime <= stopTime; ++i) {
                try {
                    audioInputStream.read(buffer);
                }
                catch (IOException e) {
                    throw new IsacRuntimeException("Unable to read file : " + e);
                }
                RTPPacket rtpPacket = new RTPPacket(payloadType, myInstance.rtpSession.getSequenceNumber(), myInstance.rtpSession.getTimestamp(), myInstance.rtpSession.getSsrc(), buffer);
                myInstance.rtpSession.setPayloadType(payloadType);
                rtpPacket.setVersion(version);
                rtpPacket.setPadding(padding);
                rtpPacket.setExtension(extension);
                rtpPacket.setCsrcCount(csrcCount);
                rtpPacket.setMarker(marker);
                myInstance.sendRtpPacket(this.rtpListener, rtpPacket.createRtpPacket());
                Long l = packetSum;
                Long l2 = packetSum = Long.valueOf(packetSum + 1L);
                octetSum = octetSum + (long)buffer.length;
                if (myInstance.enableRtcp && new Long(System.currentTimeMillis() - myInstance.lastRtcpTime).compareTo(myInstance.timeInterval) >= 0) {
                    LinkedList<byte[]> dataList = new LinkedList<byte[]>();
                    Integer offset = 0;
                    ArrayList partStatTable = this.rtpStats.getParticipantsStats();
                    for (int j = 0; j < myInstance.rtcpTemplate.size(); ++j) {
                        RTCPPacket rtcpPacket = myInstance.rtcpTemplate.get(j);
                        if (rtcpPacket.getPacketType().compareTo(201) == 0) {
                            ((ReportPacket)rtcpPacket).receiverToSender();
                        }
                        if (rtcpPacket.getPacketType().compareTo(200) == 0) {
                            ((ReportPacket)rtcpPacket).setNewValues(myInstance.rtpSession.getTimestamp(), packetSum, octetSum);
                            for (int k = 0; k < partStatTable.size(); ++k) {
                                if (myInstance.rtpSession.getPort().compareTo(((ParticipantStats)partStatTable.get(k)).getPort()) != 0) continue;
                                Long dlsr = 0L;
                                if (!((ParticipantStats)partStatTable.get(k)).getFirstReport()) {
                                    dlsr = System.currentTimeMillis() - ((ParticipantStats)partStatTable.get(k)).getDlsr();
                                }
                                ((ReportPacket)rtcpPacket).addReportBlock(((ParticipantStats)partStatTable.get(k)).getSsrc(), ((ParticipantStats)partStatTable.get(k)).getFractionLost(), ((ParticipantStats)partStatTable.get(k)).getCumulativePacketLost(), ((ParticipantStats)partStatTable.get(k)).getCycle(), ((ParticipantStats)partStatTable.get(k)).getSeqNumMax(), ((ParticipantStats)partStatTable.get(k)).getTimeJitter(), ((ParticipantStats)partStatTable.get(k)).getLsr(), dlsr);
                            }
                        }
                        dataList.add(rtcpPacket.createPacket());
                    }
                    Integer length = 0;
                    for (int j = 0; j < dataList.size(); ++j) {
                        length = length + ((byte[])dataList.get(j)).length;
                    }
                    byte[] data = new byte[length.intValue()];
                    while (!dataList.isEmpty()) {
                        byte[] tempData = (byte[])dataList.removeFirst();
                        for (int j = 0; j < tempData.length; ++j) {
                            data[offset.intValue() + j] = tempData[j];
                        }
                        offset = offset + tempData.length;
                    }
                    myInstance.sendRtpPacket(this.rtpListener, data);
                    myInstance.lastRtcpTime = System.currentTimeMillis();
                }
                myInstance.rtpSession.incrementSequenceNumber();
                myInstance.rtpSession.incrementTimestamp();
            }
            if (((String)params.get("time")).compareTo("") != 0) continue;
        }
        try {
            audioInputStream.close();
        }
        catch (IOException e) {
            throw new IsacRuntimeException("Unable to close input stream : " + e);
        }
        if (myInstance.enableBye) {
            ByePacket byePacket = new ByePacket();
            byePacket.addSsrc(myInstance.rtpSession.getSsrc(), myInstance.reason);
            myInstance.sendRtcpPacket(this.rtpListener, byePacket.createPacket());
        }
    }

    public void forwardStream(Map params) {
        RTPInstance myInstance = this.findMyInstance((String)params.get("Session ID"));
        Integer listeningPort = new Integer((String)params.get(CONTROL_FORWARD_LISTENINGPORT));
        Integer packetSize = new Integer((String)params.get(CONTROL_FORWARD_PACKETSIZE));
        Long startTime = System.currentTimeMillis();
        Long stopTime = new Long((String)params.get("duration"));
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.add(listeningPort);
        this.rtpListener = RTPListener.getInstance();
        this.rtpListener.openSocket(myInstance.localIp, ports);
        this.rtpListener.startListener();
        while (System.currentTimeMillis() - startTime < stopTime) {
            LinkedList rtpTable = this.rtpListener.getPackets(myInstance.timeout);
            LinkedList<DatagramPacket> dtgTable = new LinkedList<DatagramPacket>();
            while (!rtpTable.isEmpty()) {
                dtgTable.addLast(new DatagramPacket(((RTPInformation)rtpTable.removeFirst()).getData(), packetSize));
            }
            while (!dtgTable.isEmpty()) {
                myInstance.sendRtpPacket(this.rtpListener, ((DatagramPacket)dtgTable.removeFirst()).getData());
            }
        }
    }

    public void dtmf(Map params) {
        RTPInstance myInstance = this.findMyInstance((String)params.get("Session ID"));
        Integer version = 2;
        Integer padding = 0;
        Integer extension = 0;
        Integer csrcCount = 1;
        Integer marker = -1;
        Integer payloadType = 101;
        if (((String)params.get("version")).compareTo("") != 0) {
            version = new Integer((String)params.get("version"));
        }
        if (((String)params.get("padding")).compareTo("") != 0) {
            padding = new Integer((String)params.get("padding"));
        }
        if (((String)params.get("extension")).compareTo("") != 0) {
            extension = new Integer((String)params.get("extension"));
        }
        if (((String)params.get("csrcCount")).compareTo("") != 0) {
            csrcCount = new Integer((String)params.get("csrcCount"));
        }
        if (((String)params.get("marker")).compareTo("") != 0) {
            marker = new Integer((String)params.get("marker"));
        }
        if (((String)params.get("payloadType")).compareTo("") != 0) {
            payloadType = new Integer((String)params.get("payloadType"));
        }
        Integer volume = 7;
        Integer end = 0;
        Double duration = 1200.0;
        Integer position = 0;
        String digit = "1";
        Integer durationEvent = 0;
        if (((String)params.get(CONTROL_DTMF_VOLUME)).compareTo("") != 0) {
            volume = new Integer((String)params.get(CONTROL_DTMF_VOLUME));
        }
        if (((String)params.get("time")).compareTo("") != 0) {
            duration = new Double((String)params.get("time"));
        }
        if (((String)params.get(CONTROL_DTMF_DIGIT)).compareTo("") != 0) {
            digit = (String)params.get(CONTROL_DTMF_DIGIT);
        }
        Integer packetNumber = new Long(Math.round(duration / (double)myInstance.durationPacket.intValue())).intValue();
        myInstance.rtpSession.setDuration(new Double(myInstance.durationPacket.intValue()));
        myInstance.rtpSession.setSampling(Float.valueOf(8000.0f));
        for (int i = 0; i <= packetNumber; ++i) {
            if (((String)params.get(CONTROL_DTMF_DTMFTYPE)).compareTo("rfc2833") == 0) {
                byte[] data = new byte[4];
                if (i == packetNumber) {
                    end = 1;
                }
                data = this.createRtpDtmf(digit, volume, durationEvent, end);
                durationEvent = durationEvent + myInstance.durationPacket;
                RTPPacket rtpPacket = new RTPPacket(payloadType, myInstance.rtpSession.getSequenceNumber(), myInstance.rtpSession.getTimestamp(), myInstance.rtpSession.getSsrc(), data);
                myInstance.rtpSession.setPayloadType(payloadType);
                rtpPacket.setVersion(version);
                rtpPacket.setPadding(padding);
                rtpPacket.setExtension(extension);
                rtpPacket.setCsrcCount(csrcCount);
                if (i == 0) {
                    rtpPacket.setMarker(Integer.valueOf(1));
                }
                if (marker.compareTo(-1) != 0) {
                    rtpPacket.setMarker(marker);
                }
                myInstance.sendRtpPacket(this.rtpListener, rtpPacket.createRtpPacket());
            }
            myInstance.rtpSession.incrementSequenceNumber();
        }
    }

    public byte[] createRtpDtmf(String key, int volume, int duration, int end) {
        byte[] dtmf = new byte[4];
        Integer digit = 0;
        Integer reserved = 0;
        digit = key.equalsIgnoreCase("*") ? Integer.valueOf(10) : (key.equalsIgnoreCase("#") ? Integer.valueOf(11) : (key.equalsIgnoreCase("A") ? Integer.valueOf(12) : (key.equalsIgnoreCase("B") ? Integer.valueOf(13) : (key.equalsIgnoreCase("C") ? Integer.valueOf(14) : (key.equalsIgnoreCase("D") ? Integer.valueOf(15) : new Integer(key))))));
        Integer header = digit & 0xFF;
        dtmf[0] = header.byteValue();
        header = end << 7 & 0x80;
        header = header | reserved << 6 & 0x40;
        header = header | volume & 0x3F;
        dtmf[1] = header.byteValue();
        header = duration >> 8;
        dtmf[2] = header.byteValue();
        header = duration & 0xFF;
        dtmf[3] = header.byteValue();
        return dtmf;
    }

    public void enableRtcp(Map params) {
        RTPInstance myInstance = this.findMyInstance((String)params.get("Session ID"));
        myInstance.enableRtcp = true;
        myInstance.timeInterval = ((String)params.get(CONTROL_ENABLERTCP_TIMEINTERVAL)).compareTo("") != 0 ? new Long((String)params.get(CONTROL_ENABLERTCP_TIMEINTERVAL)) : Long.valueOf(5000L);
        ArrayList<Integer> rtcpPort = new ArrayList<Integer>();
        rtcpPort.add(myInstance.localPort + 1);
        this.rtpStats = RTPStats.getInstance();
        this.rtpStats.openStats(rtcpPort);
        this.rtpStats.addRtcpPortToList(Integer.valueOf(myInstance.localPort + 1));
        this.rtpStats.startStats();
    }

    public void addReport(Map params) {
        RTPInstance myInstance = this.findMyInstance((String)params.get("Session ID"));
        myInstance.rtcpTemplate.add((RTCPPacket)new ReportPacket(myInstance.rtpSession.getSsrc()));
    }

    public void addSdes(Map params) {
        RTPInstance myInstance = this.findMyInstance((String)params.get("Session ID"));
        SDESPacket sdesPacket = new SDESPacket();
        List parametersTable = ParameterParser.getTable((String)((String)params.get(CONTROL_ADDSDES_ITEMS)));
        for (int i = 0; i < parametersTable.size(); ++i) {
            String[] line = ((List)parametersTable.get(i)).toString().split(", ", 2);
            line[0] = line[0].substring(1, line[0].length());
            line[1] = line[1].substring(0, line[1].length() - 1);
            Integer itemType = sdesPacket.getItemType(line[0]);
            if (itemType.compareTo(-1) == 0) continue;
            sdesPacket.addSdesItem(myInstance.rtpSession.getSsrc(), sdesPacket.createItem(itemType, line[1]));
        }
        myInstance.rtcpTemplate.add((RTCPPacket)sdesPacket);
    }

    public void addBye(Map params) {
        RTPInstance myInstance = this.findMyInstance((String)params.get("Session ID"));
        myInstance.enableBye = true;
        myInstance.reason = (String)params.get("reason");
    }

    public void addApp(Map params) {
        RTPInstance myInstance = this.findMyInstance((String)params.get("Session ID"));
        Integer subtype = new Integer((String)params.get(CONTROL_ADDAPP_SUBTYPE));
        String name = (String)params.get(CONTROL_ADDAPP_NAME);
        String data = (String)params.get(CONTROL_ADDAPP_DATA);
        AppPacket appPacket = new AppPacket(subtype, myInstance.rtpSession.getSsrc(), name, data);
        myInstance.rtcpTemplate.add((RTCPPacket)appPacket);
    }

    public void resetRtcp(Map params) {
        RTPInstance myInstance = this.findMyInstance((String)params.get("Session ID"));
        myInstance.enableRtcp = false;
        myInstance.enableBye = false;
        myInstance.timeInterval = null;
        myInstance.rtcpTemplate.clear();
    }

    public void sendBye(Map params) {
        RTPInstance myInstance = this.findMyInstance((String)params.get("Session ID"));
        ByePacket byePacket = new ByePacket();
        byePacket.addSsrc(myInstance.rtpSession.getSsrc(), (String)params.get("reason"));
        myInstance.sendRtcpPacket(this.rtpListener, byePacket.createPacket());
    }

    public void sendReceiverReport(Map params) {
        RTPInstance myInstance = this.findMyInstance((String)params.get("Session ID"));
        Integer offset = 0;
        LinkedList<byte[]> dataList = new LinkedList<byte[]>();
        if (new Long(System.currentTimeMillis() - myInstance.lastRtcpTime).compareTo(myInstance.timeInterval) >= 0) {
            ArrayList partStatTable = this.rtpStats.getParticipantsStats();
            for (int j = 0; j < myInstance.rtcpTemplate.size(); ++j) {
                RTCPPacket rtcpPacket = myInstance.rtcpTemplate.get(j);
                if (rtcpPacket.getPacketType().compareTo(200) == 0) {
                    ((ReportPacket)rtcpPacket).senderToReceiver();
                }
                if (rtcpPacket.getPacketType().compareTo(201) == 0) {
                    for (int k = 0; k < partStatTable.size(); ++k) {
                        if (myInstance.rtpSession.getPort().compareTo(((ParticipantStats)partStatTable.get(k)).getPort()) != 0) continue;
                        Long dlsr = 0L;
                        if (!((ParticipantStats)partStatTable.get(k)).getFirstReport()) {
                            dlsr = System.currentTimeMillis() - ((ParticipantStats)partStatTable.get(k)).getDlsr();
                        }
                        ((ReportPacket)rtcpPacket).addReportBlock(((ParticipantStats)partStatTable.get(k)).getSsrc(), ((ParticipantStats)partStatTable.get(k)).getFractionLost(), ((ParticipantStats)partStatTable.get(k)).getCumulativePacketLost(), ((ParticipantStats)partStatTable.get(k)).getCycle(), ((ParticipantStats)partStatTable.get(k)).getSeqNumMax(), ((ParticipantStats)partStatTable.get(k)).getTimeJitter(), ((ParticipantStats)partStatTable.get(k)).getLsr(), dlsr);
                    }
                }
                dataList.add(rtcpPacket.createPacket());
            }
            Integer length = 0;
            for (int j = 0; j < dataList.size(); ++j) {
                length = length + ((byte[])dataList.get(j)).length;
            }
            byte[] data = new byte[length.intValue()];
            while (!dataList.isEmpty()) {
                byte[] tempData = (byte[])dataList.removeFirst();
                for (int j = 0; j < tempData.length; ++j) {
                    data[offset.intValue() + j] = tempData[j];
                }
                offset = offset + tempData.length;
            }
            myInstance.sendRtcpPacket(this.rtpListener, data);
            myInstance.lastRtcpTime = System.currentTimeMillis();
        }
    }

    public ActionEvent doSample(int number, Map params, ActionEvent report) {
        switch (number) {
            default: 
        }
        throw new Error("Unable to find this sample in ~RtpInjector~ ISAC plugin: " + number);
    }
}

