/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.udpinjector;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SampleAction;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;
import org.ow2.clif.storage.api.ActionEvent;

public class SessionObject
implements SessionObjectAction,
DataProvider,
ControlAction,
SampleAction,
TestAction {
    static final String PLUGIN_UNIT = "unit";
    static final String PLUGIN_CHARSET = "charset";
    static final int TEST_ISCONNECTED = 4;
    static final int TEST_ISNOTCONNECTED = 5;
    static final int TEST_ISBOUND = 6;
    static final int TEST_ISNOTBOUND = 7;
    static final int TEST_ISCLOSED = 11;
    static final int TEST_ISNOTCLOSED = 12;
    static final int TEST_ISDEFINED = 17;
    static final String TEST_ISDEFINED_VARIABLE = "variable";
    static final int TEST_ISNOTDEFINED = 18;
    static final String TEST_ISNOTDEFINED_VARIABLE = "variable";
    static final int SAMPLE_CONNECT = 2;
    static final String SAMPLE_CONNECT_PORT = "port";
    static final String SAMPLE_CONNECT_HOST = "host";
    static final int SAMPLE_SEND = 13;
    static final String SAMPLE_SEND_COMMENT = "comment";
    static final String SAMPLE_SEND_DATA = "data";
    static final int SAMPLE_RECEIVE = 14;
    static final String SAMPLE_RECEIVE_COMMENT = "comment";
    static final String SAMPLE_RECEIVE_VARIABLE = "variable";
    static final int SAMPLE_STEAL = 15;
    static final String SAMPLE_STEAL_COMMENT = "comment";
    static final String SAMPLE_STEAL_BUFFER = "buffer";
    static final String SAMPLE_STEAL_PORT = "port";
    static final int SAMPLE_CONNECT2SENDER = 16;
    static final int CONTROL_BIND = 0;
    static final String CONTROL_BIND_PORT = "port";
    static final String CONTROL_BIND_HOST = "host";
    static final int CONTROL_CLOSE = 1;
    static final int CONTROL_DISCONNECT = 3;
    static final int CONTROL_SETRCVBUFSIZE = 8;
    static final String CONTROL_SETRCVBUFSIZE_SIZE = "size";
    static final int CONTROL_SETSNDBUFSIZE = 9;
    static final String CONTROL_SETSNDBUFSIZE_SIZE = "size";
    static final int CONTROL_SETTIMEOUT = 10;
    static final String CONTROL_SETTIMEOUT_TIMEOUT = "timeout";
    static final int CONTROL_CLEAR = 19;
    static final String CONTROL_CLEAR_VARIABLE = "variable";
    static final int CONTROL_CLEARALL = 20;
    static final String SEND_TYPE = "UDP SEND";
    static final String RECEIVE_TYPE = "UDP RECEIVE";
    static final String STEAL_TYPE = "UDP STEAL";
    static final String CONNECT_TYPE = "UDP CONNECT";
    static final SessionObject[] boundPorts = new SessionObject[65536];
    private Map<String, String> buffers;
    protected SocketAddress lastSenderAddress = null;
    private DatagramSocket socket = null;
    private String charset;
    private boolean microsecond = false;

    public SessionObject(Map<String, String> params) throws SocketException {
        this.charset = params.get(PLUGIN_CHARSET);
        if (this.charset == null || this.charset.trim().isEmpty()) {
            this.charset = Charset.defaultCharset().name();
        }
        String unit = ParameterParser.getRadioGroup((String)params.get(PLUGIN_UNIT));
        this.microsecond = unit.equalsIgnoreCase("microsecond");
    }

    private SessionObject(SessionObject so) throws SocketException {
        this.charset = so.charset;
        this.microsecond = so.microsecond;
        this.socket = new DatagramSocket((SocketAddress)null);
        this.buffers = new HashMap<String, String>();
    }

    public Object createNewSessionObject() throws IsacRuntimeException {
        try {
            return new SessionObject(this);
        }
        catch (SocketException ex) {
            throw new IsacRuntimeException("Can't create UDPinjector session object", (Exception)ex);
        }
    }

    public void close() {
        if (!this.socket.isClosed()) {
            if (this.socket.isBound()) {
                SessionObject.boundPorts[this.socket.getLocalPort()] = null;
            }
            this.socket.close();
        }
    }

    public void reset() throws IsacRuntimeException {
        this.buffers.clear();
        this.lastSenderAddress = null;
        this.socket.disconnect();
        this.close();
        try {
            this.socket = new DatagramSocket((SocketAddress)null);
        }
        catch (SocketException ex) {
            throw new IsacRuntimeException("UDPInjector can't reset session object.", (Exception)ex);
        }
    }

    public String doGet(String var) {
        return this.buffers.get(var);
    }

    public void doControl(int number, Map<String, String> params) {
        switch (number) {
            case 20: {
                this.buffers.clear();
                break;
            }
            case 19: {
                String variable = params.get("variable");
                if (variable == null) break;
                this.buffers.remove(variable);
                break;
            }
            case 10: {
                try {
                    this.socket.setSoTimeout(Integer.parseInt(params.get(CONTROL_SETTIMEOUT_TIMEOUT)));
                    break;
                }
                catch (SocketException ex) {
                    throw new IsacRuntimeException("Can't set UDPinjector socket timeout", (Exception)ex);
                }
            }
            case 9: {
                try {
                    this.socket.setSendBufferSize(Integer.parseInt(params.get("size")));
                    break;
                }
                catch (SocketException ex) {
                    throw new IsacRuntimeException("Can't set UDPinjector socket send buffer size", (Exception)ex);
                }
            }
            case 8: {
                try {
                    this.socket.setReceiveBufferSize(Integer.parseInt(params.get("size")));
                    break;
                }
                catch (SocketException ex) {
                    throw new IsacRuntimeException("Can't set UDPinjector socket receive buffer size", (Exception)ex);
                }
            }
            case 3: {
                this.socket.disconnect();
                break;
            }
            case 1: {
                this.close();
                break;
            }
            case 0: {
                try {
                    String hostname = params.get("host");
                    InetAddress host = null;
                    if (hostname != null) {
                        hostname = hostname.trim();
                        host = InetAddress.getByName(hostname);
                    }
                    int port = 0;
                    String portString = params.get("port");
                    try {
                        if (portString != null && !portString.isEmpty()) {
                            port = Integer.parseInt(portString);
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new IsacRuntimeException("Invalid port number for bind operation in UDPInjector:" + portString);
                    }
                    this.socket.bind(new InetSocketAddress(host, port));
                    SessionObject.boundPorts[this.socket.getLocalPort()] = this;
                    break;
                }
                catch (Exception ex) {
                    throw new IsacRuntimeException("Can't bind UDPinjector", ex);
                }
            }
            default: {
                throw new Error("Unable to find this control in ~UDPinjector~ ISAC plugin: " + number);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionEvent doSample(int number, Map<String, String> params, ActionEvent report) {
        switch (number) {
            case 16: {
                if (this.lastSenderAddress == null) {
                    throw new IsacRuntimeException("Attempt to connect to a packet sender but no packet received.");
                }
                report.type = CONNECT_TYPE;
                return this.connectTo(this.lastSenderAddress, report);
            }
            case 15: {
                int port = Integer.parseInt(params.get("port"));
                SessionObject target = boundPorts[port];
                if (target == null) {
                    throw new IsacRuntimeException("Attempt to steal from unbound UDP port " + port);
                }
                report.type = STEAL_TYPE;
                report.comment = params.get("comment");
                return SessionObject.receiveFrom(target, report, params.get(SAMPLE_STEAL_BUFFER).trim(), this.buffers);
            }
            case 14: {
                report.type = RECEIVE_TYPE;
                report.comment = params.get("comment");
                return SessionObject.receiveFrom(this, report, params.get("variable"), this.buffers);
            }
            case 13: {
                SessionObject port = this;
                synchronized (port) {
                    if (!this.socket.isConnected()) {
                        throw new IsacRuntimeException("UDPinjector must be connected before sending data.");
                    }
                    report.type = SEND_TYPE;
                    report.comment = params.get("comment");
                    report.setDate(System.currentTimeMillis());
                    long nanoStart = 0L;
                    if (this.microsecond) {
                        nanoStart = System.nanoTime();
                    }
                    try {
                        byte[] data = params.get(SAMPLE_SEND_DATA).getBytes(this.charset);
                        this.socket.send(new DatagramPacket(data, data.length));
                        report.duration = this.microsecond ? (int)((System.nanoTime() - nanoStart) / 1000L) : (int)(System.currentTimeMillis() - report.getDate());
                        report.result = String.valueOf(data.length) + " bytes";
                        report.successful = true;
                    }
                    catch (Exception ex) {
                        report.successful = false;
                        report.result = ex.toString();
                    }
                }
                return report;
            }
            case 2: {
                String host = params.get("host");
                int port = Integer.parseInt(params.get("port"));
                report.type = CONNECT_TYPE;
                return this.connectTo(new InetSocketAddress(host, port), report);
            }
        }
        throw new Error("Unable to find this sample in ~UDPinjector~ ISAC plugin: " + number);
    }

    public boolean doTest(int number, Map<String, String> params) {
        switch (number) {
            case 18: {
                String variable = params.get("variable");
                return variable == null || !this.buffers.containsKey(variable);
            }
            case 17: {
                String variable = params.get("variable");
                return variable != null && this.buffers.containsKey(variable);
            }
            case 12: {
                return !this.socket.isClosed();
            }
            case 11: {
                return this.socket.isClosed();
            }
            case 7: {
                return !this.socket.isBound();
            }
            case 6: {
                return this.socket.isBound();
            }
            case 5: {
                return !this.socket.isConnected();
            }
            case 4: {
                return this.socket.isConnected();
            }
        }
        throw new Error("Unable to find this test in ~UDPinjector~ ISAC plugin: " + number);
    }

    private ActionEvent connectTo(SocketAddress target, ActionEvent report) {
        report.setDate(System.currentTimeMillis());
        long nanoStart = 0L;
        if (this.microsecond) {
            nanoStart = System.nanoTime();
        }
        try {
            this.socket.connect(target);
            if (this.socket.isConnected()) {
                report.duration = this.microsecond ? (int)((System.nanoTime() - nanoStart) / 1000L) : (int)(System.currentTimeMillis() - report.getDate());
                report.successful = true;
                report.result = "connected to " + target;
            } else {
                report.successful = false;
                report.comment = "Can't connect UDPinjector socket to " + target;
                report.result = "connection failed";
            }
        }
        catch (SocketException ex) {
            report.successful = false;
            report.comment = "Can't connect UDPinjector socket to " + target;
            report.result = ex.toString();
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ActionEvent receiveFrom(SessionObject so, ActionEvent report, String bufferName, Map<String, String> buffers) throws IsacRuntimeException {
        SessionObject sessionObject = so;
        synchronized (sessionObject) {
            block10: {
                byte[] buffer;
                if (!so.socket.isBound()) {
                    throw new IsacRuntimeException("UDPinjector must be bound before receiving data.");
                }
                try {
                    buffer = new byte[so.socket.getReceiveBufferSize()];
                }
                catch (SocketException ex) {
                    throw new IsacRuntimeException("Can't get size of socket receive buffer in UDPinjector.", (Exception)ex);
                }
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                report.setDate(System.currentTimeMillis());
                long nanoStart = 0L;
                if (so.microsecond) {
                    nanoStart = System.nanoTime();
                }
                try {
                    so.socket.receive(packet);
                    report.duration = so.microsecond ? (int)((System.nanoTime() - nanoStart) / 1000L) : (int)(System.currentTimeMillis() - report.getDate());
                    report.successful = true;
                    report.result = String.valueOf(packet.getLength()) + " bytes on port " + so.socket.getLocalPort();
                    if (bufferName != null && !bufferName.equals("")) {
                        buffers.put(bufferName, new String(buffer, 0, packet.getLength(), so.charset));
                    }
                    so.lastSenderAddress = packet.getSocketAddress();
                }
                catch (Exception ex) {
                    report.successful = false;
                    report.result = ex.toString();
                    if (bufferName == null || bufferName.equals("")) break block10;
                    buffers.remove(bufferName);
                }
            }
        }
        return report;
    }
}

