/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jra;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static int getMatchScore(String reqUri, String resource) {
        int reqIdx = 0;
        for (int i = 0; i < resource.length(); ++i) {
            char c = resource.charAt(i);
            if (c == '{') {
                int next = resource.indexOf(125, i);
                if (next == -1) {
                    throw new IllegalStateException("Missing end bracket in URI " + resource);
                }
                int start = i;
                i = next + 1;
                if (i == resource.length()) {
                    return start - 1;
                }
                c = resource.charAt(i);
                int endMatch = reqUri.indexOf(c, reqIdx);
                if (endMatch == -1) {
                    return -1;
                }
                reqIdx = endMatch + 1;
                continue;
            }
            if (reqUri.length() <= reqIdx) {
                return -1;
            }
            if (c == reqUri.charAt(reqIdx)) {
                ++reqIdx;
                continue;
            }
            return -1;
        }
        return reqIdx;
    }

    public static Map<String, String> getURIParameters(String reqUri, String resource) {
        HashMap<String, String> params = new HashMap<String, String>();
        int reqIdx = 0;
        for (int i = 0; i < resource.length(); ++i) {
            char c = resource.charAt(i);
            if (c == '{') {
                int begToken = reqIdx;
                int next = resource.indexOf(125, i);
                if (next == -1) {
                    throw new IllegalStateException("Missing end bracket in URI " + resource);
                }
                String id = resource.substring(i + 1, next);
                i = next + 1;
                if (i == resource.length()) {
                    params.put(id, reqUri.substring(begToken));
                    return params;
                }
                c = resource.charAt(i);
                int endMatch = reqUri.indexOf(c, reqIdx);
                if (endMatch == -1) {
                    throw new IllegalStateException("Could not fully match the expression!");
                }
                params.put(id, reqUri.substring(begToken, endMatch));
                reqIdx = endMatch + 1;
                continue;
            }
            if (reqUri.length() <= reqIdx) {
                throw new IllegalStateException("Could not fully match the expression!");
            }
            if (c == reqUri.charAt(reqIdx)) {
                ++reqIdx;
                continue;
            }
            throw new IllegalStateException("Could not fully match the expression! " + reqIdx);
        }
        return params;
    }
}

