/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.ipprovider;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;
import org.ow2.clif.util.Network;

public class SessionObject
implements SessionObjectAction,
DataProvider,
ControlAction {
    static final String PLUGIN_UNIQUE = "unique";
    static final String PLUGIN_FILTERS = "filters";
    static final String PLUGIN_POLICY = "policy";
    static final int CONTROL_RELEASE = 1;
    static final int CONTROL_NEXT = 2;
    static final int POLICY_RANDOM = 0;
    static final String POLICY_RANDOM_STR = "random";
    static final int POLICY_ROUNDROBIN = 1;
    static final String UNIQUE_YES = "yes";
    static Random rand = new Random();
    private List<String> addresses;
    private String[] filters = null;
    private int allocationPolicy = 1;
    private boolean unique = false;
    private int rr_index = 0;
    private String myIP = null;

    public SessionObject(Map<String, String> params) {
        String policyStr = ParameterParser.getRadioGroup((String)params.get(PLUGIN_POLICY));
        this.allocationPolicy = policyStr.equals(POLICY_RANDOM_STR) ? 0 : 1;
        List filterList = ParameterParser.getNField((String)params.get(PLUGIN_FILTERS));
        this.filters = filterList.isEmpty() ? null : filterList.toArray(new String[filterList.size()]);
        this.unique = ParameterParser.getRadioGroup((String)params.get(PLUGIN_UNIQUE)).equals(UNIQUE_YES);
        InetAddress[] inetAddresses = Network.getInetAddresses();
        this.addresses = new ArrayList<String>(inetAddresses.length);
        for (int i = 0; i < inetAddresses.length; ++i) {
            if (this.filters == null) {
                this.addresses.add(inetAddresses[i].getHostAddress());
                continue;
            }
            for (int j = 0; j < this.filters.length; ++j) {
                if (!Network.belongsToSubnet((Inet4Address)((Inet4Address)inetAddresses[i]), (String)this.filters[j])) continue;
                this.addresses.add(inetAddresses[i].getHostAddress());
            }
        }
    }

    private SessionObject(SessionObject so) {
        this.filters = so.filters;
        this.allocationPolicy = so.allocationPolicy;
        this.unique = so.unique;
        this.addresses = so.addresses;
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
        this.releaseIP();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseIP() {
        if (this.unique && this.myIP != null) {
            List<String> list = this.addresses;
            synchronized (list) {
                this.addresses.add(this.myIP);
            }
        }
        this.myIP = null;
    }

    private void getIP() {
        this.releaseIP();
        if (this.addresses.isEmpty()) {
            throw new IsacRuntimeException("No more available IP address!");
        }
        if (this.allocationPolicy == 0) {
            this.myIP = this.addresses.get(rand.nextInt(this.addresses.size()));
        } else if (this.allocationPolicy == 1) {
            this.myIP = this.addresses.get(this.rr_index++);
            if (this.rr_index == this.addresses.size()) {
                this.rr_index = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireIP() {
        if (this.unique) {
            List<String> list = this.addresses;
            synchronized (list) {
                this.rr_index = 0;
                this.getIP();
                this.addresses.remove(this.myIP);
            }
        } else {
            this.getIP();
        }
    }

    public void reset() {
        this.releaseIP();
    }

    public String doGet(String var) {
        return this.myIP;
    }

    public void doControl(int number, Map<String, String> params) {
        switch (number) {
            case 2: {
                this.acquireIP();
                break;
            }
            case 1: {
                this.releaseIP();
                break;
            }
            default: {
                throw new Error("Unable to find this control in ~IPprovider~ ISAC plugin: " + number);
            }
        }
    }
}

