/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.api.type.InterfaceType;

public class BindingControllerHelper {
    private BindingControllerHelper() {
    }

    public static Set getFcServerItfsBoundTo(Component comp) {
        HashSet<Object> result = new HashSet<Object>();
        BindingController bc = null;
        Object[] itfs = comp.getFcInterfaces();
        for (int i = 0; i < itfs.length; ++i) {
            Interface itf;
            InterfaceType it;
            if (!(itfs[i] instanceof Interface) || !(it = (InterfaceType)(itf = (Interface)itfs[i]).getFcItfType()).isFcClientItf()) continue;
            if (bc == null) {
                try {
                    bc = (BindingController)comp.getFcInterface("binding-controller");
                }
                catch (NoSuchInterfaceException nsie) {
                    throw new RuntimeException("No binding controller for " + comp);
                }
            }
            Object bound = null;
            try {
                bound = bc.lookupFc(itf.getFcItfName());
            }
            catch (NoSuchInterfaceException nsie) {
                throw new RuntimeException();
            }
            if (bound == null) continue;
            result.add(bound);
        }
        return result;
    }

    public static Set getFcClientItfsBoundTo(Component comp) {
        HashSet result = new HashSet();
        Object[] itfs = comp.getFcInterfaces();
        for (int i = 0; i < itfs.length; ++i) {
            Interface itf;
            InterfaceType it;
            if (!(itfs[i] instanceof Interface) || (it = (InterfaceType)(itf = (Interface)itfs[i]).getFcItfType()).isFcClientItf()) continue;
            Set cltItfs = BindingControllerHelper.getFcClientItfsBoundTo(itf);
            result.addAll(cltItfs);
        }
        return result;
    }

    public static Set getFcClientItfsBoundTo(Interface serverItf) {
        HashSet result = new HashSet();
        Object[] comps = BindingControllerHelper.getFcPotentialClientsOf(serverItf).toArray();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = (Component)comps[i];
            List clientItfs = BindingControllerHelper.getFcClientItfsBoundTo(comp, serverItf);
            for (int j = 0; j < clientItfs.size(); ++j) {
                result.add(clientItfs.get(j));
            }
        }
        return result;
    }

    public static Set getFcPotentialClientsOf(Interface serverItf) {
        HashSet<Component> compSet = new HashSet<Component>();
        Component serverComp = serverItf.getFcItfOwner();
        if (serverItf.isFcInternalItf()) {
            ContentController cc;
            try {
                cc = (ContentController)serverComp.getFcInterface("content-controller");
            }
            catch (NoSuchInterfaceException e) {
                throw new RuntimeException("Cannot create shortcuts");
            }
            Component[] comps = cc.getFcSubComponents();
            for (int i = 0; i < comps.length; ++i) {
                compSet.add(comps[i]);
            }
            compSet.add(serverComp);
        } else {
            SuperController sc;
            try {
                sc = (SuperController)serverComp.getFcInterface("super-controller");
            }
            catch (NoSuchInterfaceException e) {
                throw new RuntimeException("Cannot create shortcuts");
            }
            Component[] superComps = sc.getFcSuperComponents();
            for (int i = 0; i < superComps.length; ++i) {
                ContentController cc;
                compSet.add(superComps[i]);
                try {
                    cc = (ContentController)superComps[i].getFcInterface("content-controller");
                }
                catch (NoSuchInterfaceException e) {
                    throw new RuntimeException("Cannot create shortcuts");
                }
                Component[] subComps = cc.getFcSubComponents();
                for (int j = 0; j < subComps.length; ++j) {
                    compSet.add(subComps[j]);
                }
            }
        }
        return compSet;
    }

    public static List getFcClientItfsBoundTo(Component component, Interface serverItf) {
        ContentController cc;
        BindingController bc;
        ArrayList<Interface> itfList = new ArrayList<Interface>();
        try {
            bc = (BindingController)component.getFcInterface("binding-controller");
        }
        catch (NoSuchInterfaceException e) {
            return itfList;
        }
        Object[] itfs = component.getFcInterfaces();
        for (int i = 0; i < itfs.length; ++i) {
            Object sItf;
            Interface itf = (Interface)itfs[i];
            InterfaceType itfType = (InterfaceType)itf.getFcItfType();
            if (!itfType.isFcClientItf()) continue;
            try {
                sItf = bc.lookupFc(itf.getFcItfName());
            }
            catch (NoSuchInterfaceException e) {
                continue;
            }
            if (!serverItf.equals(sItf)) continue;
            itfList.add(itf);
        }
        try {
            cc = (ContentController)component.getFcInterface("content-controller");
        }
        catch (NoSuchInterfaceException e) {
            return itfList;
        }
        itfs = cc.getFcInternalInterfaces();
        for (int i = 0; i < itfs.length; ++i) {
            Object sItf;
            Interface itf = (Interface)itfs[i];
            InterfaceType itfType = (InterfaceType)itf.getFcItfType();
            if (!itfType.isFcClientItf()) continue;
            try {
                sItf = bc.lookupFc(itf.getFcItfName());
            }
            catch (NoSuchInterfaceException e) {
                continue;
            }
            if (!serverItf.equals(sItf)) continue;
            itfList.add(itf);
        }
        return itfList;
    }
}

