/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.virtualizing.core;

import java.util.Arrays;

public class VMGuestStatus {
    private final String[] ipAddresses;
    private final String[] macAddresses;
    private final HeartBeat heartBeat;

    public VMGuestStatus(String[] ipAddresses, String[] macAddresses, HeartBeat heartBeat) {
        this.ipAddresses = ipAddresses;
        this.macAddresses = macAddresses;
        this.heartBeat = heartBeat;
    }

    public String[] getIPAddresses() {
        return this.ipAddresses;
    }

    public String[] getMacAddresses() {
        return this.macAddresses;
    }

    public HeartBeat getHeartBeat() {
        return this.heartBeat;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VM Guest heart beat: ");
        sb.append((Object)this.heartBeat);
        sb.append(" - MAC Address(es): ");
        for (String mac : this.macAddresses) {
            sb.append(mac);
            sb.append(" ");
        }
        sb.append(" - IP Address(es): ");
        for (String ip : this.ipAddresses) {
            sb.append(ip);
            sb.append(" ");
        }
        return sb.toString();
    }

    public boolean equals(Object dest) {
        if (dest instanceof VMGuestStatus) {
            VMGuestStatus toTest = (VMGuestStatus)dest;
            boolean result = true;
            if (this.heartBeat != null) {
                boolean bl = result = result && this.heartBeat.equals((Object)toTest.getHeartBeat());
            }
            if (this.ipAddresses != null && toTest.getIPAddresses() != null) {
                boolean bl = result = result && Arrays.equals(this.ipAddresses, toTest.getIPAddresses());
            }
            if (this.macAddresses != null && toTest.getMacAddresses() != null) {
                result = result && Arrays.equals(this.macAddresses, toTest.getMacAddresses());
            }
            return result;
        }
        return false;
    }

    public int hashCode() {
        return 29 * (this.heartBeat == null ? 0 : this.heartBeat.hashCode()) + 27 * (this.ipAddresses == null ? 0 : Arrays.hashCode(this.ipAddresses)) + 17 * (this.macAddresses == null ? 0 : Arrays.hashCode(this.macAddresses));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HeartBeat {
        OK,
        INTERMITTENT,
        UNKNOWN;

    }
}

