/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode
implements Node,
Externalizable {
    private final String type;
    private String source;
    private Map<String, Object> decorations;
    protected static final byte NEW_DECO = 32;
    protected static final byte END_OF_DECO = 34;

    protected AbstractNode(String type) {
        this.type = type;
    }

    private Map<String, Object> decorations() {
        if (this.decorations == null) {
            this.decorations = new HashMap<String, Object>();
        }
        return this.decorations;
    }

    @Override
    public String astGetType() {
        return this.type;
    }

    @Override
    public String astGetSource() {
        return this.source;
    }

    @Override
    public void astSetSource(String source) {
        this.source = source;
    }

    @Override
    public Object astGetDecoration(String name) {
        if (this.decorations == null) {
            return null;
        }
        return this.decorations().get(name);
    }

    @Override
    public Map<String, Object> astGetDecorations() {
        if (this.decorations == null) {
            return new HashMap<String, Object>();
        }
        return new HashMap<String, Object>(this.decorations());
    }

    @Override
    public void astSetDecoration(String name, Object decoration) {
        this.decorations().put(name, decoration);
    }

    @Override
    public void astSetDecorations(Map<String, Object> decorations) {
        if (decorations.size() > 0) {
            this.decorations().putAll(decorations);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte decoState;
        Object value;
        String name;
        this.astSetSource((String)in.readObject());
        int nbAttributes = in.readInt();
        HashMap<String, String> attributes = new HashMap<String, String>(nbAttributes);
        for (int i = 0; i < nbAttributes; ++i) {
            name = in.readUTF();
            value = (String)in.readObject();
            attributes.put(name, (String)value);
        }
        this.astSetAttributes(attributes);
        while ((decoState = in.readByte()) != 34) {
            name = in.readUTF();
            if (decoState != 32) {
                throw new IOException("Stream Error");
            }
            value = in.readObject();
            this.astSetDecoration(name, value);
        }
        int nbSubNodes = in.readInt();
        for (int i = 0; i < nbSubNodes; ++i) {
            this.astAddNode((Node)in.readObject());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Node[] subNodes;
        out.writeObject(this.astGetSource());
        Map<String, String> attributes = this.astGetAttributes();
        out.writeInt(attributes.size());
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            out.writeUTF(attribute.getKey());
            out.writeObject(attribute.getValue());
        }
        for (Map.Entry<String, Object> decoration : this.astGetDecorations().entrySet()) {
            Object deco = decoration.getValue();
            if (deco != null && !(deco instanceof Serializable)) continue;
            out.writeByte(32);
            out.writeUTF(decoration.getKey());
            out.writeObject(deco);
        }
        out.writeByte(34);
        int nbSubNode = 0;
        for (String nodeType : this.astGetNodeTypes()) {
            subNodes = this.astGetNodes(nodeType);
            if (subNodes == null) continue;
            for (Node subNode : subNodes) {
                if (subNode == null) continue;
                ++nbSubNode;
            }
        }
        out.writeInt(nbSubNode);
        for (String nodeType : this.astGetNodeTypes()) {
            subNodes = this.astGetNodes(nodeType);
            if (subNodes == null) continue;
            for (Node subNode : subNodes) {
                if (subNode == null) continue;
                out.writeObject(subNode);
            }
        }
    }

    public String toString() {
        Map<String, String> attributes = this.astGetAttributes();
        String name = attributes.get("name");
        if (name != null) {
            return this.type + '<' + name + '>';
        }
        if (attributes.size() == 1) {
            Map.Entry<String, String> attr = attributes.entrySet().iterator().next();
            return this.type + '<' + attr.getKey() + '=' + attr.getValue() + '>';
        }
        return this.type + '@' + System.identityHashCode(this);
    }
}

