/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.fractal.adl.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeClassId {
    private final String[] itfs;
    private final String type;
    private final Class<? extends Node> baseClass;
    private final int hashcode;
    private Set<String> itfSet = null;

    public NodeClassId(String type, Class<? extends Node> baseClass, String[] itfs) {
        this.itfs = itfs;
        this.type = type;
        this.baseClass = baseClass;
        this.hashcode = (Arrays.deepHashCode(itfs) * 13 + baseClass.hashCode()) * 13 + type.hashCode();
    }

    public String[] getItfs() {
        return this.itfs;
    }

    public String getType() {
        return this.type;
    }

    public Class<? extends Node> getBaseClass() {
        return this.baseClass;
    }

    private void initSet() {
        this.itfSet = new HashSet<String>();
        for (String itf : this.itfs) {
            this.itfSet.add(itf);
        }
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeClassId)) {
            return false;
        }
        NodeClassId id = (NodeClassId)obj;
        if (!id.type.equals(this.type)) {
            return false;
        }
        if (!id.baseClass.equals(this.baseClass)) {
            return false;
        }
        if (this.itfSet != null) {
            if (id.itfSet != null) {
                return ((Object)this.itfSet).equals(id.itfSet);
            }
            if (this.itfSet.size() != id.itfs.length) {
                return false;
            }
            for (String itf : id.itfs) {
                if (this.itfSet.contains(itf)) continue;
                return false;
            }
            return true;
        }
        if (id.itfSet == null) {
            id.initSet();
        }
        if (id.itfSet.size() != this.itfs.length) {
            return false;
        }
        for (String itf : this.itfs) {
            if (id.itfSet.contains(itf)) continue;
            return false;
        }
        return true;
    }
}

