/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.fractal.adl.AbstractNode;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.NodeClassId;
import org.objectweb.fractal.adl.NodeClassLoader;
import org.objectweb.fractal.adl.NodeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFactoryImpl
implements NodeFactory {
    protected ClassLoader classLoader = this.getClass().getClassLoader();
    SimpleNodeClassLoader nodeClassLoader;

    @Override
    public Node newNode(String nodeType, String ... interfaces) throws ClassNotFoundException {
        return this.newNode(nodeType, AbstractNode.class, interfaces);
    }

    @Override
    public Node newNode(String nodeType, Class<? extends Node> baseNodeClass, String ... interfaces) throws ClassNotFoundException {
        if (this.nodeClassLoader == null) {
            this.nodeClassLoader = new SimpleNodeClassLoader(this.classLoader);
        }
        Class<? extends Node> c = this.nodeClassLoader.getNodeClass(nodeType, baseNodeClass, interfaces);
        try {
            return c.newInstance();
        }
        catch (Exception e) {
            throw new Error("An error occurs while instantiating Node", e);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        if (loader != this.classLoader) {
            this.classLoader = loader;
            this.nodeClassLoader = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleNodeClassLoader
    extends NodeClassLoader {
        final Map<NodeClassId, Class<? extends Node>> classes = new HashMap<NodeClassId, Class<? extends Node>>();

        SimpleNodeClassLoader(ClassLoader parent) {
            super(parent);
        }

        Class<? extends Node> getNodeClass(String nodeType, Class<? extends Node> baseClass, String ... itfs) throws ClassNotFoundException {
            NodeClassId key = new NodeClassId(nodeType, baseClass, itfs);
            Class<? extends Node> c = this.classes.get(key);
            if (c == null) {
                String name = "org.objectweb.fractal.adl.Node" + this.classes.size();
                String[] itfNames = new String[itfs.length];
                for (int i = 0; i < itfs.length; ++i) {
                    itfNames[i] = itfs[i].replace('.', '/');
                }
                ClassWriter cw = this.generateClass(name, nodeType, Type.getInternalName(baseClass), itfNames);
                c = this.defineClass(name, cw.toByteArray()).asSubclass(Node.class);
                this.classes.put(key, c);
            }
            return c;
        }
    }
}

