/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.comments;

import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.comments.CommentDecoration;

public final class CommentDecorationHelper {
    public static final String COMMENT_DECORATION_NAME = "comment";

    private CommentDecorationHelper() {
    }

    public static void setComment(Node node, String comment) {
        Object o = node.astGetDecoration(COMMENT_DECORATION_NAME);
        if (o != null) {
            throw new IllegalArgumentException("Given node already contains a \"comment\" decoration.");
        }
        node.astSetDecoration(COMMENT_DECORATION_NAME, new CommentDecoration(comment, node));
    }

    public static String getComment(Node node) {
        Object deco = node.astGetDecoration(COMMENT_DECORATION_NAME);
        if (deco == null) {
            return null;
        }
        if (!(deco instanceof CommentDecoration)) {
            throw new IllegalArgumentException("Given node contains a \"comment\" decoration that is not a CommentDecoration.");
        }
        return ((CommentDecoration)deco).getComment();
    }

    public static CommentDecoration getCommentDecoration(Node node) {
        Object deco = node.astGetDecoration(COMMENT_DECORATION_NAME);
        if (deco == null) {
            return null;
        }
        if (!(deco instanceof CommentDecoration)) {
            throw new IllegalArgumentException("Given node contains a \"comment\" decoration that is not a CommentDecoration.");
        }
        return (CommentDecoration)deco;
    }
}

