/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.NodeClassId;
import org.objectweb.fractal.adl.NodeClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInputStream
extends ObjectInputStream {
    final List<NamedNodeClassLoader> nodeClassLoaders = new ArrayList<NamedNodeClassLoader>();
    final ClassLoader parentLoader;

    public NodeInputStream(InputStream in) throws IOException {
        this(in, null);
    }

    public NodeInputStream(InputStream in, ClassLoader parentLoader) throws IOException {
        super(in);
        this.parentLoader = parentLoader == null ? this.getClass().getClassLoader() : parentLoader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        boolean isNode = this.readBoolean();
        if (isNode) {
            String className = this.readUTF();
            String superClassName = this.readUTF();
            Class<Node> superClass = Class.forName(superClassName).asSubclass(Node.class);
            String type = this.readUTF();
            int length = this.readByte();
            String[] nodeInterfaces = new String[length];
            for (int i = 0; i < length; ++i) {
                nodeInterfaces[i] = this.readUTF();
            }
            return this.findClass(className, type, superClass, nodeInterfaces);
        }
        return super.resolveClass(desc);
    }

    protected Class<? extends Node> findClass(String className, String nodeType, Class<? extends Node> baseClass, String ... itfs) throws ClassNotFoundException {
        NodeClassId id = new NodeClassId(nodeType, baseClass, itfs);
        for (NamedNodeClassLoader cl : this.nodeClassLoaders) {
            NodeClassId clId = cl.classeIds.get(className);
            if (clId == null) {
                return cl.newNodeClass(className, id);
            }
            if (!clId.equals(id)) continue;
            return cl.classes.get(className);
        }
        NamedNodeClassLoader cl = new NamedNodeClassLoader(this.parentLoader);
        this.nodeClassLoaders.add(cl);
        return cl.newNodeClass(className, id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NamedNodeClassLoader
    extends NodeClassLoader {
        final Map<String, NodeClassId> classeIds = new HashMap<String, NodeClassId>();
        final Map<String, Class<? extends Node>> classes = new HashMap<String, Class<? extends Node>>();

        NamedNodeClassLoader(ClassLoader parent) {
            super(parent);
        }

        Class<? extends Node> newNodeClass(String className, NodeClassId id) throws ClassNotFoundException {
            String[] itfNames = new String[id.getItfs().length];
            for (int i = 0; i < itfNames.length; ++i) {
                itfNames[i] = id.getItfs()[i].replace('.', '/');
            }
            ClassWriter cw = this.generateClass(className, id.getType(), Type.getInternalName(id.getBaseClass()), itfNames);
            Class<Node> c = this.defineClass(className, cw.toByteArray()).asSubclass(Node.class);
            this.classeIds.put(className, id);
            this.classes.put(className, c);
            return c;
        }
    }
}

