/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.xml;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDParser;
import com.wutka.dtd.DTDProcessingInstruction;
import com.wutka.dtd.DTDSequence;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.objectweb.asm.Type;
import org.objectweb.fractal.adl.xml.XMLNodeClassLoader;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DTDHandler {
    DTDHandler() {
    }

    void checkDTD(InputStream is, XMLNodeClassLoader loader) throws IOException, ClassNotFoundException, SAXException {
        HashMap<String, DTDElement> astElements = new HashMap<String, DTDElement>();
        DTD dtd = new DTDParser((Reader)new InputStreamReader(is)).parse();
        for (Object item : dtd.items) {
            if (item instanceof DTDProcessingInstruction) {
                String ast;
                Map<String, String> args;
                String pi = ((DTDProcessingInstruction)item).getText();
                if (pi.startsWith("add")) {
                    args = this.checkProcessingInstruction(pi);
                    ast = args.get("ast");
                    String itf = args.get("itf");
                    if (ast == null || itf == null) {
                        throw new SAXException("Invalid processing instruction ('ast' and/or 'itf' argument missing): " + pi);
                    }
                    DTDElement astElement = (DTDElement)astElements.get(ast);
                    if (astElement == null) {
                        astElement = new DTDElement(ast);
                        astElement.setContent((DTDItem)new DTDSequence());
                        astElements.put(ast, astElement);
                    }
                    this.checkASTClass(loader.loadClass(itf), astElement);
                    loader.addASTNodeInterface(ast, itf);
                    continue;
                }
                if (!pi.startsWith("map")) continue;
                args = this.checkProcessingInstruction(pi);
                ast = args.get("ast");
                String xml = args.get("xml");
                String type = args.get("type");
                if (ast == null || xml == null && type == null) {
                    throw new SAXException("Invalid processing instruction ('ast', 'xml' and/or 'type' argument missing): " + pi);
                }
                if (xml != null) {
                    if (xml.indexOf(46) == -1) {
                        loader.addASTNodeMapping(ast, xml);
                    } else {
                        if (ast.indexOf(46) == -1) {
                            throw new SAXException("Invalid processing instruction (incompatible 'xml' and 'ast' arguments)" + pi);
                        }
                        loader.addASTAttributeMapping(ast, xml);
                    }
                }
                if (type == null) continue;
                if (ast.indexOf(46) != -1) {
                    throw new SAXException("Invalid processing instruction (incompatible 'type' and 'ast' arguments)" + pi);
                }
                loader.addASTTypeMapping(ast, type);
                continue;
            }
            if (!(item instanceof DTDElement)) continue;
            DTDElement xmlElem = (DTDElement)item;
            String xmlName = xmlElem.getName();
            String astName = loader.getASTName(xmlName);
            DTDElement astElem = (DTDElement)astElements.get(astName);
            if (astElem == null) {
                throw new SAXException("Invalid DTD : no AST node defined for element '" + xmlName + "'");
            }
            this.checkDTDItem(xmlElem.getContent(), new HashSet<String>());
            this.checkDTDItem(astElem.getContent(), new HashSet<String>());
            Arities xmlArities = this.getArities(xmlElem.getContent(), null);
            Arities astArities = this.getArities(astElem.getContent(), null);
            for (String xmlSubNode : xmlArities.keySet()) {
                String astSubNode = loader.getASTType(loader.getASTName(xmlSubNode));
                Arity xmlSubNodeArity = (Arity)xmlArities.get(xmlSubNode);
                Arity astSubNodeArity = (Arity)astArities.get(astSubNode);
                if (astSubNodeArity == null) {
                    throw new SAXException("Invalid DTD : no AST node defined for sub element '" + xmlSubNode + "' of element '" + xmlName + "'");
                }
                if (!(astSubNodeArity.max > 1.0f && xmlSubNodeArity.max <= 1.0f) && (!(astSubNodeArity.max <= 1.0f) || !(xmlSubNodeArity.max > 1.0f))) continue;
                throw new SAXException("Invalid DTD : arity of sub element '" + xmlSubNode + "' of element '" + xmlName + "' incompatible with arity of AST" + " sub node '" + astSubNode + "' of AST node '" + astName + "'");
            }
            for (String astSubNode : astArities.keySet()) {
                Set<String> astSubNodeNames = loader.getASTNames(astSubNode);
                boolean found = false;
                for (String astSubNodeName : astSubNodeNames) {
                    String xmlSubNode = loader.getXMLElement(astSubNodeName);
                    Arity xmlSubNodeArity = (Arity)xmlArities.get(xmlSubNode);
                    if (xmlSubNodeArity == null) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new SAXException("Invalid DTD : no sub element defined in '" + xmlName + "' element for sub node '" + astSubNode + "' of AST node '" + astName + "'");
            }
            for (String xmlAttr : xmlElem.attributes.keySet()) {
                String astAttr = loader.getASTAttribute(xmlName, xmlAttr);
                if (astElem.getAttribute(astAttr) != null) continue;
                throw new SAXException("Invalid DTD : no AST attribute defined for XML attribute '" + xmlAttr + "' of element '" + xmlName + "'");
            }
            for (String astAttr : astElem.attributes.keySet()) {
                String xmlAttr = loader.getXMLAttribute(astName, astAttr);
                if (xmlElem.getAttribute(xmlAttr) != null) continue;
                throw new SAXException("Invalid DTD : no XML attribute defined in element '" + xmlName + "' for attribute '" + astAttr + "' of AST node '" + astName + "'");
            }
        }
    }

    private Map<String, String> checkProcessingInstruction(String pi) throws SAXException {
        HashMap<String, String> m = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(pi);
        if (st.hasMoreTokens()) {
            st.nextToken();
        } else {
            throw new SAXException("Invalid processing instruction: " + pi);
        }
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            int p = t.indexOf("=\"");
            if (p == -1 || !t.endsWith("\"")) {
                throw new SAXException("Invalid processing instruction: " + pi);
            }
            String key = t.substring(0, p);
            String value = t.substring(p + 2, t.length() - 1);
            m.put(key, value);
        }
        return m;
    }

    private void checkASTClass(Class<?> c, DTDElement elt) {
        Method[] methods;
        HashSet<String> meths = new HashSet<String>();
        for (Method method : methods = c.getMethods()) {
            meths.add(method.getName() + Type.getMethodDescriptor((Method)method));
        }
        for (String meth : meths) {
            if (meth.startsWith("get") && meth.endsWith("()Ljava/lang/String;")) {
                String attr = meth.substring(3, meth.indexOf(40));
                if (!meths.contains("set" + attr + "(Ljava/lang/String;)V")) continue;
                attr = Character.toLowerCase(attr.charAt(0)) + attr.substring(1);
                elt.setAttribute(attr, new DTDAttribute(attr));
                continue;
            }
            if (!meth.startsWith("get") || meth.indexOf("()") == -1) continue;
            String subElt = meth.substring(3, meth.indexOf(40));
            String subEltDesc = meth.substring(meth.indexOf(41) + 1);
            DTDName dtdName = null;
            if (subEltDesc.charAt(0) == '[') {
                if (subElt.endsWith("s")) {
                    subElt = subElt.substring(0, subElt.length() - 1);
                    subEltDesc = subEltDesc.substring(1);
                    String addMeth = "add" + subElt + "(" + subEltDesc + ")V";
                    String removeMeth = "remove" + subElt + "(" + subEltDesc + ")V";
                    if (meths.contains(addMeth) && meths.contains(removeMeth)) {
                        subElt = Character.toLowerCase(subElt.charAt(0)) + subElt.substring(1);
                        dtdName = new DTDName(subElt);
                        dtdName.setCardinal(DTDCardinal.ZEROMANY);
                    }
                }
            } else if (meths.contains("set" + subElt + "(" + subEltDesc + ")V")) {
                subElt = Character.toLowerCase(subElt.charAt(0)) + subElt.substring(1);
                dtdName = new DTDName(subElt);
            }
            if (dtdName == null) continue;
            boolean add = true;
            DTDItem[] items = ((DTDSequence)elt.getContent()).getItems();
            for (int j = 0; j < items.length; ++j) {
                if (!((DTDName)items[j]).getValue().equals(dtdName.getValue())) continue;
                add = false;
                break;
            }
            if (!add) continue;
            ((DTDSequence)elt.getContent()).add(dtdName);
        }
    }

    private void checkDTDItem(DTDItem item, Set<String> names) {
        if (item instanceof DTDContainer) {
            DTDItem[] items;
            for (DTDItem element : items = ((DTDContainer)item).getItems()) {
                this.checkDTDItem(element, names);
            }
        } else if (item instanceof DTDName) {
            String name = ((DTDName)item).getValue();
            if (names.contains(name)) {
                throw new RuntimeException("Regular expressions with several occurences of the same sub element name are not supported");
            }
            names.add(name);
        }
    }

    private Arities getArities(DTDItem item, Arity arity) {
        Arity a;
        Arities result = new Arities();
        Arity arity2 = a = arity == null ? new Arity(item) : arity.mult(new Arity(item));
        if (item instanceof DTDChoice) {
            for (DTDItem subItem : ((DTDChoice)item).getItems()) {
                result.union(this.getArities(subItem, a));
            }
        } else if (item instanceof DTDSequence) {
            for (DTDItem subItem : ((DTDSequence)item).getItems()) {
                result.add(this.getArities(subItem, a));
            }
        } else if (item instanceof DTDMixed) {
            for (DTDItem subItem : ((DTDMixed)item).getItems()) {
                result.union(this.getArities(subItem, a));
            }
        } else if (item instanceof DTDName) {
            result.put(((DTDName)item).getValue(), a);
        }
        return result;
    }

    static class Arity {
        final float min;
        final float max;

        Arity(float min, float max) {
            this.min = min;
            this.max = max;
        }

        Arity(DTDItem i) {
            DTDCardinal c = i.getCardinal();
            if (c == DTDCardinal.NONE) {
                this.min = 1.0f;
                this.max = 1.0f;
            } else if (c == DTDCardinal.OPTIONAL) {
                this.min = 0.0f;
                this.max = 1.0f;
            } else if (c == DTDCardinal.ZEROMANY) {
                this.min = 0.0f;
                this.max = Float.POSITIVE_INFINITY;
            } else {
                this.min = 0.0f;
                this.max = Float.POSITIVE_INFINITY;
            }
        }

        Arity add(Arity a) {
            return new Arity(this.min + a.min, this.max + a.max);
        }

        Arity mult(Arity a) {
            return new Arity(this.min * a.min, this.max * a.max);
        }

        Arity union(Arity a) {
            return new Arity(Math.min(this.min, a.min), Math.max(this.max, a.max));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Arities
    extends HashMap<String, Arity> {
        Arities() {
        }

        void add(Arities arities) {
            for (String item : arities.keySet()) {
                Arity a = this.getArity(item);
                Arity b = arities.getArity(item);
                this.put(item, a.add(b));
            }
        }

        void mult(Arities arities) {
            for (String item : arities.keySet()) {
                Arity a = this.getArity(item);
                Arity b = arities.getArity(item);
                this.put(item, a.mult(b));
            }
        }

        void union(Arities arities) {
            for (String item : arities.keySet()) {
                Arity a = this.getArity(item);
                Arity b = arities.getArity(item);
                this.put(item, a.union(b));
            }
        }

        private Arity getArity(String item) {
            Arity a = (Arity)this.get(item);
            return a == null ? new Arity(0.0f, 0.0f) : a;
        }
    }
}

