/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.xml.DTDHandler;
import org.objectweb.fractal.adl.xml.XMLNode;
import org.objectweb.fractal.adl.xml.XMLNodeClassLoader;
import org.objectweb.fractal.adl.xml.XMLNodeFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLNodeFactoryImpl
implements XMLNodeFactory {
    protected Map<Class<? extends XMLNode>, Map<String, XMLNodeClassLoader>> loaders = new HashMap<Class<? extends XMLNode>, Map<String, XMLNodeClassLoader>>();
    public ClassLoader classLoader = this.getClass().getClassLoader();

    @Override
    public void checkDTD(String systemId) throws SAXException {
        XMLNodeClassLoader loader = this.getLoader(systemId, XMLNode.class);
        if (loader == null) {
            loader = this.newLoader(systemId, XMLNode.class);
            this.setLoader(systemId, XMLNode.class, loader);
        }
    }

    @Override
    public XMLNode newXMLNode(String systemId, String qualifiedName) throws SAXException {
        return this.newXMLNode(systemId, qualifiedName, XMLNode.class);
    }

    @Override
    public XMLNode newXMLNode(String systemId, String qualifiedName, Class<? extends XMLNode> baseNodeClass) throws SAXException {
        XMLNodeClassLoader loader = this.getLoader(systemId, baseNodeClass);
        if (loader == null) {
            loader = this.newLoader(systemId, baseNodeClass);
            this.setLoader(systemId, baseNodeClass, loader);
        }
        String xmlNodeClassName = loader.getASTClassName(qualifiedName);
        try {
            Class<XMLNode> loadClass = loader.loadClass(xmlNodeClassName).asSubclass(XMLNode.class);
            return loadClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new SAXException("The element <" + qualifiedName + "> can't be mapped to any AST node type. Check that you spell it correctly, or that the '" + xmlNodeClassName + "' exists, or that your DTD configuration [" + systemId + "] is correct", cnfe);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SAXException("Internal error", e);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    private XMLNodeClassLoader newLoader(String systemId, Class<? extends XMLNode> baseNodeClass) throws SAXException {
        XMLNodeClassLoader loader;
        try {
            InputStream is;
            loader = new XMLNodeClassLoader(this.classLoader, baseNodeClass);
            if (systemId.startsWith("classpath://")) {
                is = this.classLoader.getResourceAsStream(systemId.substring("classpath://".length()));
                if (is == null) {
                    throw new SAXException("Unable to find DTD '" + systemId + "'");
                }
            } else if (systemId.startsWith("file:")) {
                is = new URL(systemId).openStream();
            } else {
                throw new MalformedURLException("Unrecognized system identifier: " + systemId);
            }
            new DTDHandler().checkDTD(is, loader);
        }
        catch (MalformedURLException e) {
            throw new SAXException("Cannot find the DTD", e);
        }
        catch (IOException e) {
            throw new SAXException("Cannot read the DTD", e);
        }
        catch (ClassNotFoundException e) {
            throw new SAXException("Cannot check the DTD", e);
        }
        return loader;
    }

    protected XMLNodeClassLoader getLoader(String systemId, Class<? extends XMLNode> baseNodeClass) {
        Map<String, XMLNodeClassLoader> map = this.loaders.get(baseNodeClass);
        if (map == null) {
            return null;
        }
        return map.get(systemId);
    }

    protected void setLoader(String systemId, Class<? extends XMLNode> baseNodeClass, XMLNodeClassLoader loader) {
        Map<String, XMLNodeClassLoader> map = this.loaders.get(baseNodeClass);
        if (map == null) {
            map = new HashMap<String, XMLNodeClassLoader>();
            this.loaders.put(baseNodeClass, map);
        }
        map.put(systemId, loader);
    }
}

