/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.Parser;
import org.objectweb.fractal.adl.ParserException;
import org.objectweb.fractal.adl.comments.CommentDecorationHelper;
import org.objectweb.fractal.adl.xml.XMLNode;
import org.objectweb.fractal.adl.xml.XMLNodeFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler
implements Parser,
LexicalHandler {
    SAXParserFactory spf = SAXParserFactory.newInstance();
    String file;
    String systemId;
    List<XMLNode> stack;
    XMLNode result;
    XMLNode current;
    StringBuilder characters;
    String comment;
    Locator locator;
    int line;
    XMLNodeFactory nodeFactory;

    public XMLParser(XMLNodeFactory nodeFactory) {
        this(true, nodeFactory);
    }

    public XMLParser(boolean validate, XMLNodeFactory nodeFactory) {
        this.spf.setValidating(validate);
        this.nodeFactory = nodeFactory;
    }

    public Node parse(InputStream is, String name) throws ParserException {
        this.file = name;
        try {
            this.stack = new ArrayList<XMLNode>();
            SAXParser sp = this.spf.newSAXParser();
            sp.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            sp.parse(new InputSource(is), (DefaultHandler)this);
            return this.result;
        }
        catch (IOException e) {
            throw new ParserException("Parser error (" + this.file + ":" + this.line + ")", e);
        }
        catch (ParserConfigurationException e) {
            throw new ParserException("Parser error (" + this.file + ":" + this.line + ")", e);
        }
        catch (SAXException e) {
            throw new ParserException("Parser error (" + this.file + ":" + this.line + ")", e);
        }
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        this.systemId = systemId;
        this.nodeFactory.checkDTD(systemId);
        if (systemId.startsWith("classpath://")) {
            return new InputSource(this.nodeFactory.getClassLoader().getResourceAsStream(systemId.substring("classpath://".length())));
        }
        return null;
    }

    public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.current != null && this.characters != null) {
            this.current.xmlSetContent(this.characters.toString());
            this.characters = null;
        }
        XMLNode o = this.nodeFactory.newXMLNode(this.systemId, qualifiedName);
        o.astSetSource(this.file + ":" + this.locator.getLineNumber());
        o.xmlSetAttributes(attributes);
        if (this.comment != null) {
            CommentDecorationHelper.setComment(o, this.comment);
            this.comment = null;
        }
        if (this.stack.size() == 0) {
            this.result = o;
        } else {
            this.stack.get(this.stack.size() - 1).xmlAddNode(qualifiedName, o);
        }
        this.stack.add(o);
        this.current = o;
    }

    public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
        if (this.characters != null) {
            this.current.xmlSetContent(this.characters.toString());
            this.characters = null;
        }
        this.stack.remove(this.stack.size() - 1);
        this.current = this.stack.size() == 0 ? null : this.stack.get(this.stack.size() - 1);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.characters == null) {
            String previousContent = this.current.xmlGetContent();
            this.characters = previousContent == null ? new StringBuilder() : new StringBuilder(previousContent);
        }
        this.characters.append(ch, start, length);
    }

    public void error(SAXParseException e) throws SAXException {
        this.line = this.locator.getLineNumber();
        throw e;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.line = this.locator.getLineNumber();
        throw e;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        int i;
        int end = start + length;
        for (i = start; i < end && Character.isWhitespace(ch[i]); ++i) {
        }
        if (i == end) {
            return;
        }
        if (ch[i] != '-') {
            return;
        }
        String s = new String(ch, ++i, end - i).trim();
        s = s.replaceAll("\\n(\\s)*(-)*(\\s)+", " ");
        this.comment = this.comment == null ? s : this.comment + " " + s;
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }
}

