/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import org.objectweb.fractal.adl.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLWriter {
    private Writer w;

    public XMLWriter(Writer writer) {
        this.w = writer;
    }

    public void write(Node node) throws IOException {
        this.write("", node, new Stack<Node>());
    }

    private void write(String indent, Node node, Stack<Node> writtenNodes) throws IOException {
        this.w.write(indent);
        this.w.write(60);
        this.w.write(node.astGetType());
        Map<String, String> attrs = node.astGetAttributes();
        for (String attr : attrs.keySet()) {
            String value = attrs.get(attr);
            if (value == null) continue;
            this.w.write(32);
            this.w.write(attr);
            this.w.write("=\"");
            this.w.write(value);
            this.w.write("\"");
        }
        if (writtenNodes.contains(node)) {
            this.w.write(" (...) />\n");
        } else {
            String[] subNodeTypes;
            ArrayList<Node> subNodes = new ArrayList<Node>();
            for (String subNode : subNodeTypes = node.astGetNodeTypes()) {
                Node[] nodes;
                for (Node n : nodes = node.astGetNodes(subNode)) {
                    if (n == null) continue;
                    subNodes.add(n);
                }
            }
            if (subNodes.size() > 0) {
                this.w.write(">\n");
                String subIndent = indent + "  ";
                writtenNodes.push(node);
                for (Node subNode : subNodes) {
                    this.write(subIndent, subNode, writtenNodes);
                }
                writtenNodes.pop();
                this.w.write(indent);
                this.w.write("</");
                this.w.write(node.astGetType());
                this.w.write(">\n");
            } else {
                this.w.write("/>\n");
            }
        }
    }
}

