/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.task.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.objectweb.fractal.task.core.EmptyTaskHoleException;
import org.objectweb.fractal.task.core.Task;
import org.objectweb.fractal.task.core.TaskMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTaskMap
extends LinkedHashMap<Key, TaskMap.TaskHole>
implements TaskMap {
    @Override
    public Task[] getTasks() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskMap.TaskHole taskHole : this.values()) {
            if (taskHole.isOptional()) continue;
            tasks.add(taskHole.getTask());
        }
        return tasks.toArray(new Task[0]);
    }

    @Override
    public Task getTask(String type, Object id) {
        TaskMap.TaskHole taskHole = (TaskMap.TaskHole)this.get(this.createTaskKey(type, id));
        if (taskHole == null || !taskHole.isFilled()) {
            throw new NoSuchElementException();
        }
        return taskHole.getTask();
    }

    @Override
    public TaskMap.TaskHole getTaskHole(String type, Object id) {
        Key key = this.createTaskKey(type, id);
        TaskHoleImpl taskHole = (TaskHoleImpl)this.get(key);
        if (taskHole == null) {
            taskHole = new TaskHoleImpl();
            this.put(key, taskHole);
        } else {
            taskHole.setMandatory();
        }
        return taskHole;
    }

    @Override
    public TaskMap.TaskHole getOptionalTaskHole(String type, Object id) {
        Key key = this.createTaskKey(type, id);
        TaskHoleImpl taskHole = (TaskHoleImpl)this.get(key);
        if (taskHole == null) {
            taskHole = new TaskHoleImpl(true);
            this.put(key, taskHole);
        }
        return taskHole;
    }

    @Override
    public TaskMap.TaskHole addTask(String type, Object id, Task task) {
        TaskHoleImpl taskHole = (TaskHoleImpl)this.getTaskHole(type, id);
        if (taskHole.task == null) {
            taskHole.fill(task);
        }
        return taskHole;
    }

    protected Key createTaskKey(String type, Object id) {
        return new Key(type, id);
    }

    public static class Key {
        protected final String type;
        protected final Object id;
        private final int hashcode;

        protected Key(String type, Object id) {
            this.type = type;
            this.id = id;
            this.hashcode = this.computeHashCode();
        }

        public Object getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                return (k.type == null ? this.type == null : k.type.equals(this.type)) && k.id.equals(this.id);
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }

        protected int computeHashCode() {
            return (this.type == null ? 1 : this.type.hashCode()) * this.id.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskHoleImpl
    implements TaskMap.TaskHole {
        private Task task;
        private boolean optional;
        private final List<Dependency> dependancies = new ArrayList<Dependency>();
        private final StackTraceElement[] holeCreation = new Throwable().getStackTrace();

        TaskHoleImpl() {
            this(false);
        }

        TaskHoleImpl(boolean optional) {
            this.optional = optional;
        }

        @Override
        public void addDependency(TaskMap.TaskHole task, Class<?> role, Object context) {
            if (this.isFilled()) {
                this.task.addDependency(task, role, context);
            } else {
                this.dependancies.add(new Dependency(task, role, context));
            }
        }

        @Override
        public void removeDependency(TaskMap.TaskHole task, Class<?> role) {
            if (this.isFilled()) {
                this.task.removeDependency(task, role);
            } else {
                Iterator<Dependency> iter = this.dependancies.iterator();
                while (iter.hasNext()) {
                    Dependency dep = iter.next();
                    if (!dep.task.equals(task) || !dep.role.equals(role)) continue;
                    iter.remove();
                }
            }
        }

        @Override
        public Task getTask() {
            if (this.task == null) {
                throw new EmptyTaskHoleException(this.holeCreation);
            }
            return this.task;
        }

        @Override
        public boolean isFilled() {
            return this.task != null;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }

        private void setMandatory() {
            this.optional = false;
        }

        private void fill(Task task) {
            this.task = task;
            for (Dependency dep : this.dependancies) {
                task.addDependency(dep.task, dep.role, dep.context);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class Dependency {
            private final TaskMap.TaskHole task;
            private final Class<?> role;
            private final Object context;

            private Dependency(TaskMap.TaskHole task, Class<?> role, Object context) {
                this.task = task;
                this.role = role;
                this.context = context;
            }
        }
    }
}

