/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.synchro;

import java.util.Map;
import org.ow2.clif.deploy.ClifRegistry;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;
import org.ow2.clif.server.api.Synchronizer;
import org.ow2.clif.server.lib.SynchronizerImpl;

public class SessionObject
implements SessionObjectAction,
ControlAction,
TestAction,
DataProvider {
    static final String CONTROL_SETRENDEZVOUS_TIMES = "times";
    static final String CONTROL_RENDEZVOUS_TIMEOUT = "timeout";
    static final String CONTROL_RENDEZVOUS_LOCK = "lock";
    static final String CONTROL_SETRENDEZVOUS_LOCK = "lock";
    static final String PLUGIN_DOMAIN = "domain";
    static final String PLUGIN_DISTRIBUTED = "distributed";
    static final int TEST_WASNOTIFIED = 2;
    static final String TEST_WASNOTIFIED_LOCK = "lock";
    static final String TEST_WASNOTIFIED_OPTIONS = "options";
    static final int TEST_WASNOTIFIEDN = 3;
    static final String TEST_WASNOTIFIEDN_LOCK = "lock";
    static final String TEST_WASNOTIFIEDN_OPTIONS = "options";
    static final String TEST_WASNOTIFIEDN_TIMES = "times";
    static final int CONTROL_NOTIFY = 0;
    static final String CONTROL_NOTIFY_LOCK = "lock";
    static final int CONTROL_WAIT = 1;
    static final String CONTROL_WAIT_TIMEOUT = "timeout";
    static final String CONTROL_WAIT_LOCK = "lock";
    static final int CONTROL_WAITN = 4;
    static final String CONTROL_WAITN_TIMEOUT = "timeout";
    static final String CONTROL_WAITN_LOCK = "lock";
    static final String CONTROL_WAITN_TIMES = "times";
    static final int CONTROL_SETRENDEZVOUS = 5;
    static final int CONTROL_RENDEZVOUS = 6;
    protected volatile Synchronizer locks;

    public SessionObject(Map<String, String> params) {
        if (ParameterParser.getRadioGroup((String)params.get(PLUGIN_DISTRIBUTED)).equals("yes")) {
            String domain = params.get(PLUGIN_DOMAIN);
            try {
                this.locks = (Synchronizer)new ClifRegistry((Object)false).lookup("Synchronizer/" + domain).getFcInterface("Synchronizer");
            }
            catch (Exception e) {
                throw new IsacRuntimeException("Can't connect to Synchronizer for domain " + domain, e);
            }
        } else {
            this.locks = new SynchronizerImpl();
        }
    }

    public Object createNewSessionObject() {
        return this;
    }

    public void close() {
    }

    public void reset() {
    }

    public void doControl(int number, Map<String, String> params) {
        switch (number) {
            case 6: {
                String lockName = params.get("lock");
                try {
                    this.locks.notify(lockName);
                    this.locks.getRendezVous(lockName, Long.parseLong(params.get("timeout")));
                    break;
                }
                catch (InterruptedException ex) {
                    throw new IsacRuntimeException("Interrupted rendez-vous on lock " + lockName);
                }
            }
            case 5: {
                String lockName = params.get("lock");
                this.locks.setRendezVous(lockName, Long.parseLong(params.get("times")));
                break;
            }
            case 4: {
                String lockName = params.get("lock");
                try {
                    this.locks.wait(lockName, Long.parseLong(params.get("timeout")), Long.parseLong(params.get("times")));
                    break;
                }
                catch (InterruptedException ex) {
                    throw new IsacRuntimeException("Interrupted wait on lock " + lockName);
                }
            }
            case 1: {
                String lockName = params.get("lock");
                try {
                    this.locks.wait(lockName, Long.parseLong(params.get("timeout")));
                    break;
                }
                catch (InterruptedException ex) {
                    throw new IsacRuntimeException("Interrupted wait on lock " + lockName);
                }
            }
            case 0: {
                String lockName = params.get("lock");
                this.locks.notify(lockName);
                break;
            }
            default: {
                throw new Error("Unable to find this control in ~Synchro~ ISAC plugin: " + number);
            }
        }
    }

    public boolean doTest(int number, Map<String, String> params) {
        boolean response;
        switch (number) {
            case 3: {
                String lockName = params.get("lock");
                response = this.locks.wasNotified(lockName, Long.parseLong(params.get("times")));
                if (!ParameterParser.getCheckBox((String)params.get("options")).contains("not")) break;
                response = !response;
                break;
            }
            case 2: {
                String lockName = params.get("lock");
                response = this.locks.wasNotified(lockName);
                if (!ParameterParser.getCheckBox((String)params.get("options")).contains("not")) break;
                response = !response;
                break;
            }
            default: {
                throw new Error("Unable to find this test in ~Synchro~ ISAC plugin: " + number);
            }
        }
        return response;
    }

    public synchronized String doGet(String var) {
        if (var.equals("")) {
            return this.locks.toString();
        }
        return String.valueOf(this.locks.getCount(var));
    }
}

