/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.filereader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;
import org.ow2.clif.supervisor.api.ClifException;
import org.ow2.clif.util.ClifClassLoader;

public class SessionObject
implements DataProvider,
SessionObjectAction,
ControlAction,
TestAction {
    static final int TEST_ISSET = 1;
    static final int TEST_ISNOTSET = 2;
    static final int CONTROL_LOAD = 0;
    static final String CONTROL_LOAD_CHARSET = "charset";
    static final String CONTROL_LOAD_FILENAME = "filename";
    static final int CONTROL_CLEAR = 3;
    static final String PLUGIN_CHARSET = "charset";
    static final String PLUGIN_FILENAME = "filename";
    private final String importData;
    private String data = null;

    private static String readData(String filename, String charset) throws IsacRuntimeException {
        String data;
        InputStream in;
        try {
            in = ClifClassLoader.getClassLoader().getResourceAsStream(filename);
        }
        catch (ClifException ex) {
            throw new IsacRuntimeException("Plug-in ~FileReader~ can't access file " + filename, (Exception)((Object)ex));
        }
        if (in == null) {
            throw new IsacRuntimeException("Plug-in ~FileReader~ can't find file " + filename);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int c;
            while ((c = in.read()) != -1) {
                out.write(c);
            }
        }
        catch (IOException ex) {
            throw new IsacRuntimeException("Plug-in ~FileReader~ can't read file " + filename, (Exception)ex);
        }
        if (charset == null || charset.trim().isEmpty() || charset.equals("default")) {
            data = out.toString();
        } else {
            try {
                data = out.toString(charset);
            }
            catch (UnsupportedEncodingException ex) {
                throw new IsacRuntimeException("Plug-in ~FileReader~ can't apply character encoding " + charset);
            }
        }
        return data;
    }

    public SessionObject(Map<String, String> params) throws IsacRuntimeException {
        String filename = params.get("filename").trim();
        this.importData = filename == null || filename.isEmpty() ? null : SessionObject.readData(filename, ParameterParser.getCombo((String)params.get("charset")));
    }

    private SessionObject(SessionObject toClone) {
        this.data = this.importData = toClone.importData;
    }

    public String doGet(String dummy) throws IsacRuntimeException {
        if (this.data != null) {
            return this.data;
        }
        throw new IsacRuntimeException("This instance of plug-in ~FileReader~ is not set.");
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
    }

    public void reset() {
        this.data = this.importData;
    }

    public void doControl(int number, Map<String, String> params) throws IsacRuntimeException {
        switch (number) {
            case 3: {
                this.data = null;
                break;
            }
            case 0: {
                this.data = null;
                this.data = SessionObject.readData(params.get("filename"), ParameterParser.getCombo((String)params.get("charset")));
                break;
            }
            default: {
                throw new Error("Unable to find this control in ~FileReader~ ISAC plugin: " + number);
            }
        }
    }

    public boolean doTest(int number, Map<String, String> params) {
        switch (number) {
            case 2: {
                return this.data == null;
            }
            case 1: {
                return this.data != null;
            }
        }
        throw new Error("Unable to find this test in ~FileReader~ ISAC plugin: " + number);
    }
}

