/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.keyinfo;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyInfoGeneratorManager {
    private Map<Class<? extends Credential>, KeyInfoGeneratorFactory> factories = new HashMap<Class<? extends Credential>, KeyInfoGeneratorFactory>(5);

    public void registerFactory(KeyInfoGeneratorFactory factory) {
        this.factories.put(factory.getCredentialType(), factory);
    }

    public void deregisterFactory(KeyInfoGeneratorFactory factory) {
        this.factories.remove(factory.getCredentialType());
    }

    public Collection<KeyInfoGeneratorFactory> getFactories() {
        return Collections.unmodifiableCollection(this.factories.values());
    }

    public KeyInfoGeneratorFactory getFactory(Credential credential) {
        return this.factories.get(credential.getCredentialType());
    }
}

