/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.objectweb.fractal.adl.ContextMap;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;

public final class CompileToJava {
    private CompileToJava() {
    }

    public static void main(String[] args) throws Exception {
        String[] pargs = CompileToJava.parseArgs(args);
        String backend = pargs[0].equals("-java") ? "org.objectweb.fractal.adl.StaticJavaBackend" : "org.objectweb.fractal.adl.StaticFractalBackend";
        String definition = pargs[1];
        PrintWriter printWriter = pargs[2] == null ? new PrintWriter(System.out, true) : new PrintWriter((Writer)new FileWriter(pargs[2]), true);
        Map<Object, Object> context = ContextMap.instance();
        context.put("printwriter", printWriter);
        Factory f = FactoryFactory.getFactory(backend);
        f.newComponent(definition, context);
    }

    private static String[] parseArgs(String[] args) {
        if (args.length < 1 || args.length > 3) {
            CompileToJava.parseError();
        }
        String[] result = new String[3];
        if (args[0].equals("-java") || args[0].equals("-fractal")) {
            if (args.length < 2) {
                CompileToJava.parseError();
            }
            result[0] = args[0];
            result[1] = args[1];
            result[2] = args.length == 3 ? args[2] : null;
        } else {
            result[0] = "-java";
            result[1] = args[0];
            result[2] = args.length >= 2 ? args[1] : null;
        }
        return result;
    }

    private static void parseError() {
        System.out.println("Usage: CompileToJava [-java|-fractal] <definition> [ <output> ]");
        System.out.println("where <definition> is the name of the component to compile,");
        System.out.println("and <output> is the output file name");
        System.exit(1);
    }
}

