/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextLocal<T> {
    private final Map<ContextRef, T> map = new HashMap<ContextRef, T>();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();

    public void set(Object context, T value) {
        this.expungeStaleEntries();
        this.map.put(new ContextRef(context), value);
    }

    public T get(Object context) {
        this.expungeStaleEntries();
        return this.map.get(new ContextRef(context));
    }

    private void expungeStaleEntries() {
        ContextRef ref;
        while ((ref = (ContextRef)this.queue.poll()) != null) {
            this.map.remove(ref);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ContextRef
    extends WeakReference<Object> {
        private final int hash;

        ContextRef(Object context) {
            super(context, ContextLocal.this.queue);
            this.hash = System.identityHashCode(context);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WeakReference) {
                return this.get() == ((WeakReference)obj).get();
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

