/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.BasicFactory;
import org.objectweb.fractal.adl.ContextMap;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.JavaCodeLoader;
import org.objectweb.fractal.adl.arguments.ArgumentComponentLoader;
import org.objectweb.fractal.adl.arguments.ArgumentLoader;
import org.objectweb.fractal.adl.attributes.AttributeCompiler;
import org.objectweb.fractal.adl.attributes.AttributeLoader;
import org.objectweb.fractal.adl.attributes.JavaAttributeBuilder;
import org.objectweb.fractal.adl.bindings.BindingCompiler;
import org.objectweb.fractal.adl.bindings.JavaBindingBuilder;
import org.objectweb.fractal.adl.bindings.TypeBindingLoader;
import org.objectweb.fractal.adl.bindings.UnboundInterfaceDetectorLoader;
import org.objectweb.fractal.adl.components.ComponentCompiler;
import org.objectweb.fractal.adl.components.JavaComponentBuilder;
import org.objectweb.fractal.adl.components.PrimitiveComponentCompiler;
import org.objectweb.fractal.adl.implementations.ImplementationCompiler;
import org.objectweb.fractal.adl.implementations.ImplementationLoader;
import org.objectweb.fractal.adl.implementations.JavaImplementationBuilder;
import org.objectweb.fractal.adl.interfaces.InterfaceLoader;
import org.objectweb.fractal.adl.merger.NodeMergerImpl;
import org.objectweb.fractal.adl.types.JavaTypeBuilder;
import org.objectweb.fractal.adl.types.TypeCompiler;
import org.objectweb.fractal.adl.types.TypeLoader;
import org.objectweb.fractal.adl.xml.XMLLoader;
import org.objectweb.fractal.adl.xml.XMLNodeFactoryImpl;
import org.objectweb.fractal.task.core.BasicScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryFactory {
    public static final String DEFAULT_FACTORY = "org.objectweb.fractal.adl.BasicFactory";
    public static final String FRACTAL_BACKEND = "org.objectweb.fractal.adl.FractalBackend";
    public static final String STATIC_FRACTAL_BACKEND = "org.objectweb.fractal.adl.StaticFractalBackend";
    public static final String JAVA_BACKEND = "org.objectweb.fractal.adl.JavaBackend";
    public static final String STATIC_JAVA_BACKEND = "org.objectweb.fractal.adl.StaticJavaBackend";
    public static final String FRACTALADL_PARAMETER_PREFIX = "fractaladl.";
    public static final String BACKEND_PROPERTY_NAME = "fractaladl.backend";
    private static Factory factory;

    private FactoryFactory() {
    }

    public static Factory getFactory() {
        if (factory != null) {
            return factory;
        }
        BasicFactory r = new BasicFactory();
        JavaCodeLoader cl = new JavaCodeLoader();
        NodeMergerImpl nm = new NodeMergerImpl();
        XMLNodeFactoryImpl nFact = new XMLNodeFactoryImpl();
        XMLLoader xmll = new XMLLoader();
        ArgumentLoader argl = new ArgumentLoader();
        ArgumentComponentLoader compl = new ArgumentComponentLoader();
        InterfaceLoader itfl = new InterfaceLoader();
        TypeLoader typl = new TypeLoader();
        AttributeLoader attrl = new AttributeLoader();
        ImplementationLoader impll = new ImplementationLoader();
        TypeBindingLoader bindl = new TypeBindingLoader();
        UnboundInterfaceDetectorLoader uidl = new UnboundInterfaceDetectorLoader();
        TypeCompiler typc = new TypeCompiler();
        ImplementationCompiler implc = new ImplementationCompiler();
        PrimitiveComponentCompiler compc = new PrimitiveComponentCompiler();
        BindingCompiler bindc = new BindingCompiler();
        AttributeCompiler attrc = new AttributeCompiler();
        ComponentCompiler allc = new ComponentCompiler();
        JavaTypeBuilder typb = new JavaTypeBuilder();
        JavaImplementationBuilder implb = new JavaImplementationBuilder();
        JavaComponentBuilder compb = new JavaComponentBuilder();
        JavaBindingBuilder bindb = new JavaBindingBuilder();
        JavaAttributeBuilder attrb = new JavaAttributeBuilder();
        BasicScheduler s = new BasicScheduler();
        typc.bindFc("builder", typb);
        implc.bindFc("builder", implb);
        compc.bindFc("builder", compb);
        bindc.bindFc("builder", bindb);
        attrc.bindFc("builder", attrb);
        xmll.nodeFactoryItf = nFact;
        argl.clientLoader = xmll;
        compl.clientLoader = argl;
        itfl.clientLoader = compl;
        typl.clientLoader = itfl;
        attrl.clientLoader = typl;
        impll.clientLoader = attrl;
        bindl.clientLoader = impll;
        uidl.clientLoader = bindl;
        typl.interfaceCodeLoaderItf = cl;
        impll.interfaceLoaderItf = cl;
        impll.implementationCodeLoaderItf = cl;
        bindl.interfaceCodeLoaderItf = cl;
        attrl.interfaceLoaderItf = cl;
        compl.nodeMergerItf = nm;
        allc.bindFc("primitive-compilers0", typc);
        allc.bindFc("primitive-compilers1", implc);
        allc.bindFc("primitive-compilers2", compc);
        allc.bindFc("primitive-compilers3", bindc);
        allc.bindFc("primitive-compilers4", attrc);
        r.bindFc("loader", uidl);
        r.bindFc("compiler", allc);
        r.bindFc("scheduler", s);
        factory = r;
        return r;
    }

    public static Factory getFactory(String backend) throws ADLException {
        return FactoryFactory.getFactory(backend, ContextMap.instance());
    }

    public static Factory getFactory(String backend, Map<Object, Object> context) throws ADLException {
        return FactoryFactory.getFactory(DEFAULT_FACTORY, backend, context);
    }

    public static Factory getFactory(String factory, String backend, Map<Object, Object> context) throws ADLException {
        Factory f = FactoryFactory.getFactory();
        context.put(BACKEND_PROPERTY_NAME, backend);
        Map c = (Map)f.newComponent(factory, context);
        return (Factory)c.get("factory");
    }
}

