/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.ContextMap;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.util.Fractal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher {
    public static final String PARAMETER_NAME_TRAILING_CHAR = "-";
    public static final String PARAMETER_NAME_VALUE_SEPARATOR_CHAR = "=";
    public static final String FRACTAL_PROVIDER_PROPERTY_NAME = "fractal.provider";
    public static final String DAEMON_PROPERTY_NAME = "fractaladl.daemon";
    public static final String DAEMON_PROPERTY_DEFAULT_VALUE = "true";
    public static final String FACTORY_PROPERTY_NAME = "fractaladl.factory";
    public static final String COMPONENT_DEFINITION_PROPERTY_NAME = "fractaladl.definition";
    public static final String RUNNABLE_INTERFACE_PROPERTY_NAME = "fractaladl.itf";
    public static final String RUNNABLE_INTERFACE_DEFAULT_VALUE = "r";
    protected Factory factory;
    protected Map<Object, Object> compilerContext;

    public Launcher(String factoryDefinition, String backendDefinition, Map<Object, Object> compilerCreationContext) throws ADLException {
        this.factory = this.createFactory(factoryDefinition, backendDefinition, compilerCreationContext);
        this.compilerContext = new HashMap<Object, Object>(compilerCreationContext);
    }

    public Launcher(Map<Object, Object> params) throws ADLException {
        this((String)params.get(FACTORY_PROPERTY_NAME), (String)params.get("fractaladl.backend"), params);
    }

    public Map<Object, Object> getCompilerContext() {
        return new HashMap<Object, Object>(this.compilerContext);
    }

    public Factory getFactory() {
        return this.factory;
    }

    Factory createFactory(String factoryDefinition, String backendDefinition, Map<Object, Object> factoryCreationContext) throws ADLException {
        return FactoryFactory.getFactory(factoryDefinition, backendDefinition, factoryCreationContext);
    }

    public void compile(String componentDefinition) throws ADLException, IllegalLifeCycleException {
        this.compile(componentDefinition, ContextMap.instance());
    }

    public void compile(String componentDefinition, Map<Object, Object> context) throws ADLException, IllegalLifeCycleException {
        HashMap<Object, Object> actualParams = new HashMap<Object, Object>();
        actualParams.putAll(this.compilerContext);
        actualParams.putAll(context);
        Object comp = this.factory.newComponent(componentDefinition, actualParams);
        Object runnableInterface = actualParams.get(RUNNABLE_INTERFACE_PROPERTY_NAME);
        if (comp instanceof Component) {
            LifeCycleController lc = null;
            try {
                lc = Fractal.getLifeCycleController((Component)((Component)comp));
            }
            catch (NoSuchInterfaceException ignored) {
                // empty catch block
            }
            if (lc != null) {
                lc.startFc();
            }
            Runnable r = null;
            try {
                r = (Runnable)((Component)comp).getFcInterface((String)runnableInterface);
            }
            catch (NoSuchInterfaceException ignored) {
                System.err.println("Impossible to find a Runnable interface named '" + runnableInterface + "'");
            }
            if (r != null) {
                r.run();
            }
            if (lc != null && !this.isDaemon(actualParams)) {
                lc.stopFc();
            }
        } else if (comp instanceof Map) {
            if ((comp = ((Map)comp).get(runnableInterface)) instanceof LifeCycleController) {
                ((LifeCycleController)comp).startFc();
            }
            if (comp instanceof Runnable) {
                ((Runnable)comp).run();
            }
            if (comp instanceof LifeCycleController && !this.isDaemon(actualParams)) {
                ((LifeCycleController)comp).stopFc();
            }
        }
    }

    final boolean isDaemon(Map<Object, Object> context) {
        String daemon = (String)context.get(DAEMON_PROPERTY_NAME);
        return Boolean.valueOf(daemon);
    }

    public static void main(String[] pargs) throws Exception {
        Map<Object, Object> context = ContextMap.instance();
        context.put(FACTORY_PROPERTY_NAME, "org.objectweb.fractal.adl.BasicFactory");
        context.put("fractaladl.backend", "org.objectweb.fractal.adl.JavaBackend");
        context.put(RUNNABLE_INTERFACE_PROPERTY_NAME, RUNNABLE_INTERFACE_DEFAULT_VALUE);
        context.put(DAEMON_PROPERTY_NAME, DAEMON_PROPERTY_DEFAULT_VALUE);
        HashMap<Object, Object> systemPropertiesMap = new HashMap<Object, Object>(System.getProperties());
        context.putAll(systemPropertiesMap);
        Map<String, String> commandLinePropertiesMap = Launcher.parseCommandLineParameters(pargs);
        context.putAll(commandLinePropertiesMap);
        context.put("classloader", Thread.currentThread().getContextClassLoader());
        Launcher launcher = new Launcher(context);
        launcher.compile(commandLinePropertiesMap.get(COMPONENT_DEFINITION_PROPERTY_NAME));
    }

    private static Map<String, String> parseCommandLineParameters(String[] args) {
        return Launcher.parseArgsAsMap(args);
    }

    static Map<String, String> parseArgsAsMap(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        String paramName = null;
        String paramValue = null;
        int index = -1;
        String definition = null;
        String runnableItf = null;
        for (String currentArg : args) {
            if (currentArg.startsWith(PARAMETER_NAME_TRAILING_CHAR)) {
                if (currentArg.contains(PARAMETER_NAME_VALUE_SEPARATOR_CHAR)) {
                    index = currentArg.indexOf(PARAMETER_NAME_VALUE_SEPARATOR_CHAR);
                    paramName = currentArg.substring(1, index);
                    paramValue = currentArg.substring(index + 1);
                    result.put(paramName, paramValue);
                    continue;
                }
                if (currentArg.equals("-java")) {
                    result.put("fractaladl.backend", "org.objectweb.fractal.adl.JavaBackend");
                    continue;
                }
                if (currentArg.equals("-fractal")) {
                    result.put("fractaladl.backend", "org.objectweb.fractal.adl.FractalBackend");
                    continue;
                }
                Launcher.parseError();
                throw new RuntimeException("The parameter '" + currentArg + "' is unknown.");
            }
            if (definition == null) {
                definition = currentArg;
                result.put(COMPONENT_DEFINITION_PROPERTY_NAME, definition);
                continue;
            }
            if (runnableItf == null) {
                runnableItf = currentArg;
                result.put(RUNNABLE_INTERFACE_PROPERTY_NAME, runnableItf);
                continue;
            }
            Launcher.parseError();
            throw new RuntimeException("Too many args: you already specified the definition to load and its runnable interface name");
        }
        return result;
    }

    private static void parseError() {
        System.out.println("Usage: Launcher [-java|-fractal] [ (-<paramName=paramValue)* ] [<definition>] [ <itf> ] ");
        System.out.print("where <definition> is the name of the component to be ");
        System.out.print("instantiated and started,\nand <itf> is the name of ");
        System.out.println("its Runnable interface, if it has one");
    }
}

