/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.arguments;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.arguments.ArgumentDefinition;
import org.objectweb.fractal.adl.arguments.ArgumentErrors;
import org.objectweb.fractal.adl.arguments.ArgumentHelper;
import org.objectweb.fractal.adl.error.ErrorTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentLoader
extends AbstractLoader {
    public static final String ARGUMENT_CONTEXT_PREFIX = "__arg__";
    public static final String PREFIX_SEPARATOR = ":";
    public static final String JAVA_PROPERTY_PREFIX = "java";
    public static final String CONTEXT_PROPERTY_PREFIX = "context";

    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        String args;
        Definition d = this.clientLoader.load(name, context);
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (d instanceof ArgumentDefinition && (args = ((ArgumentDefinition)d).getArguments()) != null) {
            int i = 0;
            for (String arg : args.split(",")) {
                String argdef;
                String argname;
                int j = arg.indexOf(61);
                if (j != -1) {
                    argname = arg.substring(0, j).trim();
                    argdef = arg.substring(j + 1).trim();
                } else {
                    argname = arg.trim();
                    argdef = null;
                }
                if (argname.length() == 0) {
                    throw new ADLException((ErrorTemplate)ArgumentErrors.EMPTY_ARGUMENT_NAME, (Node)d, new Object[]{args});
                }
                if (argname.contains(PREFIX_SEPARATOR)) {
                    throw new ADLException((ErrorTemplate)ArgumentErrors.INVALID_ARGNAME, (Node)d, new Object[]{argname, PREFIX_SEPARATOR});
                }
                if (argname.contains("$")) {
                    throw new ADLException((ErrorTemplate)ArgumentErrors.INVALID_ARGNAME, (Node)d, new Object[]{argname, "$"});
                }
                Object argval = context.get(ARGUMENT_CONTEXT_PREFIX + argname);
                if (argval == null) {
                    argval = context.get(ARGUMENT_CONTEXT_PREFIX + i);
                }
                if (argval == null) {
                    argval = this.evaluate(argdef, values, d, context);
                }
                if (argval == null) {
                    throw new ADLException((ErrorTemplate)ArgumentErrors.NO_VALUE, (Node)d, new Object[]{argname});
                }
                values.put(argname, argval);
                ++i;
            }
            ((ArgumentDefinition)d).setArguments(null);
        }
        if (context != null) {
            Iterator<Object> contextKeys = context.keySet().iterator();
            while (contextKeys.hasNext()) {
                Object contextKey = contextKeys.next();
                if (!(contextKey instanceof String) || !((String)contextKey).startsWith(ARGUMENT_CONTEXT_PREFIX)) continue;
                contextKeys.remove();
            }
        }
        this.evaluate(d, values, context);
        return d;
    }

    void evaluate(Node node, Map<String, Object> values, Map<Object, Object> context) throws ADLException {
        Map attrs = node.astGetAttributes();
        for (Map.Entry attrEntry : attrs.entrySet()) {
            String attr = (String)attrEntry.getKey();
            String value = (String)attrEntry.getValue();
            if (value == null) continue;
            value = this.evaluate(value, values, node, context);
            attrs.put(attr, value);
        }
        node.astSetAttributes(attrs);
        for (String nodeType : node.astGetNodeTypes()) {
            for (Node n : node.astGetNodes(nodeType)) {
                if (n == null) continue;
                this.evaluate(n, values, context);
            }
        }
    }

    String evaluate(String s, Map<String, Object> values, Node location, Map<Object, Object> context) throws ADLException {
        Object value;
        String argdef;
        String argname;
        if (s == null) {
            return null;
        }
        String[] tokens = ArgumentHelper.splitNameRef(s);
        if (tokens == null) {
            throw new ADLException((ErrorTemplate)ArgumentErrors.INVALID_PATTERN_SYNTAX_ERROR, location, new Object[]{s});
        }
        if (tokens.length == 1) {
            return tokens[0];
        }
        String arg = tokens[1];
        int i = arg.indexOf(61);
        if (i != -1) {
            argname = arg.substring(0, i);
            argdef = arg.substring(i + 1);
        } else {
            argname = arg;
            argdef = null;
        }
        i = argname.indexOf(PREFIX_SEPARATOR);
        if (i == -1) {
            if (argdef != null) {
                throw new ADLException((ErrorTemplate)ArgumentErrors.INVALID_PATTERN_DEFAULT_VALUE, location, new Object[]{argname});
            }
            value = values.get(argname);
            if (value == null) {
                throw new ADLException((ErrorTemplate)ArgumentErrors.UNDEFINED_ARGUMENT, location, new Object[]{argname});
            }
        } else {
            String prefix = argname.substring(0, i);
            argname = argname.substring(i + 1);
            if (prefix.equals(JAVA_PROPERTY_PREFIX)) {
                value = System.getProperty(argname);
            } else if (prefix.equals(CONTEXT_PROPERTY_PREFIX)) {
                value = context.get(argname);
            } else {
                throw new ADLException((ErrorTemplate)ArgumentErrors.UNKNOWN_PREFIX, location, new Object[]{prefix, arg});
            }
            if (value == null) {
                value = this.evaluate(argdef, values, location, context);
            }
            if (value == null) {
                throw new ADLException((ErrorTemplate)ArgumentErrors.UNDEFINED_ARGUMENT, location, new Object[]{argname});
            }
            if (!(value instanceof String)) {
                throw new ADLException((ErrorTemplate)ArgumentErrors.INVALID_VALUE_NOT_A_STRING, location, new Object[]{argname});
            }
        }
        return this.evaluate(tokens[0] + value + tokens[2], values, location, context);
    }
}

