/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.bindings;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.bindings.Binding;
import org.objectweb.fractal.adl.bindings.BindingBuilder;
import org.objectweb.fractal.adl.bindings.BindingContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentPair;
import org.objectweb.fractal.adl.components.PrimitiveCompiler;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.task.core.Task;
import org.objectweb.fractal.task.core.TaskMap;
import org.objectweb.fractal.task.deployment.api.InstanceProviderTask;
import org.objectweb.fractal.task.deployment.lib.AbstractRequireInstanceProviderTask;

public class BindingCompiler
implements BindingController,
PrimitiveCompiler {
    public static final String BUILDER_BINDING = "builder";
    public BindingBuilder builder;

    public String[] listFc() {
        return new String[]{BUILDER_BINDING};
    }

    public Object lookupFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            return this.builder;
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = (BindingBuilder)value;
        }
    }

    public void unbindFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = null;
        }
    }

    public void compile(List path, ComponentContainer container, TaskMap tasks, Map context) throws ADLException {
        HashMap<String, ComponentContainer> subComponents = new HashMap<String, ComponentContainer>();
        subComponents.put("this", container);
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            subComponents.put(comps[i].getName(), comps[i]);
        }
        if (container instanceof BindingContainer) {
            Binding[] bindings = ((BindingContainer)((Object)container)).getBindings();
            for (int i = 0; i < bindings.length; ++i) {
                Binding binding = bindings[i];
                String value = binding.getFrom();
                int index = value.indexOf(46);
                Object clientComp = subComponents.get(value.substring(0, index));
                String clientItf = value.substring(index + 1);
                value = binding.getTo();
                index = value.indexOf(46);
                Object serverComp = subComponents.get(value.substring(0, index));
                String serverItf = value.substring(index + 1);
                TaskMap.TaskHole createClientTaskHole = tasks.getTaskHole("create", clientComp);
                TaskMap.TaskHole createServerTaskHole = tasks.getTaskHole("create", serverComp);
                int type = 0;
                if (binding.getFrom().startsWith("this.")) {
                    type = 1;
                }
                if (binding.getTo().startsWith("this.")) {
                    type = 2;
                }
                try {
                    tasks.getTask("bind" + clientItf, clientComp);
                    continue;
                }
                catch (NoSuchElementException e) {
                    TaskMap.TaskHole addTaskHole;
                    BindTask bindTask = new BindTask(this.builder, type, clientItf, serverItf);
                    bindTask.setInstanceProviderTask(createClientTaskHole);
                    bindTask.setServerInstanceProviderTask(createServerTaskHole);
                    TaskMap.TaskHole bindTaskHole = tasks.addTask("bind" + clientItf, clientComp, (Task)bindTask);
                    if (clientComp != container) {
                        addTaskHole = tasks.getTaskHole("add", (Object)new ComponentPair(container, (Component)clientComp));
                        bindTask.addDependency(addTaskHole, Task.PREVIOUS_TASK_ROLE, context);
                    }
                    if (serverComp != container) {
                        addTaskHole = tasks.getTaskHole("add", (Object)new ComponentPair(container, (Component)serverComp));
                        bindTask.addDependency(addTaskHole, Task.PREVIOUS_TASK_ROLE, context);
                    }
                    TaskMap.TaskHole startTaskHole = tasks.getTaskHole("start", clientComp);
                    startTaskHole.addDependency(bindTaskHole, Task.PREVIOUS_TASK_ROLE, (Object)context);
                }
            }
        }
    }

    static class BindTask
    extends AbstractRequireInstanceProviderTask {
        private TaskMap.TaskHole serverInstanceProviderTask;
        private BindingBuilder builder;
        private int type;
        private String clientItf;
        private String serverItf;

        public BindTask(BindingBuilder builder, int type, String clientItf, String serverItf) {
            this.builder = builder;
            this.type = type;
            this.clientItf = clientItf;
            this.serverItf = serverItf;
        }

        public InstanceProviderTask getServerInstanceProviderTask() {
            return this.serverInstanceProviderTask == null ? null : (InstanceProviderTask)this.serverInstanceProviderTask.getTask();
        }

        public void setServerInstanceProviderTask(TaskMap.TaskHole task) {
            if (this.serverInstanceProviderTask != null) {
                this.removePreviousTask(this.serverInstanceProviderTask);
            }
            this.serverInstanceProviderTask = task;
            if (this.serverInstanceProviderTask != null) {
                this.addPreviousTask(this.serverInstanceProviderTask);
            }
        }

        public void execute(Map context) throws Exception {
            Object client = this.getInstanceProviderTask().getInstance();
            Object server = this.getServerInstanceProviderTask().getInstance();
            this.builder.bindComponent(this.type, client, this.clientItf, server, this.serverItf, context);
        }

        public Object getResult() {
            return null;
        }

        public void setResult(Object result) {
        }

        public String toString() {
            return "T" + System.identityHashCode((Object)this) + "[BindTask(" + this.clientItf + "," + this.serverItf + ")]";
        }
    }
}

