/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.bindings;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.bindings.Binding;
import org.objectweb.fractal.adl.bindings.BindingContainer;
import org.objectweb.fractal.adl.bindings.BindingErrors;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.error.ErrorTemplate;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingLoader
extends AbstractLoader {
    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkNode(d, context);
        return d;
    }

    protected void checkNode(Object node, Map<Object, Object> context) throws ADLException {
        if (node instanceof BindingContainer) {
            HashMap<String, Map<String, Interface>> itfMap = new HashMap<String, Map<String, Interface>>();
            if (node instanceof InterfaceContainer) {
                HashMap<String, Interface> containerItfs = new HashMap<String, Interface>();
                for (Interface itf : ((InterfaceContainer)node).getInterfaces()) {
                    containerItfs.put(itf.getName(), itf);
                }
                itfMap.put("this", containerItfs);
            }
            if (node instanceof ComponentContainer) {
                for (Component comp : ((ComponentContainer)node).getComponents()) {
                    if (!(comp instanceof InterfaceContainer)) continue;
                    HashMap<String, Interface> compItfs = new HashMap<String, Interface>();
                    for (Interface itf : ((InterfaceContainer)((Object)comp)).getInterfaces()) {
                        compItfs.put(itf.getName(), itf);
                    }
                    itfMap.put(comp.getName(), compItfs);
                }
            }
            for (Binding binding : ((BindingContainer)node).getBindings()) {
                this.checkBinding(binding, itfMap, context);
            }
            HashMap<String, Binding> fromItfs = new HashMap<String, Binding>();
            for (Binding binding : ((BindingContainer)node).getBindings()) {
                Binding previousDefinition = fromItfs.put(binding.getFrom(), binding);
                if (previousDefinition == null) continue;
                throw new ADLException((ErrorTemplate)BindingErrors.DUPLICATED_BINDING, (Node)binding, new Object[]{binding.getFrom(), previousDefinition});
            }
        }
        if (node instanceof ComponentContainer) {
            for (Component comp : ((ComponentContainer)node).getComponents()) {
                this.checkNode(comp, context);
            }
        }
    }

    protected void checkBinding(Binding binding, Map<String, Map<String, Interface>> itfMap, Map<Object, Object> context) throws ADLException {
        String toItfName;
        String from = binding.getFrom();
        String to = binding.getTo();
        if (from == null) {
            throw new ADLException((ErrorTemplate)BindingErrors.MISSING_FROM, (Node)binding, new Object[0]);
        }
        if (to == null) {
            throw new ADLException((ErrorTemplate)BindingErrors.MISSING_TO, (Node)binding, new Object[0]);
        }
        int i = from.indexOf(46);
        if (i < 1 || i == from.length() - 1) {
            throw new ADLException((ErrorTemplate)BindingErrors.INVALID_FROM_SYNTAX, (Node)binding, new Object[]{from});
        }
        String fromCompName = from.substring(0, i);
        String fromItfName = from.substring(i + 1);
        i = to.indexOf(46);
        if (i < 1 || i == to.length() - 1) {
            throw new ADLException((ErrorTemplate)BindingErrors.INVALID_TO_SYNTAX, (Node)binding, new Object[]{to});
        }
        String toCompName = to.substring(0, i);
        if (!this.ignoreBinding(binding, fromCompName, fromItfName, toCompName, toItfName = to.substring(i + 1))) {
            Interface fromItf = this.getInterface(fromCompName, fromItfName, binding, itfMap);
            Interface toItf = this.getInterface(toCompName, toItfName, binding, itfMap);
            if (fromItf != null && toItf != null) {
                this.checkBinding(binding, fromItf, fromCompName, fromItfName, toItf, toCompName, toItfName, context);
            }
        }
    }

    protected void checkBinding(Binding binding, Interface fromItf, String fromCompName, String fromItfName, Interface toItf, String toCompName, String toItfName, Map<Object, Object> context) throws ADLException {
    }

    protected Interface getInterface(String compName, String itfName, Node sourceNode, Map<String, Map<String, Interface>> itfMap) throws ADLException {
        Map<String, Interface> compItfs = itfMap.get(compName);
        if (compItfs == null) {
            throw new ADLException((ErrorTemplate)BindingErrors.INVALID_ITF_NO_SUCH_COMPONENT, sourceNode, new Object[]{compName});
        }
        Interface itf = compItfs.get(itfName);
        if (itf == null) {
            throw new ADLException((ErrorTemplate)BindingErrors.INVALID_ITF_NO_SUCH_INTERFACE, sourceNode, new Object[]{compName, itfName});
        }
        return itf;
    }

    protected boolean ignoreBinding(Binding binding, String fromCompName, String fromItfName, String toCompName, String toItfName) {
        return fromItfName.equals("component") || fromItfName.endsWith("-controller") || toItfName.equals("component") || toItfName.endsWith("-controller");
    }
}

