/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.bindings;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.adl.bindings.JavaBindingEnd;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;

public final class JavaBindingUtil {
    static final String IMPORT_BINDING_PREFIX = "__IMPORT__";

    private JavaBindingUtil() {
    }

    public static String[] listFc(Object component) {
        HashSet<String> itfNames = new HashSet<String>();
        if (component instanceof BindingController) {
            String[] s;
            for (String s1 : s = ((BindingController)component).listFc()) {
                itfNames.add(s1);
            }
        }
        return itfNames.toArray(new String[0]);
    }

    public static void bindFc(Object component, String itfName, Object serverItf) throws IllegalBindingException {
        try {
            Method m = component.getClass().getMethod("bindFc", String.class, Object.class);
            m.invoke(component, itfName, serverItf);
        }
        catch (Exception e) {
            IllegalBindingException ibe = new IllegalBindingException("Can't bind client interface '" + itfName + "' of component '" + component.getClass().getName() + "'");
            ibe.initCause((Throwable)e);
            throw ibe;
        }
    }

    public static void bindComposite(Map composite, String itfName, Object serverItf) throws IllegalBindingException {
        Set importBindings = (Set)composite.get(IMPORT_BINDING_PREFIX + itfName);
        if (importBindings != null) {
            for (JavaBindingEnd client : importBindings) {
                JavaBindingUtil.bindFc(client.component, client.itfName, serverItf);
            }
        } else {
            throw new IllegalBindingException("Can't bind client interface '" + itfName + "' of composite component: no such interface");
        }
    }

    static void storeReverseImportBinding(JavaBindingEnd compositeClientSide, JavaBindingEnd subComponentClientSide) {
        if (subComponentClientSide.isComposite()) {
            return;
        }
        Map composite = (Map)compositeClientSide.component;
        HashSet<JavaBindingEnd> importBindings = (HashSet<JavaBindingEnd>)composite.get(IMPORT_BINDING_PREFIX + compositeClientSide.itfName);
        if (importBindings == null) {
            importBindings = new HashSet<JavaBindingEnd>();
            composite.put(IMPORT_BINDING_PREFIX + compositeClientSide.itfName, importBindings);
        }
        importBindings.add(subComponentClientSide);
    }
}

