/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.bindings;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.adl.ContextLocal;
import org.objectweb.fractal.adl.bindings.BindingBuilder;
import org.objectweb.fractal.adl.bindings.JavaBindingEnd;

public class StaticJavaBindingBuilder
implements BindingBuilder {
    private final ContextLocal<State> states = new ContextLocal();

    public void bindComponent(int type, Object clientComp, String clientItf, Object serverComp, String serverItf, Object context) {
        State state = this.states.get(context);
        if (state == null) {
            state = new State();
            this.states.set(context, state);
        }
        PrintWriter pw = (PrintWriter)((Map)context).get("printwriter");
        BindingEnd clientSide = new BindingEnd();
        clientSide.comp = (String)clientComp;
        clientSide.itf = clientItf;
        BindingEnd serverSide = new BindingEnd();
        serverSide.comp = (String)serverComp;
        serverSide.itf = serverItf;
        state.bindings.put(clientSide, serverSide);
        Iterator<Map.Entry<BindingEnd, BindingEnd>> iter = state.bindings.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<BindingEnd, BindingEnd> entry = iter.next();
            clientSide = entry.getKey();
            serverSide = entry.getValue();
            boolean clientComposite = clientSide.isComposite();
            while (serverSide != null && serverSide.isComposite()) {
                if (!clientComposite) {
                    Set<BindingEnd> reverseBindings = state.reverseImportBindings.get(serverSide);
                    StringBuffer buf = null;
                    if (reverseBindings == null) {
                        reverseBindings = new HashSet<BindingEnd>();
                        state.reverseImportBindings.put(serverSide, reverseBindings);
                        buf = new StringBuffer();
                        buf.append("java.util.Set<").append(JavaBindingEnd.class.getName()).append("> ").append(serverSide.comp).append(serverSide.itf.replace('-', '_')).append("ReverseBindings = new java.util.HashSet<").append(JavaBindingEnd.class.getName()).append(">();").append("\n");
                        buf.append(serverSide.comp).append(".put(\"").append("__IMPORT__").append(serverSide.itf).append("\", ").append(serverSide.comp).append(serverSide.itf.replace('-', '_')).append("ReverseBindings);\n");
                    }
                    if (reverseBindings.add(clientSide)) {
                        if (buf == null) {
                            buf = new StringBuffer();
                        }
                        buf.append(serverSide.comp).append(serverSide.itf.replace('-', '_')).append("ReverseBindings.add(new ").append(JavaBindingEnd.class.getName()).append("(").append(clientSide.comp).append(", \"").append(clientSide.itf).append("\"));\n");
                        pw.print(buf.toString());
                    }
                }
                serverSide = state.bindings.get(serverSide);
            }
            if (serverSide == null) continue;
            if (clientComposite) {
                if (!state.exportBinding.add(clientSide)) continue;
                StringBuffer buf = new StringBuffer();
                buf.append(clientSide.comp).append(".put(\"").append(clientSide.itf).append("\", ").append(serverSide.comp).append(");");
                pw.println(buf.toString());
                continue;
            }
            pw.print(clientSide.comp);
            pw.print(".bindFc(\"");
            pw.print(clientSide.itf);
            pw.print("\", ");
            pw.print(serverSide.comp);
            pw.println(");");
            iter.remove();
        }
    }

    static class State {
        Map<BindingEnd, BindingEnd> bindings = new HashMap<BindingEnd, BindingEnd>();
        Map<BindingEnd, Set<BindingEnd>> reverseImportBindings = new HashMap<BindingEnd, Set<BindingEnd>>();
        Set<BindingEnd> exportBinding = new HashSet<BindingEnd>();

        State() {
        }
    }

    static class BindingEnd {
        String comp;
        String itf;

        BindingEnd() {
        }

        boolean isComposite() {
            return !this.comp.startsWith("P");
        }

        void bind(BindingEnd serverSide, PrintWriter pw) {
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof BindingEnd) {
                return ((BindingEnd)obj).comp.equals(this.comp) && ((BindingEnd)obj).itf.equals(this.itf);
            }
            return false;
        }

        public int hashCode() {
            return this.comp.hashCode() * this.itf.hashCode();
        }
    }
}

