/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.bindings;

import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.bindings.Binding;
import org.objectweb.fractal.adl.bindings.BindingErrors;
import org.objectweb.fractal.adl.bindings.BindingLoader;
import org.objectweb.fractal.adl.error.ErrorTemplate;
import org.objectweb.fractal.adl.error.NodeErrorLocator;
import org.objectweb.fractal.adl.interfaces.IDLLoader;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.types.TypeInterface;
import org.objectweb.fractal.adl.types.TypeInterfaceUtil;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeBindingLoader
extends BindingLoader {
    public static final String INTERFACE_LOADER_BINDING = "interface-loader";
    public IDLLoader interfaceCodeLoaderItf;

    @Override
    protected void checkBinding(Binding binding, Interface fromItf, String fromCompName, String fromItfName, Interface toItf, String toCompName, String toItfName, Map<Object, Object> context) throws ADLException {
        if (fromItf instanceof TypeInterface && toItf instanceof TypeInterface) {
            TypeInterface cItf = (TypeInterface)fromItf;
            TypeInterface sItf = (TypeInterface)toItf;
            if (fromCompName.equals("this")) {
                if (!TypeInterfaceUtil.isServer(cItf)) {
                    throw new ADLException((ErrorTemplate)BindingErrors.INVALID_FROM_INTERNAL, (Node)binding, new Object[]{fromItfName, new NodeErrorLocator(cItf)});
                }
            } else if (!TypeInterfaceUtil.isClient(cItf)) {
                throw new ADLException((ErrorTemplate)BindingErrors.INVALID_FROM_NOT_A_CLIENT, (Node)binding, new Object[]{binding.getFrom(), new NodeErrorLocator(cItf)});
            }
            if (toCompName.equals("this")) {
                if (!TypeInterfaceUtil.isClient(sItf)) {
                    throw new ADLException((ErrorTemplate)BindingErrors.INVALID_TO_INTERNAL, (Node)binding, new Object[]{toItfName, new NodeErrorLocator(cItf)});
                }
            } else if (!TypeInterfaceUtil.isServer(sItf)) {
                throw new ADLException((ErrorTemplate)BindingErrors.INVALID_TO_NOT_A_SERVER, (Node)binding, new Object[]{binding.getTo(), new NodeErrorLocator(sItf)});
            }
            if (TypeInterfaceUtil.isMandatory(cItf) && !TypeInterfaceUtil.isMandatory(sItf)) {
                throw new ADLException((ErrorTemplate)BindingErrors.INVALID_MANDATORY_TO_OPTIONAL, (Node)binding, new Object[]{binding.getFrom(), binding.getTo()});
            }
            if (this.interfaceCodeLoaderItf != null) {
                Object cClass = null;
                Object sClass = null;
                try {
                    cClass = this.interfaceCodeLoaderItf.loadInterface(cItf.getSignature(), context);
                    sClass = this.interfaceCodeLoaderItf.loadInterface(sItf.getSignature(), context);
                }
                catch (ADLException e) {
                    // empty catch block
                }
                if (cClass instanceof Class && sClass instanceof Class && !((Class)cClass).isAssignableFrom((Class)sClass)) {
                    throw new ADLException((ErrorTemplate)BindingErrors.INVALID_SIGNATURE, (Node)binding, new Object[]{new NodeErrorLocator(fromItf), new NodeErrorLocator(toItf)});
                }
            }
        }
    }

    @Override
    protected Interface getInterface(String compName, String itfName, Node sourceNode, Map<String, Map<String, Interface>> itfMap) throws ADLException {
        try {
            return super.getInterface(compName, itfName, sourceNode, itfMap);
        }
        catch (ADLException e) {
            Map<String, Interface> compItfs = itfMap.get(compName);
            if (compItfs == null) {
                throw e;
            }
            for (Map.Entry<String, Interface> entry : compItfs.entrySet()) {
                String n = entry.getKey();
                Interface itf = entry.getValue();
                if (!TypeInterfaceUtil.isCollection(itf) || !itfName.startsWith(n)) continue;
                return itf;
            }
            throw e;
        }
    }

    @Override
    public void bindFc(String s, Object o) throws NoSuchInterfaceException, IllegalBindingException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            this.interfaceCodeLoaderItf = (IDLLoader)o;
        } else {
            super.bindFc(s, o);
        }
    }

    @Override
    public String[] listFc() {
        String[] superList = super.listFc();
        String[] list = new String[superList.length + 1];
        list[0] = INTERFACE_LOADER_BINDING;
        System.arraycopy(superList, 0, list, 1, superList.length);
        return list;
    }

    @Override
    public Object lookupFc(String s) throws NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            return this.interfaceCodeLoaderItf;
        }
        return super.lookupFc(s);
    }

    @Override
    public void unbindFc(String s) throws IllegalBindingException, NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            this.interfaceCodeLoaderItf = null;
        } else {
            super.unbindFc(s);
        }
    }
}

