/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.components;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentBuilder;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentPair;
import org.objectweb.fractal.adl.components.PrimitiveCompiler;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.task.core.Task;
import org.objectweb.fractal.task.core.TaskMap;
import org.objectweb.fractal.task.deployment.api.InstanceProviderTask;
import org.objectweb.fractal.task.deployment.lib.AbstractInitializationTask;
import org.objectweb.fractal.task.deployment.lib.AbstractRequireInstanceProviderTask;

public class PrimitiveComponentCompiler
implements BindingController,
PrimitiveCompiler {
    public static final String BUILDER_BINDING = "builder";
    public ComponentBuilder builder;

    public String[] listFc() {
        return new String[]{BUILDER_BINDING};
    }

    public Object lookupFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            return this.builder;
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = (ComponentBuilder)value;
        }
    }

    public void unbindFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = null;
        }
    }

    public void compile(List path, ComponentContainer container, TaskMap tasks, Map context) throws ADLException {
        TaskMap.TaskHole createTaskHole = tasks.getTaskHole("create", (Object)container);
        StartTask startTask = new StartTask(this.builder);
        startTask.setInstanceProviderTask(createTaskHole);
        tasks.addTask("start", (Object)container, (Task)startTask);
        startTask.addDependency(createTaskHole, Task.PREVIOUS_TASK_ROLE, context);
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            TaskMap.TaskHole createSubComponentTaskHole = tasks.getTaskHole("create", (Object)comps[i]);
            ComponentPair pair = new ComponentPair(container, comps[i]);
            try {
                tasks.getTask("add", (Object)pair);
                continue;
            }
            catch (NoSuchElementException e) {
                AddTask addTask = new AddTask(this.builder, comps[i].getName());
                addTask.setInstanceProviderTask(createTaskHole);
                addTask.setSubInstanceProviderTask(createSubComponentTaskHole);
                TaskMap.TaskHole addTaskHole = tasks.addTask("add", (Object)pair, (Task)addTask);
                addTask.addDependency(createTaskHole, Task.PREVIOUS_TASK_ROLE, context);
                addTask.addDependency(createSubComponentTaskHole, Task.PREVIOUS_TASK_ROLE, context);
                startTask.addDependency(addTaskHole, Task.PREVIOUS_TASK_ROLE, context);
            }
        }
    }

    static class StartTask
    extends AbstractInitializationTask {
        private ComponentBuilder builder;

        public StartTask(ComponentBuilder builder) {
            this.builder = builder;
        }

        public void execute(Map context) throws Exception {
            this.builder.startComponent(this.getInstanceProviderTask().getInstance(), context);
        }

        public String toString() {
            return "T" + System.identityHashCode((Object)this) + "[StartTask()]";
        }
    }

    static class AddTask
    extends AbstractRequireInstanceProviderTask {
        private ComponentBuilder builder;
        private TaskMap.TaskHole subInstanceProviderTask;
        private String name;

        public AddTask(ComponentBuilder builder, String name) {
            this.builder = builder;
            this.name = name;
        }

        public InstanceProviderTask getSubInstanceProviderTask() {
            return this.subInstanceProviderTask == null ? null : (InstanceProviderTask)this.subInstanceProviderTask.getTask();
        }

        public void setSubInstanceProviderTask(TaskMap.TaskHole task) {
            if (this.subInstanceProviderTask != null) {
                this.removePreviousTask(this.subInstanceProviderTask);
            }
            this.subInstanceProviderTask = task;
            if (this.subInstanceProviderTask != null) {
                this.addPreviousTask(this.subInstanceProviderTask);
            }
        }

        public void execute(Map context) throws Exception {
            Object parent = this.getInstanceProviderTask().getInstance();
            Object child = this.getSubInstanceProviderTask().getInstance();
            this.builder.addComponent(parent, child, this.name, context);
        }

        public Object getResult() {
            return null;
        }

        public void setResult(Object result) {
        }

        public String toString() {
            return "T" + System.identityHashCode((Object)this) + "[AddTask(" + this.name + ")]";
        }
    }
}

