/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.coordinates;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentPair;
import org.objectweb.fractal.adl.components.PrimitiveCompiler;
import org.objectweb.fractal.adl.coordinates.Coordinates;
import org.objectweb.fractal.adl.coordinates.CoordinatesBuilder;
import org.objectweb.fractal.adl.coordinates.CoordinatesContainer;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.task.core.Task;
import org.objectweb.fractal.task.core.TaskMap;
import org.objectweb.fractal.task.deployment.api.InstanceProviderTask;
import org.objectweb.fractal.task.deployment.lib.AbstractConfigurationTask;

public class CoordinatesCompiler
implements PrimitiveCompiler,
BindingController {
    public static final String BUILDER_BINDING = "builder";
    private CoordinatesBuilder builder;

    public String[] listFc() {
        return new String[]{BUILDER_BINDING};
    }

    public Object lookupFc(String clientItfName) {
        if (BUILDER_BINDING.equals(clientItfName)) {
            return this.builder;
        }
        return null;
    }

    public void bindFc(String clientItfName, Object serverItf) {
        if (BUILDER_BINDING.equals(clientItfName)) {
            this.builder = (CoordinatesBuilder)serverItf;
        }
    }

    public void unbindFc(String clientItfName) {
        if (BUILDER_BINDING.equals(clientItfName)) {
            this.builder = null;
        }
    }

    public void compile(List path, ComponentContainer container, TaskMap tasks, Map context) throws ADLException {
        if (path.size() > 0 || !(container instanceof CoordinatesContainer)) {
            return;
        }
        this.compile((CoordinatesContainer)((Object)container), container, tasks);
    }

    private void compile(CoordinatesContainer c, ComponentContainer cc, TaskMap tasks) {
        Coordinates[] coords = c.getCoordinatess();
        Component[] comps = cc.getComponents();
        for (int i = 0; i < coords.length; ++i) {
            String name = coords[i].getName();
            for (int j = 0; j < comps.length; ++j) {
                if (!comps[j].getName().equals(name)) continue;
                double x0 = Double.parseDouble(coords[i].getX0());
                double y0 = Double.parseDouble(coords[i].getY0());
                double x1 = Double.parseDouble(coords[i].getX1());
                double y1 = Double.parseDouble(coords[i].getY1());
                int color = Integer.parseInt(coords[i].getColor());
                TaskMap.TaskHole parentCreateTaskHole = tasks.getTaskHole("create", (Object)cc);
                TaskMap.TaskHole createTaskHole = tasks.getTaskHole("create", (Object)comps[j]);
                SetCoordinatesTask coordinatesTask = new SetCoordinatesTask(this.builder, x0, y0, x1, y1, color);
                coordinatesTask.setParentInstanceProviderTask(parentCreateTaskHole);
                coordinatesTask.setInstanceProviderTask(createTaskHole);
                ComponentPair pair = new ComponentPair(cc, comps[j]);
                tasks.addTask("coordinates", (Object)pair, (Task)coordinatesTask);
                coordinatesTask.addDependency(tasks.getTaskHole("add", (Object)pair), Task.PREVIOUS_TASK_ROLE, new HashMap());
                this.compile(coords[i], comps[j], tasks);
            }
        }
    }

    static class SetCoordinatesTask
    extends AbstractConfigurationTask {
        private TaskMap.TaskHole parentInstanceProviderTask;
        private CoordinatesBuilder builder;
        private double x0;
        private double y0;
        private double x1;
        private double y1;
        private int color;

        public SetCoordinatesTask(CoordinatesBuilder builder, double x0, double y0, double x1, double y1, int color) {
            this.builder = builder;
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            this.color = color;
        }

        public InstanceProviderTask getParentInstanceProviderTask() {
            return this.parentInstanceProviderTask == null ? null : (InstanceProviderTask)this.parentInstanceProviderTask.getTask();
        }

        public void setParentInstanceProviderTask(TaskMap.TaskHole task) {
            if (this.parentInstanceProviderTask != null) {
                this.removePreviousTask(this.parentInstanceProviderTask);
            }
            this.parentInstanceProviderTask = task;
            if (this.parentInstanceProviderTask != null) {
                this.addPreviousTask(this.parentInstanceProviderTask);
            }
        }

        public void execute(Map context) throws Exception {
            Object parent = this.getParentInstanceProviderTask().getResult();
            Object component = this.getInstanceProviderTask().getResult();
            this.builder.setCoordinates(parent, component, this.x0, this.y0, this.x1, this.y1, this.color, context);
        }

        public Object getResult() {
            return null;
        }

        public void setResult(Object result) {
        }
    }
}

