/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.error;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.error.Error;
import org.objectweb.fractal.adl.error.ErrorLocator;
import org.objectweb.fractal.adl.error.NodeErrorLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedErrorLocator
implements ErrorLocator {
    private final ErrorLocator rootLocator;
    private final List<ErrorLocator> chainedLocations = new ArrayList<ErrorLocator>();

    public static void chainLocator(Error error, ErrorLocator locator) {
        ChainedErrorLocator chainedLocator;
        if (error == null) {
            throw new IllegalArgumentException("error can't be null");
        }
        if (locator == null) {
            throw new IllegalArgumentException("locator can't be null");
        }
        ErrorLocator l = error.getLocator();
        if (l instanceof ChainedErrorLocator) {
            chainedLocator = (ChainedErrorLocator)l;
        } else {
            chainedLocator = new ChainedErrorLocator(l);
            error.setLocator(chainedLocator);
        }
        chainedLocator.chainedLocations.add(locator);
    }

    public static void chainLocator(ADLException e, Node node) {
        if (e == null) {
            throw new IllegalArgumentException("ADLException can't be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("node can't be null");
        }
        ChainedErrorLocator.chainLocator(e.getError(), new NodeErrorLocator(node));
    }

    protected ChainedErrorLocator(ErrorLocator rootLocator) {
        this.rootLocator = rootLocator;
    }

    public ErrorLocator getRootLocator() {
        return this.rootLocator;
    }

    public List<ErrorLocator> getChainedLocations() {
        return this.chainedLocations;
    }

    @Override
    public String getLocation() {
        String result = "In definition referenced from ";
        String linePrefix = null;
        for (ErrorLocator locator : this.chainedLocations) {
            if (linePrefix == null) {
                linePrefix = "                         from ";
            } else {
                result = result + linePrefix;
            }
            result = result + locator.getLocation() + "\n";
        }
        if (this.rootLocator != null) {
            result = result + this.rootLocator.getLocation();
        }
        return result;
    }

    @Override
    public int getBeginColumn() {
        if (this.rootLocator == null) {
            return this.chainedLocations.get(0).getBeginColumn();
        }
        return this.rootLocator.getBeginColumn();
    }

    @Override
    public int getBeginLine() {
        if (this.rootLocator == null) {
            return this.chainedLocations.get(0).getBeginLine();
        }
        return this.rootLocator.getBeginLine();
    }

    @Override
    public int getEndColumn() {
        if (this.rootLocator == null) {
            return this.chainedLocations.get(0).getEndColumn();
        }
        return this.rootLocator.getEndColumn();
    }

    @Override
    public int getEndLine() {
        if (this.rootLocator == null) {
            return this.chainedLocations.get(0).getEndLine();
        }
        return this.rootLocator.getEndLine();
    }

    @Override
    public String getInputFilePath() {
        if (this.rootLocator == null) {
            return this.chainedLocations.get(0).getInputFilePath();
        }
        return this.rootLocator.getInputFilePath();
    }
}

