/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.types;

import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.error.ChainedErrorLocator;
import org.objectweb.fractal.adl.error.ErrorTemplate;
import org.objectweb.fractal.adl.interfaces.IDLLoader;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.adl.types.TypeErrors;
import org.objectweb.fractal.adl.types.TypeInterface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeLoader
extends AbstractLoader {
    public static final String INTERFACE_LOADER_CLIENT_ITF_NAME = "interface-loader";
    public IDLLoader interfaceCodeLoaderItf;

    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkNode(d, context);
        return d;
    }

    private void checkNode(Object node, Map<Object, Object> context) throws ADLException {
        if (node instanceof InterfaceContainer) {
            this.checkInterfaceContainer((InterfaceContainer)node, context);
        }
        if (node instanceof ComponentContainer) {
            for (Component comp : ((ComponentContainer)node).getComponents()) {
                this.checkNode(comp, context);
            }
        }
    }

    protected void checkInterfaceContainer(InterfaceContainer container, Map<Object, Object> context) throws ADLException {
        for (Interface itf : container.getInterfaces()) {
            if (!(itf instanceof TypeInterface)) continue;
            String signature = ((TypeInterface)itf).getSignature();
            if (signature == null) {
                throw new ADLException((ErrorTemplate)TypeErrors.SIGNATURE_MISSING, (Node)itf, new Object[0]);
            }
            try {
                this.interfaceCodeLoaderItf.loadInterface(signature, context);
            }
            catch (ADLException e) {
                ChainedErrorLocator.chainLocator(e, itf);
                throw e;
            }
            String role = ((TypeInterface)itf).getRole();
            if (role == null) {
                throw new ADLException((ErrorTemplate)TypeErrors.ROLE_MISSING, (Node)itf, new Object[0]);
            }
            if (!role.equals("client") && !role.equals("server")) {
                throw new ADLException((ErrorTemplate)TypeErrors.INVALID_ROLE, (Node)itf, new Object[]{role});
            }
            String contingency = ((TypeInterface)itf).getContingency();
            if (contingency != null && !contingency.equals("mandatory") && !contingency.equals("optional")) {
                throw new ADLException((ErrorTemplate)TypeErrors.INVALID_CONTINGENCY, (Node)itf, new Object[]{contingency});
            }
            String cardinality = ((TypeInterface)itf).getCardinality();
            if (cardinality == null || cardinality.equals("singleton") || cardinality.equals("collection")) continue;
            throw new ADLException((ErrorTemplate)TypeErrors.INVALID_CARDINALITY, (Node)itf, new Object[]{cardinality});
        }
    }

    @Override
    public void bindFc(String s, Object o) throws NoSuchInterfaceException, IllegalBindingException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_CLIENT_ITF_NAME.equals(s)) {
            this.interfaceCodeLoaderItf = (IDLLoader)o;
        } else {
            super.bindFc(s, o);
        }
    }

    @Override
    public String[] listFc() {
        String[] superList = super.listFc();
        String[] list = new String[superList.length + 1];
        list[0] = INTERFACE_LOADER_CLIENT_ITF_NAME;
        System.arraycopy(superList, 0, list, 1, superList.length);
        return list;
    }

    @Override
    public Object lookupFc(String s) throws NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_CLIENT_ITF_NAME.equals(s)) {
            return this.interfaceCodeLoaderItf;
        }
        return super.lookupFc(s);
    }

    @Override
    public void unbindFc(String s) throws IllegalBindingException, NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_CLIENT_ITF_NAME.equals(s)) {
            this.interfaceCodeLoaderItf = null;
        } else {
            super.unbindFc(s);
        }
    }
}

