/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.constanttimer;

import java.util.Map;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.SampleAction;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.scenario.isac.plugin.TimerAction;
import org.ow2.clif.storage.api.ActionEvent;

public class SessionObject
implements SampleAction,
TestAction,
TimerAction,
SessionObjectAction {
    public static final String DURATION_ARG = "duration_arg";
    public static final String PERIOD_ARG = "period_arg";
    public static final int RUNNING_TEST = 0;
    public static final int PASSED_TEST = 1;
    public static final int RESET_SAMPLE = 0;
    public static final int SET_SAMPLE = 1;
    public static final int SLEEP_TIMER = 0;
    public static final int PERIOD_BEGIN = 1;
    public static final int PERIOD_END = 2;
    protected int defaultDuration;
    protected int duration;
    protected long startTime = -1L;
    protected long startPeriod = -1L;

    public SessionObject(Map<String, String> params) {
        String value = params.get(DURATION_ARG);
        if (value != null && value.length() > 0) {
            this.duration = this.defaultDuration = Integer.parseInt(value);
        } else {
            this.defaultDuration = 0;
            this.duration = 0;
        }
    }

    private SessionObject(SessionObject toClone) {
        this.startPeriod = -1L;
        this.defaultDuration = toClone.defaultDuration;
        this.duration = toClone.defaultDuration;
    }

    public ActionEvent doSample(int number, Map<String, String> params, ActionEvent dummy) {
        switch (number) {
            case 0: {
                this.startTime = System.currentTimeMillis();
                break;
            }
            case 1: {
                this.startTime = System.currentTimeMillis();
                this.duration = Integer.parseInt(params.get(DURATION_ARG));
            }
        }
        return null;
    }

    public boolean doTest(int number, Map<String, String> params) throws IsacRuntimeException {
        switch (number) {
            case 0: {
                return this.duration > (int)(System.currentTimeMillis() - this.startTime);
            }
            case 1: {
                return this.duration <= (int)(System.currentTimeMillis() - this.startTime);
            }
        }
        throw new Error("Fatal error in ISAC's ConstantTimer plug-in: unknown test identifier " + number);
    }

    public long doTimer(int number, Map<String, String> params) throws IsacRuntimeException {
        switch (number) {
            case 0: {
                String durationStr = params.get(DURATION_ARG);
                if (durationStr != null && durationStr.length() > 0) {
                    try {
                        return Integer.parseInt(durationStr);
                    }
                    catch (Exception ex) {
                        throw new IsacRuntimeException("Invalid timer duration " + durationStr, ex);
                    }
                }
                return this.duration;
            }
            case 1: {
                this.startPeriod = System.currentTimeMillis();
                return 0L;
            }
            case 2: {
                int sleepTime;
                String periodStr = params.get(PERIOD_ARG);
                if (periodStr != null && periodStr.length() > 0) {
                    try {
                        sleepTime = (int)((long)Integer.parseInt(periodStr) - System.currentTimeMillis() + this.startPeriod);
                    }
                    catch (Exception ex) {
                        throw new IsacRuntimeException("Invalid period " + periodStr, ex);
                    }
                } else {
                    sleepTime = (int)((long)this.duration - System.currentTimeMillis() + this.startPeriod);
                }
                if (this.startPeriod < 0L || sleepTime <= 0) {
                    return 0L;
                }
                return sleepTime;
            }
        }
        throw new Error("Unknown timer identifier in " + this.getClass());
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
        this.duration = this.defaultDuration;
    }
}

