/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.context;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;
import org.ow2.clif.util.ClifClassLoader;

public class SessionObject
implements DataProvider,
ControlAction,
TestAction,
SessionObjectAction {
    static final String PLUGIN_FILES = "files";
    static final String PLUGIN_VARIABLES = "variables";
    static final int TEST_ISDEF = 0;
    static final String TEST_ISDEF_VARIABLE = "variable";
    static final int TEST_ISNOTDEF = 1;
    static final String TEST_ISNOTDEF_VARIABLE = "variable";
    static final int CONTROL_SET = 0;
    static final String CONTROL_SET_VALUE = "value";
    static final String CONTROL_SET_VARIABLE = "variable";
    static final int CONTROL_LOAD = 2;
    static final String CONTROL_LOAD_FILE = "file";
    static final int CONTROL_CLEAR = 3;
    private static final char SET_CHAR = '=';
    private Properties variables;
    private Properties defaultVariables;

    private static void parseVariables(String varstr, Properties result) {
        for (String variable : ParameterParser.getNField((String)varstr)) {
            int splitIndex = variable.indexOf(61);
            String key = variable.substring(0, splitIndex);
            String value = splitIndex > 0 ? variable.substring(splitIndex + 1) : "";
            result.put(key, value);
        }
    }

    public SessionObject(Map<String, String> params) {
        this.variables = new Properties();
        SessionObject.parseVariables(params.get(PLUGIN_VARIABLES), this.variables);
        List fileNames = ParameterParser.getNField((String)params.get(PLUGIN_FILES));
        for (String file : fileNames) {
            if (file.length() <= 0) continue;
            try {
                InputStream input = ClifClassLoader.getClassLoader().getResourceAsStream(file);
                if (input == null) {
                    throw new IsacRuntimeException("Plug-in Context could not find property file " + file);
                }
                this.variables.load(input);
                input.close();
            }
            catch (Exception ex) {
                throw new IsacRuntimeException("Plug-in Context could not load property file " + file, ex);
            }
        }
    }

    private SessionObject(SessionObject toClone) {
        this.defaultVariables = toClone.variables;
        this.variables = (Properties)toClone.variables.clone();
    }

    public boolean doTest(int number, Map<String, String> params) throws IsacRuntimeException {
        switch (number) {
            case 0: {
                return this.variables.containsKey(params.get("variable"));
            }
            case 1: {
                return !this.variables.containsKey(params.get("variable"));
            }
        }
        throw new Error("Fatal error in ISAC's ~Context~ plug-in: unknown test identifier " + number);
    }

    public String doGet(String var) {
        return this.variables.getProperty(var);
    }

    public void doControl(int number, Map<String, String> params) {
        switch (number) {
            case 3: {
                this.variables.clear();
                break;
            }
            case 2: {
                String fileName = params.get(CONTROL_LOAD_FILE);
                try {
                    InputStream input = ClifClassLoader.getClassLoader().getResourceAsStream(fileName);
                    this.variables.load(input);
                    input.close();
                    break;
                }
                catch (Exception ex) {
                    throw new IsacRuntimeException("Context could not load property file " + fileName, ex);
                }
            }
            case 0: {
                this.variables.put(params.get("variable"), params.get(CONTROL_SET_VALUE));
                break;
            }
            default: {
                throw new Error("Fatal error in ISAC's ~Context~ plug-in: unknown control identifier " + number);
            }
        }
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
    }

    public void reset() {
        this.variables = (Properties)this.defaultVariables.clone();
    }
}

