/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.stringhandler;

import java.util.HashMap;
import org.ow2.isac.plugin.stringhandler.SessionObject;

public abstract class Base64Test {
    static final String TEST_STRING = "\u00e2\u00e0\u00e7\u00e9\u00ea\u00e8\u00eb\u00ea\u00ee\u00ef\u00f9";
    static final String ENCODED_STRING = "w6LDoMOnw6nDqsOow6vDqsOuw6/DuQ==";
    static final String URLSAFE_ENCODED_STRING = "w6LDoMOnw6nDqsOow6vDqsOuw6_DuQ==";
    static final String ENCODING = "UTF8";

    public static void main(String[] args) {
        System.out.println("source string: \u00e2\u00e0\u00e7\u00e9\u00ea\u00e8\u00eb\u00ea\u00ee\u00ef\u00f9");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("default", TEST_STRING);
        SessionObject specimen = new SessionObject(params);
        SessionObject so = (SessionObject)specimen.createNewSessionObject();
        params.clear();
        params.put("charset", ENCODING);
        so.doControl(21, params);
        System.out.println("Base64 encoding: " + so.doGet(""));
        assert (so.doGet("").equals(ENCODED_STRING)) : "Base64 encoding result differs from expected";
        params.clear();
        params.put("charset", ENCODING);
        so.doControl(20, params);
        System.out.println("Base64 decoding: " + so.doGet(""));
        assert (so.doGet("").equals(TEST_STRING)) : "Base64 decoding result differs from expected";
        params.clear();
        params.put("charset", ENCODING);
        params.put("options", "URL-safe");
        so.doControl(21, params);
        System.out.println("URL-safe base64 encoding: " + so.doGet(""));
        assert (so.doGet("").equals(URLSAFE_ENCODED_STRING)) : "URL-safe base64 encoding result differs from expected";
        params.clear();
        params.put("charset", ENCODING);
        params.put("urlsafe", "yes");
        so.doControl(20, params);
        System.out.println("URL-safe base64 decoding: " + so.doGet(""));
        assert (so.doGet("").equals(TEST_STRING)) : "URL-safe base64 decoding result differs from expected";
        params.clear();
        params.put("charset", ENCODING);
        params.put("options", "URL-safe;Discard padding");
        so.doControl(21, params);
        System.out.println("URL-safe base64 encoding, no padding: " + so.doGet(""));
        assert (so.doGet("").equals(URLSAFE_ENCODED_STRING.substring(0, URLSAFE_ENCODED_STRING.indexOf(61)))) : "URL-safe base64 encoding without padding result differs from expected";
        params.clear();
        params.put("charset", ENCODING);
        params.put("urlsafe", "yes");
        so.doControl(20, params);
        System.out.println("URL-safe base64 decoding, no padding: " + so.doGet(""));
        assert (so.doGet("").equals(TEST_STRING)) : "URL-safe base64 decoding without padding result differs from expected";
    }
}

