/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.stringhandler;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;
import org.ow2.clif.util.Random;
import org.ow2.clif.util.StringHelper;

public class SessionObject
implements SessionObjectAction,
DataProvider,
TestAction,
ControlAction {
    static final String PLUGIN_DEFAULT = "default";
    static final String CONTROL_RANDOMSET_SIZE = "size";
    static final int CONTROL_SET = 0;
    static final String CONTROL_SET_VALUE = "value";
    static final int CONTROL_REPLACEALL = 1;
    static final String CONTROL_REPLACEALL_REPLACE = "replace";
    static final String CONTROL_REPLACEALL_SEARCH = "search";
    static final int CONTROL_RANDOMSET = 2;
    static final int CONTROL_SETPATTERN = 3;
    static final String CONTROL_SETPATTERN_PATTERN = "pattern";
    static final int CONTROL_RESETMATCHING = 4;
    static final int CONTROL_MATCH = 5;
    static final String CONTROL_MATCH_SKIP = "skip";
    static final int CONTROL_CAPTURE = 7;
    static final String CONTROL_CAPTURE_VARIABLE = "variable";
    static final String CONTROL_CAPTURE_LEVEL = "level";
    static final int CONTROL_CUT = 8;
    static final String CONTROL_CUT_TAIL = "tail";
    static final String CONTROL_CUT_HEAD = "head";
    static final int CONTROL_TRUNCATE = 11;
    static final String CONTROL_TRUNCATE_LENGTH = "length";
    static final int CONTROL_REPLACEALLMATCHES = 12;
    static final String CONTROL_REPLACEALLMATCHES_REPLACE = "replace";
    static final int CONTROL_WRITE = 13;
    static final String CONTROL_WRITE_STRING = "string";
    static final int CONTROL_APPEND = 14;
    static final String CONTROL_APPEND_STRING = "string";
    static final int CONTROL_INSERT = 15;
    static final String CONTROL_INSERT_STRING = "string";
    static final int CONTROL_SLICE = 16;
    static final String CONTROL_SLICE_OPTIONS = "options";
    static final int CONTROL_NEXTSLICE = 17;
    static final int CONTROL_BASE64DECODE = 20;
    static final String CONTROL_BASE64DECODE_URLSAFE = "urlsafe";
    static final String CONTROL_BASE64DECODE_CHARSET = "charset";
    static final int CONTROL_BASE64ENCODE = 21;
    static final String CONTROL_BASE64ENCODE_OPTIONS = "options";
    static final String CONTROL_BASE64ENCODE_CHARSET = "charset";
    static final int TEST_CONTAINS = 0;
    static final String TEST_CONTAINS_SEARCH = "search";
    static final int TEST_MATCHED = 6;
    static final int TEST_CONTAINSNOT = 9;
    static final String TEST_CONTAINSNOT_SEARCH = "search";
    static final int TEST_MATCHEDNOT = 10;
    static final int TEST_HASMORESLICE = 18;
    static final int TEST_HASNOMORESLICE = 19;
    private static final String GET_LENGTH = "#";
    private static final String GET_STRING = "";
    private static final String GET_SLICE = "slice";
    private static final String GET_SLICE_NUMBER = "slice#";
    private static final String GET_NEXT_SLICE = "slice++";
    private static Random random = new Random();
    private String defaultValue;
    private StringBuilder value;
    private Pattern pattern;
    private Matcher matcher;
    private Map<String, String> variables = new HashMap<String, String>();
    private String[] slices;
    private int sliceIndex;
    private boolean matched = false;

    public SessionObject(Map<String, String> params) {
        this.defaultValue = params.get(PLUGIN_DEFAULT);
        if (this.defaultValue == null) {
            this.defaultValue = GET_STRING;
        }
    }

    private SessionObject(SessionObject so) {
        this.value = new StringBuilder(so.defaultValue);
        this.defaultValue = so.defaultValue;
    }

    private void valueChanged() {
        if (this.pattern != null) {
            this.matcher.reset(this.value);
            this.slices = null;
        }
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
    }

    public void reset() {
        this.value = new StringBuilder(this.defaultValue);
        this.pattern = null;
        this.matcher = null;
        this.variables = new HashMap<String, String>();
        this.matched = false;
    }

    public String doGet(String arg) {
        String result = null;
        if (arg.equals(GET_STRING)) {
            result = this.value.toString();
        } else if (arg.equals(GET_LENGTH)) {
            result = Integer.toString(this.value.length());
        } else if (arg.equals(GET_SLICE_NUMBER)) {
            if (this.slices != null) {
                result = String.valueOf(this.slices.length);
            }
        } else if (arg.startsWith(GET_SLICE_NUMBER)) {
            int index;
            if (this.slices != null && (index = Integer.valueOf(arg.substring(GET_SLICE_NUMBER.length())).intValue()) >= 0 && index < this.slices.length) {
                result = this.slices[index];
            }
        } else if (arg.equals(GET_SLICE)) {
            if (this.slices != null && this.slices.length > 0 && this.sliceIndex >= 0 && this.sliceIndex < this.slices.length) {
                result = this.slices[this.sliceIndex];
            }
        } else if (arg.equals(GET_NEXT_SLICE)) {
            this.doControl(17, null);
            if (this.slices != null && this.slices.length > 0 && this.sliceIndex >= 0 && this.sliceIndex < this.slices.length) {
                result = this.slices[this.sliceIndex];
            }
        } else {
            result = this.variables.get(arg);
        }
        if (result == null) {
            throw new IsacRuntimeException("Variable not available in ~StringHandler~ ISAC plugin: " + arg);
        }
        return result;
    }

    public boolean doTest(int number, Map<String, String> params) {
        switch (number) {
            case 19: {
                return !this.doTest(18, params);
            }
            case 18: {
                if (this.slices == null) {
                    throw new IsacRuntimeException("StringHandler's slice control must be called prior to testing slice availability.");
                }
                return this.sliceIndex + 1 < this.slices.length;
            }
            case 10: {
                return !this.matched;
            }
            case 9: {
                return this.value.indexOf(params.get("search")) == -1;
            }
            case 6: {
                return this.matched;
            }
            case 0: {
                return this.value.indexOf(params.get("search")) != -1;
            }
        }
        throw new Error("Unable to find this test in ~StringHandler~ ISAC plugin: " + number);
    }

    public void doControl(int number, Map<String, String> params) {
        switch (number) {
            case 21: {
                try {
                    String charset = params.get("charset");
                    List options = ParameterParser.getCheckBox((String)params.get("options"));
                    boolean urlSafe = options.contains("URL-safe");
                    boolean discardPadding = options.contains("Discard padding");
                    Base64.Encoder encoder = urlSafe ? Base64.getUrlEncoder() : Base64.getEncoder();
                    StringBuilder b64 = new StringBuilder(new String(encoder.encode(this.value.toString().getBytes(charset)), charset));
                    if (discardPadding) {
                        b64.setLength(b64.indexOf("="));
                    }
                    this.setValue(b64);
                    break;
                }
                catch (UnsupportedEncodingException ex) {
                    throw new IsacRuntimeException("Plugin ~StringHandler~ could not perform base64 encoding: unsupported charset " + params.get("charset"), (Exception)ex);
                }
            }
            case 20: {
                try {
                    String charset = params.get("charset");
                    String urlSafeStr = params.get(CONTROL_BASE64DECODE_URLSAFE);
                    Base64.Decoder decoder = urlSafeStr != null && StringHelper.isEnabled((String)urlSafeStr) ? Base64.getUrlDecoder() : Base64.getDecoder();
                    this.setValue(new StringBuilder(new String(decoder.decode(this.value.toString().getBytes(charset)), charset)));
                    break;
                }
                catch (IllegalArgumentException ex) {
                    throw new IsacRuntimeException("Plugin ~StringHandler~ could not decode base64 input", (Exception)ex);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new IsacRuntimeException("Plugin ~StringHandler~ could not perform base64 decoding: unsupported charset " + params.get("charset"), (Exception)ex);
                }
            }
            case 17: {
                if (this.slices != null && this.slices.length > 0 && this.sliceIndex < this.slices.length) {
                    ++this.sliceIndex;
                    break;
                }
                throw new IsacRuntimeException("StringHandler has no next slice.");
            }
            case 16: {
                if (this.pattern != null) {
                    List options = ParameterParser.getCheckBox((String)params.get("options"));
                    if (options.contains("Discard empty strings")) {
                        this.slices = this.pattern.split(this.value, 0);
                        ArrayList<String> realSlicesList = new ArrayList<String>(this.slices.length);
                        for (String str : this.slices) {
                            if (str.isEmpty()) continue;
                            realSlicesList.add(str);
                        }
                        this.slices = realSlicesList.toArray(new String[realSlicesList.size()]);
                    } else {
                        this.slices = this.pattern.split(this.value, -1);
                    }
                    this.sliceIndex = -1;
                    break;
                }
                throw new IsacRuntimeException("StringHandler can't slice when no pattern is set.");
            }
            case 15: {
                this.value.insert(0, params.get("string"));
                this.valueChanged();
                break;
            }
            case 14: {
                this.value.append(params.get("string"));
                this.valueChanged();
                break;
            }
            case 13: {
                String overwrite = params.get("string");
                this.value.replace(0, overwrite.length(), overwrite);
                this.valueChanged();
                break;
            }
            case 12: {
                if (this.pattern != null) {
                    this.value = new StringBuilder(this.matcher.replaceAll(params.get("replace")));
                    this.valueChanged();
                    break;
                }
                throw new IsacRuntimeException("StringHandler can't replace matches when no pattern is set.");
            }
            case 11: {
                int length = Integer.parseInt(params.get(CONTROL_TRUNCATE_LENGTH));
                if (length < this.value.length()) {
                    this.value.delete(length, this.value.length());
                }
                this.valueChanged();
                break;
            }
            case 8: {
                int head = Integer.parseInt(params.get(CONTROL_CUT_HEAD));
                int tail = Integer.parseInt(params.get(CONTROL_CUT_TAIL));
                if (head > 0) {
                    this.value.delete(0, head);
                }
                if (tail > 0) {
                    this.value.delete(this.value.length() - tail, this.value.length());
                }
                this.valueChanged();
                break;
            }
            case 7: {
                if (this.matched) {
                    this.variables.put(params.get(CONTROL_CAPTURE_VARIABLE), this.matcher.group(Integer.parseInt(params.get(CONTROL_CAPTURE_LEVEL))));
                    break;
                }
                this.variables.remove(params.get(CONTROL_CAPTURE_VARIABLE));
                throw new IsacRuntimeException("StringHandler plug-in can't capture an unmatched pattern.");
            }
            case 5: {
                int i;
                this.matched = false;
                for (i = Integer.parseInt(params.get(CONTROL_MATCH_SKIP)); i > 0 && this.matcher.find(); --i) {
                }
                if (i != 0) break;
                this.matched = this.matcher.find();
                break;
            }
            case 4: {
                this.matcher.reset();
                this.matched = false;
                break;
            }
            case 3: {
                this.pattern = Pattern.compile(params.get(CONTROL_SETPATTERN_PATTERN));
                this.matcher = this.pattern.matcher(this.value);
                this.matched = false;
                break;
            }
            case 2: {
                this.setValue(random.nextStringBuilder(Integer.parseInt(params.get(CONTROL_RANDOMSET_SIZE))));
                break;
            }
            case 1: {
                String search = params.get("search");
                String replace = params.get("replace");
                for (int pos = 0; pos < this.value.length() && (pos = this.value.indexOf(search, pos)) != -1; pos += replace.length()) {
                    this.value.replace(pos, pos + search.length(), replace);
                }
                this.valueChanged();
                break;
            }
            case 0: {
                this.setValue(new StringBuilder(params.get(CONTROL_SET_VALUE)));
                break;
            }
            default: {
                throw new Error("Unable to find this control in ~StringHandler~ ISAC plugin: " + number);
            }
        }
    }

    private void setValue(StringBuilder newValue) {
        this.value = newValue;
        this.valueChanged();
    }
}

