/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.handler;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerConstants;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.SignatureConfirmation;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.StringUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSHandler {
    private static Log log = LogFactory.getLog(WSHandler.class);
    protected WSSecurityEngine secEngine = new WSSecurityEngine();
    protected Map<String, Crypto> cryptos = new HashMap<String, Crypto>();
    private boolean doDebug = log.isDebugEnabled();

    protected void doSenderAction(int doAction, Document doc, RequestData reqData, List<Integer> actions, boolean isRequest) throws WSSecurityException {
        String done;
        boolean enableSigConf;
        boolean mu = this.decodeMustUnderstand(reqData);
        WSSConfig wssConfig = reqData.getWssConfig();
        if (wssConfig == null) {
            wssConfig = this.secEngine.getWssConfig();
        }
        wssConfig.setEnableSignatureConfirmation((enableSigConf = this.decodeEnableSignatureConfirmation(reqData)) || (doAction & 0x80) != 0);
        wssConfig.setPasswordsAreEncoded(this.decodeUseEncodedPasswords(reqData));
        wssConfig.setPrecisionInMilliSeconds(this.decodeTimestampPrecision(reqData));
        reqData.setWssConfig(wssConfig);
        Object mc = reqData.getMsgContext();
        String actor = this.getString("actor", mc);
        reqData.setActor(actor);
        WSSecHeader secHeader = new WSSecHeader(actor, mu);
        secHeader.insertSecurityHeader(doc);
        reqData.setSecHeader(secHeader);
        reqData.setSoapConstants(WSSecurityUtil.getSOAPConstants(doc.getDocumentElement()));
        wssConfig.setWsiBSPCompliant(this.decodeBSPCompliance(reqData));
        if ((doAction & 1) == 1) {
            this.decodeUTParameter(reqData);
        }
        if ((doAction & 0x40) == 64) {
            this.decodeUTParameter(reqData);
            this.decodeSignatureParameter(reqData);
        }
        if ((doAction & 2) == 2) {
            if (reqData.getSigCrypto() == null) {
                reqData.setSigCrypto(this.loadSignatureCrypto(reqData));
            }
            this.decodeSignatureParameter(reqData);
        }
        if ((doAction & 0x10) == 16) {
            this.decodeSignatureParameter(reqData);
        }
        if ((doAction & 4) == 4) {
            if (reqData.getEncCrypto() == null) {
                reqData.setEncCrypto(this.loadEncryptionCrypto(reqData));
            }
            this.decodeEncryptionParameter(reqData);
        }
        if (reqData.getSignatureParts().isEmpty()) {
            WSEncryptionPart encP = new WSEncryptionPart(reqData.getSoapConstants().getBodyQName().getLocalPart(), reqData.getSoapConstants().getEnvelopeURI(), "Content");
            reqData.getSignatureParts().add(encP);
        }
        if (wssConfig.isEnableSignatureConfirmation() && !isRequest && (done = (String)this.getProperty(reqData.getMsgContext(), "_sigConfDone_")) == null) {
            wssConfig.getAction(128).execute(this, 128, doc, reqData);
        }
        block5: for (Integer actionToDo : actions) {
            if (this.doDebug) {
                log.debug((Object)("Performing Action: " + actionToDo));
            }
            switch (actionToDo) {
                case 1: 
                case 2: 
                case 4: 
                case 8: 
                case 16: 
                case 32: 
                case 64: {
                    wssConfig.getAction(actionToDo).execute(this, actionToDo, doc, reqData);
                    continue block5;
                }
            }
            Action doit = null;
            try {
                doit = wssConfig.getAction(actionToDo);
            }
            catch (WSSecurityException e) {
                log.warn((Object)("Error trying to locate a custom action (" + actionToDo + ")"), (Throwable)e);
            }
            if (doit == null) continue;
            doit.execute(this, actionToDo, doc, reqData);
        }
        if (wssConfig.isEnableSignatureConfirmation() && isRequest && reqData.getSignatureValues().size() > 0) {
            ArrayList<byte[]> savedSignatures = (ArrayList<byte[]>)this.getProperty(reqData.getMsgContext(), "_sendSignatureValues_");
            if (savedSignatures == null) {
                savedSignatures = new ArrayList<byte[]>();
                this.setProperty(reqData.getMsgContext(), "_sendSignatureValues_", savedSignatures);
            }
            savedSignatures.addAll(reqData.getSignatureValues());
        }
    }

    protected void doReceiverAction(int doAction, RequestData reqData) throws WSSecurityException {
        boolean enableSigConf;
        WSSConfig wssConfig = reqData.getWssConfig();
        if (wssConfig == null) {
            wssConfig = this.secEngine.getWssConfig();
        }
        wssConfig.setEnableSignatureConfirmation((enableSigConf = this.decodeEnableSignatureConfirmation(reqData)) || (doAction & 0x80) != 0);
        wssConfig.setTimeStampStrict(this.decodeTimestampStrict(reqData));
        if (this.decodePasswordTypeStrict(reqData)) {
            String passwordType = this.decodePasswordType(reqData);
            wssConfig.setRequiredPasswordType(passwordType);
        }
        wssConfig.setTimeStampTTL(this.decodeTimeToLive(reqData));
        wssConfig.setTimeStampFutureTTL(this.decodeFutureTimeToLive(reqData));
        wssConfig.setHandleCustomPasswordTypes(this.decodeCustomPasswordTypes(reqData));
        wssConfig.setPasswordsAreEncoded(this.decodeUseEncodedPasswords(reqData));
        wssConfig.setAllowNamespaceQualifiedPasswordTypes(this.decodeNamespaceQualifiedPasswordTypes(reqData));
        wssConfig.setSecretKeyLength(reqData.getSecretKeyLength());
        wssConfig.setWsiBSPCompliant(this.decodeBSPCompliance(reqData));
        reqData.setWssConfig(wssConfig);
        if ((doAction & 2) == 2) {
            this.decodeSignatureParameter2(reqData);
        }
        if ((doAction & 0x10) == 16 || (doAction & 8) == 8) {
            this.decodeSignatureParameter2(reqData);
        }
        if ((doAction & 4) == 4) {
            this.decodeDecryptionParameter(reqData);
        }
        this.decodeRequireSignedEncryptedDataElements(reqData);
    }

    protected boolean checkReceiverResults(List<WSSecurityEngineResult> wsResult, List<Integer> actions) {
        int size = actions.size();
        int ai = 0;
        for (WSSecurityEngineResult result : wsResult) {
            Integer actInt = (Integer)result.get("action");
            int act = actInt;
            if (act == 128 || act == 4096 || ai < size && actions.get(ai++) == act) continue;
            return false;
        }
        return ai == size;
    }

    protected boolean checkReceiverResultsAnyOrder(List<WSSecurityEngineResult> wsResult, List<Integer> actions) {
        ArrayList<Integer> recordedActions = new ArrayList<Integer>(actions.size());
        for (Integer action : actions) {
            recordedActions.add(action);
        }
        for (WSSecurityEngineResult result : wsResult) {
            Integer actInt = (Integer)result.get("action");
            int act = actInt;
            if (act == 128 || act == 4096 || recordedActions.remove(actInt)) continue;
            return false;
        }
        return recordedActions.isEmpty();
    }

    protected void checkSignatureConfirmation(RequestData reqData, List<WSSecurityEngineResult> resultList) throws WSSecurityException {
        if (this.doDebug) {
            log.debug((Object)"Check Signature confirmation");
        }
        List savedSignatures = (List)this.getProperty(reqData.getMsgContext(), "_sendSignatureValues_");
        ArrayList<WSSecurityEngineResult> sigConf = new ArrayList<WSSecurityEngineResult>();
        WSSecurityUtil.fetchAllActionResults(resultList, 128, sigConf);
        for (WSSecurityEngineResult result : sigConf) {
            SignatureConfirmation sc = (SignatureConfirmation)result.get("signature-confirmation");
            byte[] sigVal = sc.getSignatureValue();
            if (sigVal == null) continue;
            if (savedSignatures == null || savedSignatures.size() == 0) {
                if (sigVal.length == 0) continue;
                throw new WSSecurityException("Received a SignatureConfirmation element, but there are no stored signature values");
            }
            boolean found = false;
            for (int j = 0; j < savedSignatures.size(); ++j) {
                byte[] storedValue = (byte[])savedSignatures.get(j);
                if (!Arrays.equals(sigVal, storedValue)) continue;
                found = true;
                savedSignatures.remove(j);
                break;
            }
            if (found) continue;
            throw new WSSecurityException("Received a SignatureConfirmation element, but there are no matching stored signature values");
        }
        if (!reqData.isNoSerialization()) {
            if (this.doDebug) {
                log.debug((Object)"Check Signature confirmation - last handler");
            }
            if (savedSignatures != null && !savedSignatures.isEmpty()) {
                throw new WSSecurityException("Check Signature confirmation: the stored signature values list is not empty");
            }
        }
    }

    protected void decodeUTParameter(RequestData reqData) throws WSSecurityException {
        String iterations;
        String derivedMAC;
        boolean useDerivedKeyForMAC;
        String derived;
        String add;
        Object mc = reqData.getMsgContext();
        String type = this.getString("passwordType", mc);
        if (type != null) {
            if ("PasswordText".equals(type)) {
                reqData.setPwType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            } else if ("PasswordDigest".equals(type)) {
                reqData.setPwType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
            } else if ("PasswordNone".equals(type)) {
                reqData.setPwType(null);
            } else {
                throw new WSSecurityException("Unknown password type encoding: " + type);
            }
        }
        if ((add = this.getString("addUTElements", mc)) != null) {
            reqData.setUtElements(StringUtil.split(add, ' '));
        }
        if ((derived = this.getString("useDerivedKey", mc)) != null) {
            boolean useDerivedKey = Boolean.parseBoolean(derived);
            reqData.setUseDerivedKey(useDerivedKey);
        }
        if (useDerivedKeyForMAC = Boolean.parseBoolean(derivedMAC = this.getString("useDerivedKeyForMAC", mc))) {
            reqData.setUseDerivedKeyForMAC(useDerivedKeyForMAC);
        }
        if ((iterations = this.getString("derivedKeyIterations", mc)) != null) {
            int iIterations = Integer.parseInt(iterations);
            reqData.setDerivedKeyIterations(iIterations);
        }
    }

    protected void decodeSignatureParameter(RequestData reqData) throws WSSecurityException {
        String secretKeyLength;
        Object mc = reqData.getMsgContext();
        String signatureUser = this.getString("signatureUser", mc);
        if (signatureUser != null) {
            reqData.setSignatureUser(signatureUser);
        } else {
            reqData.setSignatureUser(reqData.getUsername());
        }
        String keyId = this.getString("signatureKeyIdentifier", mc);
        if (keyId != null) {
            Integer id = WSHandlerConstants.getKeyIdentifier(keyId);
            if (id == null) {
                throw new WSSecurityException("WSHandler: Signature: unknown key identification");
            }
            int tmp = id;
            if (tmp != 2 && tmp != 1 && tmp != 3 && tmp != 4 && tmp != 8 && tmp != 10) {
                throw new WSSecurityException("WSHandler: Signature: illegal key identification");
            }
            reqData.setSigKeyId(tmp);
        }
        String algo = this.getString("signatureAlgorithm", mc);
        reqData.setSigAlgorithm(algo);
        String digestAlgo = this.getString("signatureDigestAlgorithm", mc);
        reqData.setSigDigestAlgorithm(digestAlgo);
        String parts = this.getString("signatureParts", mc);
        if (parts != null) {
            this.splitEncParts(parts, reqData.getSignatureParts(), reqData);
        }
        if ((secretKeyLength = this.getString("wseSecretKeyLength", mc)) != null) {
            int iSecretKeyLength = Integer.parseInt(secretKeyLength);
            reqData.setSecretKeyLength(iSecretKeyLength);
        }
        boolean useSingleCert = this.decodeUseSingleCertificate(reqData);
        reqData.setUseSingleCert(useSingleCert);
    }

    protected void decodeEncryptionParameter(RequestData reqData) throws WSSecurityException {
        String encParts;
        Object mc = reqData.getMsgContext();
        String encUser = this.getString("encryptionUser", mc);
        if (encUser != null) {
            reqData.setEncUser(encUser);
        } else {
            reqData.setEncUser(reqData.getUsername());
        }
        if (reqData.getEncUser() == null) {
            throw new WSSecurityException("WSHandler: Encryption: no username");
        }
        this.handleSpecialUser(reqData);
        String encKeyId = this.getString("encryptionKeyIdentifier", mc);
        if (encKeyId != null) {
            Integer id = WSHandlerConstants.getKeyIdentifier(encKeyId);
            if (id == null) {
                throw new WSSecurityException("WSHandler: Encryption: unknown key identification");
            }
            int tmp = id;
            reqData.setEncKeyId(tmp);
            if (tmp != 2 && tmp != 3 && tmp != 4 && tmp != 1 && tmp != 5 && tmp != 8 && tmp != 10) {
                throw new WSSecurityException("WSHandler: Encryption: illegal key identification");
            }
        }
        String encSymAlgo = this.getString("encryptionSymAlgorithm", mc);
        reqData.setEncSymmAlgo(encSymAlgo);
        String encKeyTransport = this.getString("encryptionKeyTransportAlgorithm", mc);
        reqData.setEncKeyTransport(encKeyTransport);
        String encSymEncKey = this.getString("encryptSymmetricEncryptionKey", mc);
        if (encSymEncKey != null) {
            boolean encSymEndKeyBoolean = Boolean.parseBoolean(encSymEncKey);
            reqData.setEncryptSymmetricEncryptionKey(encSymEndKeyBoolean);
        }
        if ((encParts = this.getString("encryptionParts", mc)) != null) {
            this.splitEncParts(encParts, reqData.getEncryptParts(), reqData);
        }
    }

    public int decodeTimeToLive(RequestData reqData) {
        String ttl = this.getString("timeToLive", reqData.getMsgContext());
        int ttlI = 0;
        if (ttl != null) {
            try {
                ttlI = Integer.parseInt(ttl);
            }
            catch (NumberFormatException e) {
                ttlI = reqData.getTimeToLive();
            }
        }
        if (ttlI <= 0) {
            ttlI = reqData.getTimeToLive();
        }
        return ttlI;
    }

    protected int decodeFutureTimeToLive(RequestData reqData) {
        String ttl = this.getString("futureTimeToLive", reqData.getMsgContext());
        int defaultFutureTimeToLive = 60;
        if (ttl != null) {
            try {
                int ttlI = Integer.parseInt(ttl);
                if (ttlI < 0) {
                    return defaultFutureTimeToLive;
                }
                return ttlI;
            }
            catch (NumberFormatException e) {
                return defaultFutureTimeToLive;
            }
        }
        return defaultFutureTimeToLive;
    }

    protected boolean decodeBSPCompliance(RequestData reqData) throws WSSecurityException {
        return this.decodeBooleanConfigValue(reqData, "isBSPCompliant", true);
    }

    protected String decodePasswordType(RequestData reqData) throws WSSecurityException {
        String type = this.getString("passwordType", reqData.getMsgContext());
        if (type != null) {
            if ("PasswordText".equals(type)) {
                return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
            }
            if ("PasswordDigest".equals(type)) {
                return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
            }
        }
        return null;
    }

    protected boolean decodeMustUnderstand(RequestData reqData) throws WSSecurityException {
        return this.decodeBooleanConfigValue(reqData, "mustUnderstand", true);
    }

    protected boolean decodeEnableSignatureConfirmation(RequestData reqData) throws WSSecurityException {
        return this.decodeBooleanConfigValue(reqData, "enableSignatureConfirmation", false);
    }

    protected boolean decodeTimestampPrecision(RequestData reqData) throws WSSecurityException {
        return this.decodeBooleanConfigValue(reqData, "precisionInMilliseconds", true);
    }

    protected boolean decodeCustomPasswordTypes(RequestData reqData) throws WSSecurityException {
        return this.decodeBooleanConfigValue(reqData, "handleCustomPasswordTypes", false);
    }

    protected boolean decodeUseEncodedPasswords(RequestData reqData) throws WSSecurityException {
        return this.decodeBooleanConfigValue(reqData, "useEncodedPasswords", false);
    }

    protected boolean decodeNamespaceQualifiedPasswordTypes(RequestData reqData) throws WSSecurityException {
        return this.decodeBooleanConfigValue(reqData, "allowNamespaceQualifiedPasswordTypes", false);
    }

    protected boolean decodeTimestampStrict(RequestData reqData) throws WSSecurityException {
        return this.decodeBooleanConfigValue(reqData, "timestampStrict", true);
    }

    protected boolean decodePasswordTypeStrict(RequestData reqData) throws WSSecurityException {
        return this.decodeBooleanConfigValue(reqData, "passwordTypeStrict", false);
    }

    protected boolean decodeUseSingleCertificate(RequestData reqData) throws WSSecurityException {
        return this.decodeBooleanConfigValue(reqData, "useSingleCertificate", true);
    }

    protected void decodeRequireSignedEncryptedDataElements(RequestData reqData) throws WSSecurityException {
        reqData.setRequireSignedEncryptedDataElements(this.decodeBooleanConfigValue(reqData, "requireSignedEncryptedDataElements", false));
    }

    protected boolean decodeBooleanConfigValue(RequestData reqData, String configTag, boolean defaultToTrue) throws WSSecurityException {
        String value = this.getString(configTag, reqData.getMsgContext());
        if (value == null) {
            return defaultToTrue;
        }
        if ("0".equals(value) || "false".equals(value)) {
            return false;
        }
        if ("1".equals(value) || "true".equals(value)) {
            return true;
        }
        throw new WSSecurityException("WSHandler: illegal " + configTag + " parameter");
    }

    public Crypto loadSignatureCrypto(RequestData requestData) throws WSSecurityException {
        return this.loadCrypto("signaturePropFile", "signaturePropRefId", requestData);
    }

    protected Crypto loadDecryptionCrypto(RequestData requestData) throws WSSecurityException {
        return this.loadCrypto("decryptionPropFile", "decryptionPropRefId", requestData);
    }

    protected Crypto loadEncryptionCrypto(RequestData requestData) throws WSSecurityException {
        return this.loadCrypto("encryptionPropFile", "encryptionPropRefId", requestData);
    }

    protected Crypto loadCrypto(String cryptoPropertyFile, String cryptoPropertyRefId, RequestData requestData) throws WSSecurityException {
        String propFile;
        Object mc = requestData.getMsgContext();
        Crypto crypto = null;
        String refId = this.getString(cryptoPropertyRefId, mc);
        if (refId != null && (crypto = this.cryptos.get(refId)) == null) {
            Object obj = this.getProperty(mc, refId);
            if (obj instanceof Properties) {
                crypto = CryptoFactory.getInstance((Properties)obj);
                this.cryptos.put(refId, crypto);
            } else if (obj instanceof Crypto) {
                crypto = (Crypto)obj;
                this.cryptos.put(refId, crypto);
            }
        }
        if (crypto == null && (propFile = this.getString(cryptoPropertyFile, mc)) != null && (crypto = this.cryptos.get(propFile)) == null) {
            crypto = this.loadCryptoFromPropertiesFile(propFile, requestData);
            this.cryptos.put(propFile, crypto);
        }
        return crypto;
    }

    protected Crypto loadCryptoFromPropertiesFile(String propFilename, RequestData reqData) throws WSSecurityException {
        return CryptoFactory.getInstance(propFilename, this.getClassLoader(reqData.getMsgContext()));
    }

    public CallbackHandler getCallbackHandler(String callbackHandlerClass, String callbackHandlerRef, RequestData requestData) throws WSSecurityException {
        String callback;
        Object mc = requestData.getMsgContext();
        CallbackHandler cbHandler = (CallbackHandler)this.getOption(callbackHandlerRef);
        if (cbHandler == null) {
            cbHandler = (CallbackHandler)this.getProperty(mc, callbackHandlerRef);
        }
        if (cbHandler == null && (callback = this.getString(callbackHandlerClass, mc)) != null) {
            cbHandler = this.loadCallbackHandler(callback, requestData);
        }
        return cbHandler;
    }

    public CallbackHandler getPasswordCallbackHandler(RequestData reqData) throws WSSecurityException {
        return this.getCallbackHandler("passwordCallbackClass", "passwordCallbackRef", reqData);
    }

    private CallbackHandler loadCallbackHandler(String callbackHandlerClass, RequestData requestData) throws WSSecurityException {
        Class<CallbackHandler> cbClass = null;
        CallbackHandler cbHandler = null;
        try {
            cbClass = Loader.loadClass(this.getClassLoader(requestData.getMsgContext()), callbackHandlerClass, CallbackHandler.class);
        }
        catch (ClassNotFoundException e) {
            throw new WSSecurityException("WSHandler: cannot load callback handler class: " + callbackHandlerClass, e);
        }
        try {
            cbHandler = cbClass.newInstance();
        }
        catch (Exception e) {
            throw new WSSecurityException("WSHandler: cannot create instance of callback handler: " + callbackHandlerClass, e);
        }
        return cbHandler;
    }

    public WSPasswordCallback getPasswordCB(String username, int doAction, CallbackHandler callbackHandler, RequestData requestData) throws WSSecurityException {
        if (callbackHandler != null) {
            return this.performPasswordCallback(callbackHandler, username, doAction);
        }
        String password = this.getPassword(requestData.getMsgContext());
        if (password == null) {
            String err = "provided null or empty password";
            throw new WSSecurityException("WSHandler: application " + err);
        }
        WSPasswordCallback pwCb = this.constructPasswordCallback(username, doAction);
        pwCb.setPassword(password);
        return pwCb;
    }

    private WSPasswordCallback performPasswordCallback(CallbackHandler cbHandler, String username, int doAction) throws WSSecurityException {
        WSPasswordCallback pwCb = this.constructPasswordCallback(username, doAction);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cbHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new WSSecurityException("WSHandler: password callback failed", e);
        }
        return pwCb;
    }

    private WSPasswordCallback constructPasswordCallback(String username, int doAction) throws WSSecurityException {
        int reason = 0;
        switch (doAction) {
            case 1: 
            case 64: {
                reason = 2;
                break;
            }
            case 2: {
                reason = 3;
                break;
            }
            case 4: {
                reason = 9;
            }
        }
        return new WSPasswordCallback(username, reason);
    }

    private void splitEncParts(String tmpS, List<WSEncryptionPart> parts, RequestData reqData) throws WSSecurityException {
        WSEncryptionPart encPart = null;
        String[] rawParts = StringUtil.split(tmpS, ';');
        for (int i = 0; i < rawParts.length; ++i) {
            String[] partDef = StringUtil.split(rawParts[i], '}');
            if (partDef.length == 1) {
                if (this.doDebug) {
                    log.debug((Object)("single partDef: '" + partDef[0] + "'"));
                }
                encPart = new WSEncryptionPart(partDef[0].trim(), reqData.getSoapConstants().getEnvelopeURI(), "Content");
            } else if (partDef.length == 3) {
                String mode = partDef[0].trim();
                mode = mode.length() <= 1 ? "Content" : mode.substring(1);
                String nmSpace = partDef[1].trim();
                if (nmSpace.length() <= 1) {
                    nmSpace = reqData.getSoapConstants().getEnvelopeURI();
                } else if ((nmSpace = nmSpace.substring(1)).equals("Null")) {
                    nmSpace = null;
                }
                String element = partDef[2].trim();
                if (this.doDebug) {
                    log.debug((Object)("partDefs: '" + mode + "' ,'" + nmSpace + "' ,'" + element + "'"));
                }
                encPart = new WSEncryptionPart(element, nmSpace, mode);
            } else {
                throw new WSSecurityException("WSHandler: wrong part definition: " + tmpS);
            }
            parts.add(encPart);
        }
    }

    private void handleSpecialUser(RequestData reqData) {
        if (!"useReqSigCert".equals(reqData.getEncUser())) {
            return;
        }
        List results = (List)this.getProperty(reqData.getMsgContext(), "RECV_RESULTS");
        if (results == null) {
            return;
        }
        for (WSHandlerResult rResult : results) {
            String hActor = rResult.getActor();
            if (!WSSecurityUtil.isActorEqual(reqData.getActor(), hActor)) continue;
            List<WSSecurityEngineResult> wsSecEngineResults = rResult.getResults();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                int wserAction = (Integer)wser.get("action");
                if (wserAction != 2) continue;
                X509Certificate cert = (X509Certificate)wser.get("x509-certificate");
                reqData.setEncCert(cert);
                return;
            }
        }
    }

    protected void decodeSignatureParameter2(RequestData reqData) throws WSSecurityException {
        if (reqData.getSigCrypto() == null) {
            reqData.setSigCrypto(this.loadSignatureCrypto(reqData));
        }
        boolean enableRevocation = this.decodeBooleanConfigValue(reqData, "enableRevocation", false);
        reqData.setEnableRevocation(enableRevocation);
    }

    protected void decodeDecryptionParameter(RequestData reqData) throws WSSecurityException {
        if (reqData.getDecCrypto() == null) {
            reqData.setDecCrypto(this.loadDecryptionCrypto(reqData));
        }
    }

    public String getString(String key, Object mc) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        String s = this.getStringOption(key);
        if (s != null) {
            return s;
        }
        if (mc == null) {
            throw new IllegalArgumentException("Message context cannot be null");
        }
        return (String)this.getProperty(mc, key);
    }

    public String getStringOption(String key) {
        Object o = this.getOption(key);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public ClassLoader getClassLoader(Object msgCtx) {
        try {
            return Loader.getTCL();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public abstract Object getOption(String var1);

    public abstract Object getProperty(Object var1, String var2);

    public abstract void setProperty(Object var1, String var2, Object var3);

    public abstract String getPassword(Object var1);

    public abstract void setPassword(Object var1, String var2);
}

