/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.message.WSSecDerivedKeyBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecDKSign
extends WSSecDerivedKeyBase {
    private static Log log = LogFactory.getLog(WSSecDKSign.class);
    private String sigAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    private String digestAlgo = "http://www.w3.org/2000/09/xmldsig#sha1";
    private String canonAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private byte[] signatureValue = null;
    private String keyInfoUri = null;
    private SecurityTokenReference secRef = null;
    private String strUri = null;
    private WSDocInfo wsDocInfo;
    private KeyInfoFactory keyInfoFactory;
    private XMLSignatureFactory signatureFactory;
    private XMLSignature sig;
    private KeyInfo keyInfo;
    private CanonicalizationMethod c14nMethod;
    private Element securityHeader = null;

    public WSSecDKSign() {
        this.init();
    }

    public WSSecDKSign(WSSConfig config) {
        super(config);
        this.init();
    }

    private void init() {
        try {
            this.signatureFactory = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig");
        }
        catch (NoSuchProviderException ex) {
            this.signatureFactory = XMLSignatureFactory.getInstance("DOM");
        }
        try {
            this.keyInfoFactory = KeyInfoFactory.getInstance("DOM", "ApacheXMLDSig");
        }
        catch (NoSuchProviderException ex) {
            this.keyInfoFactory = KeyInfoFactory.getInstance("DOM");
        }
    }

    public Document build(Document doc, WSSecHeader secHeader) throws WSSecurityException, ConversationException {
        this.prepare(doc, secHeader);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace(doc.getDocumentElement());
        if (this.parts == null) {
            this.parts = new ArrayList(1);
            WSEncryptionPart encP = new WSEncryptionPart("Body", soapNamespace, "Content");
            this.parts.add(encP);
        } else {
            for (WSEncryptionPart part : this.parts) {
                if (!"STRTransform".equals(part.getName()) || part.getId() != null) continue;
                part.setId(this.strUri);
            }
        }
        List<javax.xml.crypto.dsig.Reference> referenceList = this.addReferencesToSign(this.parts, secHeader);
        this.computeSignature(referenceList);
        this.prependDKElementToHeader(secHeader);
        return doc;
    }

    public void prepare(Document doc, WSSecHeader secHeader) throws WSSecurityException, ConversationException {
        super.prepare(doc);
        this.wsDocInfo = new WSDocInfo(doc);
        this.securityHeader = secHeader.getSecurityHeader();
        this.sig = null;
        try {
            ExcC14NParameterSpec c14nSpec = null;
            if (this.getWsConfig().isWsiBSPCompliant() && this.canonAlgo.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
                List<String> prefixes = this.getInclusivePrefixes(secHeader.getSecurityHeader(), false);
                c14nSpec = new ExcC14NParameterSpec(prefixes);
            }
            this.c14nMethod = this.signatureFactory.newCanonicalizationMethod(this.canonAlgo, c14nSpec);
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            throw new WSSecurityException(10, "noXMLSig", null, ex);
        }
        this.keyInfoUri = this.getWsConfig().getIdAllocator().createSecureId("KI-", this.keyInfo);
        this.secRef = new SecurityTokenReference(doc);
        this.strUri = this.getWsConfig().getIdAllocator().createSecureId("STR-", this.secRef);
        this.secRef.setID(this.strUri);
        Reference refUt = new Reference(this.document);
        refUt.setURI("#" + this.dktId);
        this.secRef.setReference(refUt);
        DOMStructure structure = new DOMStructure(this.secRef.getElement());
        this.wsDocInfo.addTokenElement(this.secRef.getElement(), false);
        this.keyInfo = this.keyInfoFactory.newKeyInfo(Collections.singletonList(structure), this.keyInfoUri);
    }

    public Element getSignatureElement() {
        return WSSecurityUtil.getDirectChildElement(this.securityHeader, "Signature", "http://www.w3.org/2000/09/xmldsig#");
    }

    public List<javax.xml.crypto.dsig.Reference> addReferencesToSign(List<WSEncryptionPart> references, WSSecHeader secHeader) throws WSSecurityException {
        return this.addReferencesToSign(this.document, references, this.wsDocInfo, this.signatureFactory, secHeader, this.getWsConfig(), this.digestAlgo);
    }

    public void computeSignature(List<javax.xml.crypto.dsig.Reference> referenceList) throws WSSecurityException {
        this.computeSignature(referenceList, true, null);
    }

    public void computeSignature(List<javax.xml.crypto.dsig.Reference> referenceList, boolean prepend, Element siblingElement) throws WSSecurityException {
        try {
            SecretKey key = WSSecurityUtil.prepareSecretKey(this.sigAlgo, this.derivedKeyBytes);
            SignatureMethod signatureMethod = this.signatureFactory.newSignatureMethod(this.sigAlgo, null);
            SignedInfo signedInfo = this.signatureFactory.newSignedInfo(this.c14nMethod, signatureMethod, referenceList);
            this.sig = this.signatureFactory.newXMLSignature(signedInfo, this.keyInfo, null, this.getWsConfig().getIdAllocator().createId("SIG-", null), null);
            DOMSignContext signContext = null;
            if (prepend) {
                if (siblingElement == null) {
                    siblingElement = (Element)this.securityHeader.getFirstChild();
                }
                signContext = siblingElement == null ? new DOMSignContext(key, (Node)this.securityHeader) : new DOMSignContext(key, (Node)this.securityHeader, (Node)siblingElement);
            } else {
                signContext = new DOMSignContext(key, (Node)this.securityHeader);
            }
            signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this.canonAlgo)) {
                signContext.putNamespacePrefix("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
            }
            signContext.setProperty("transform_ws_doc_info", this.wsDocInfo);
            this.wsDocInfo.setCallbackLookup(this.callbackLookup);
            this.wsDocInfo.setTokensOnContext(signContext);
            if (this.secRef != null && this.secRef.getElement() != null) {
                WSSecurityUtil.storeElementInContext(signContext, this.secRef.getElement());
            }
            this.sig.sign(signContext);
            this.signatureValue = this.sig.getSignatureValue().getValue();
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new WSSecurityException(10, null, null, ex);
        }
    }

    @Override
    protected int getDerivedKeyLength() throws WSSecurityException {
        return this.derivedKeyLength > 0 ? this.derivedKeyLength : WSSecurityUtil.getKeyLength(this.sigAlgo);
    }

    public void setSignatureAlgorithm(String algorithm) {
        this.sigAlgo = algorithm;
    }

    public String getSignatureAlgorithm() {
        return this.sigAlgo;
    }

    public String getSignatureId() {
        if (this.sig == null) {
            return null;
        }
        return this.sig.getId();
    }

    public void setDigestAlgorithm(String algorithm) {
        this.digestAlgo = algorithm;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgo;
    }

    public byte[] getSignatureValue() {
        return this.signatureValue;
    }

    public void setSigCanonicalization(String algo) {
        this.canonAlgo = algo;
    }

    public String getSigCanonicalization() {
        return this.canonAlgo;
    }
}

