/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.common;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SampleAction;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;
import org.ow2.clif.storage.api.ActionEvent;

public class SessionObject
implements SessionObjectAction,
TestAction,
DataProvider,
ControlAction,
SampleAction {
    static final int SAMPLE_LOG = 3;
    static final String SAMPLE_LOG_ITERATION = "iteration";
    static final String SAMPLE_LOG_SUCCESSFUL = "successful";
    static final String SAMPLE_LOG_RESULT = "result";
    static final String SAMPLE_LOG_COMMENT = "comment";
    static final String SAMPLE_LOG_DURATION = "duration";
    static final int CONTROL_PRINTOUT = 0;
    static final String CONTROL_PRINTOUT_STRING = "string";
    static final int CONTROL_PRINTERR = 1;
    static final String CONTROL_PRINTERR_STRING = "string";
    static final int CONTROL_ALARM = 2;
    static final String CONTROL_ALARM_MESSAGE = "message";
    static final int CONTROL_SETPROPERTY = 4;
    static final String CONTROL_SETPROPERTY_VALUE = "value";
    static final String CONTROL_SETPROPERTY_NAME = "name";
    static final int CONTROL_SETTIMEZONE = 5;
    static final String CONTROL_SETTIMEZONE_TIMEZONE = "timezone";
    static final int TEST_TRUE = 0;
    static final int TEST_FALSE = 1;
    static final String DATE_MS_GET = "date_ms";
    static final String DATE_PREFIX = "date!";
    TimeZone tz = TimeZone.getDefault();

    public SessionObject() {
    }

    public SessionObject(Map<String, String> params) {
        this();
    }

    public Object createNewSessionObject() {
        return new SessionObject();
    }

    public void reset() {
    }

    public void close() {
    }

    public boolean doTest(int number, Map<String, String> params) {
        switch (number) {
            case 1: {
                return false;
            }
            case 0: {
                return true;
            }
        }
        throw new Error("Fatal error in ISAC's Common plug-in: unknown test identifier " + number);
    }

    public void doControl(int number, Map<String, String> params) {
        switch (number) {
            case 5: {
                String tzStr = params.get(CONTROL_SETTIMEZONE_TIMEZONE);
                if (tzStr == null || tzStr.isEmpty()) {
                    this.tz = TimeZone.getDefault();
                    break;
                }
                this.tz = TimeZone.getTimeZone(tzStr);
                break;
            }
            case 4: {
                System.setProperty(params.get(CONTROL_SETPROPERTY_NAME), params.get(CONTROL_SETPROPERTY_VALUE));
                break;
            }
            case 0: {
                System.out.println(params.get("string"));
                break;
            }
            case 1: {
                System.err.println(params.get("string"));
                break;
            }
            case 2: {
                throw new IsacRuntimeException(params.get(CONTROL_ALARM_MESSAGE));
            }
            default: {
                throw new Error("Fatal error in ISAC's Common plug-in: unknown control identifier " + number);
            }
        }
    }

    public String doGet(String var) {
        if (var.equals(DATE_MS_GET)) {
            return String.valueOf(System.currentTimeMillis());
        }
        if (var.startsWith(DATE_PREFIX)) {
            SimpleDateFormat format = new SimpleDateFormat(var.substring(DATE_PREFIX.length()));
            format.setTimeZone(this.tz);
            return format.format(new Date(System.currentTimeMillis()));
        }
        throw new IsacRuntimeException("Unknown variable name in Common plug-in: " + var);
    }

    public ActionEvent doSample(int number, Map<String, String> params, ActionEvent report) {
        switch (number) {
            case 3: {
                report.setDate(System.currentTimeMillis());
                report.duration = Integer.parseInt(params.get(SAMPLE_LOG_DURATION));
                report.comment = params.get(SAMPLE_LOG_COMMENT);
                report.result = (Serializable)((Object)params.get(SAMPLE_LOG_RESULT));
                report.type = "LOG";
                report.iteration = Integer.parseInt(params.get(SAMPLE_LOG_ITERATION));
                report.successful = ParameterParser.getRadioGroup((String)params.get(SAMPLE_LOG_SUCCESSFUL)).equals("yes");
                return report;
            }
        }
        throw new Error("Unable to find this sample in ~Common~ ISAC plugin: " + number);
    }
}

