/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.isac.plugin.counter;

import java.math.BigInteger;
import java.util.Map;
import org.ow2.clif.scenario.isac.exception.IsacRuntimeException;
import org.ow2.clif.scenario.isac.plugin.ControlAction;
import org.ow2.clif.scenario.isac.plugin.DataProvider;
import org.ow2.clif.scenario.isac.plugin.SessionObjectAction;
import org.ow2.clif.scenario.isac.plugin.TestAction;
import org.ow2.clif.scenario.isac.util.ParameterParser;

public class SessionObject
implements ControlAction,
TestAction,
SessionObjectAction,
DataProvider {
    static final String PLUGIN_RADIX_ARG = "radix_arg";
    static final String PLUGIN_SHARED_ARG = "shared_arg";
    static final String PLUGIN_VALUE_ARG = "value_arg";
    static final int TEST_EQUALS = 0;
    static final String TEST_EQUALS_VALUE_ARG = "value_arg";
    static final int TEST_NOT_EQUAL = 11;
    static final String TEST_NOT_EQUAL_VALUE_ARG = "value_arg";
    static final int TEST_GT = 1;
    static final String TEST_GT_VALUE_ARG = "value_arg";
    static final int TEST_GTE = 2;
    static final String TEST_GTE_VALUE_ARG = "value_arg";
    static final int TEST_LT = 3;
    static final String TEST_LT_VALUE_ARG = "value_arg";
    static final int TEST_LTE = 4;
    static final String TEST_LTE_VALUE_ARG = "value_arg";
    static final int TEST_IS_ZERO = 5;
    static final int TEST_IS_NOT_ZERO = 6;
    static final int TEST_GT0 = 7;
    static final int TEST_GTE0 = 8;
    static final int TEST_LT0 = 9;
    static final int TEST_LTE0 = 10;
    static final int TEST_TEST_AND_SET = 15;
    static final String TEST_TEST_AND_SET_NEW_VALUE = "new_value";
    static final String TEST_TEST_AND_SET_TEST_VALUE = "test_value";
    static final int TEST_NOT_TEST_AND_SET = 16;
    static final String TEST_NOT_TEST_AND_SET_NEW_VALUE = "new_value";
    static final String TEST_NOT_TEST_AND_SET_TEST_VALUE = "test_value";
    static final int CONTROL_RESET = 0;
    static final int CONTROL_SET = 1;
    static final String CONTROL_SET_VALUE_ARG = "value_arg";
    static final int CONTROL_INC = 2;
    static final int CONTROL_DEC = 3;
    static final int CONTROL_ADD = 4;
    static final String CONTROL_ADD_VALUE_ARG = "value_arg";
    static final int CONTROL_SUB = 5;
    static final String CONTROL_SUB_VALUE_ARG = "value_arg";
    static final int CONTROL_DIV = 12;
    static final String CONTROL_DIV_INTEGER = "integer";
    static final int CONTROL_MOD = 13;
    static final String CONTROL_MOD_INTEGER = "integer";
    static final int CONTROL_MULTIPLY = 14;
    static final String CONTROL_MULTIPLY_INTEGER = "integer";
    private static final String ENABLED = "enabled";
    private static final String GET_INC = "++";
    private static final String GET_DEC = "--";
    private static final String GET_SEP = "/";
    private BigInteger initialValue = BigInteger.ZERO;
    private volatile BigInteger value = BigInteger.ZERO;
    private boolean shared = false;
    private SessionObject specimen = null;
    private int radix = 10;

    public SessionObject(Map<String, String> params) {
        String valueStr;
        String radixStr = params.get(PLUGIN_RADIX_ARG);
        if (radixStr != null && !radixStr.trim().isEmpty()) {
            this.radix = Integer.parseInt(radixStr);
        }
        if ((valueStr = params.get("value_arg")) != null && valueStr.length() > 0) {
            this.initialValue = new BigInteger(valueStr, this.radix);
        }
        this.shared = ParameterParser.getCheckBox((String)params.get(PLUGIN_SHARED_ARG)).contains(ENABLED);
        if (this.shared) {
            this.value = this.initialValue;
        }
    }

    private SessionObject(SessionObject toClone) {
        this.initialValue = toClone.initialValue;
        this.shared = toClone.shared;
        this.radix = toClone.radix;
        this.specimen = toClone;
        if (!this.shared) {
            this.value = this.initialValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doTest(int number, Map<String, String> params) throws IsacRuntimeException {
        if (this.shared) {
            this.value = this.specimen.value;
        }
        switch (number) {
            case 16: {
                if (this.shared) {
                    SessionObject sessionObject = this.specimen;
                    synchronized (sessionObject) {
                        if (this.specimen.value.equals(new BigInteger(params.get("test_value"), this.radix))) {
                            this.specimen.value = new BigInteger(params.get("new_value"), this.radix);
                            return false;
                        }
                    }
                } else if (this.value.equals(new BigInteger(params.get("test_value"), this.radix))) {
                    this.value = new BigInteger(params.get("new_value"), this.radix);
                    return false;
                }
                return true;
            }
            case 15: {
                if (this.shared) {
                    SessionObject sessionObject = this.specimen;
                    synchronized (sessionObject) {
                        if (this.specimen.value.equals(new BigInteger(params.get("test_value"), this.radix))) {
                            this.specimen.value = new BigInteger(params.get("new_value"), this.radix);
                            return true;
                        }
                    }
                } else if (this.value.equals(new BigInteger(params.get("test_value"), this.radix))) {
                    this.value = new BigInteger(params.get("new_value"), this.radix);
                    return true;
                }
                return false;
            }
            case 0: {
                return this.value.compareTo(new BigInteger(params.get("value_arg"), this.radix)) == 0;
            }
            case 11: {
                return this.value.compareTo(new BigInteger(params.get("value_arg"), this.radix)) != 0;
            }
            case 1: {
                return this.value.compareTo(new BigInteger(params.get("value_arg"), this.radix)) > 0;
            }
            case 2: {
                return this.value.compareTo(new BigInteger(params.get("value_arg"), this.radix)) >= 0;
            }
            case 3: {
                return this.value.compareTo(new BigInteger(params.get("value_arg"), this.radix)) < 0;
            }
            case 4: {
                return this.value.compareTo(new BigInteger(params.get("value_arg"), this.radix)) <= 0;
            }
            case 5: {
                return this.value.equals(BigInteger.ZERO);
            }
            case 6: {
                return !this.value.equals(BigInteger.ZERO);
            }
            case 7: {
                return this.value.compareTo(BigInteger.ZERO) > 0;
            }
            case 8: {
                return this.value.compareTo(BigInteger.ZERO) >= 0;
            }
            case 9: {
                return this.value.compareTo(BigInteger.ZERO) < 0;
            }
            case 10: {
                return this.value.compareTo(BigInteger.ZERO) <= 0;
            }
        }
        throw new Error("Fatal error in ISAC's Counter plug-in: unknown test identifier " + number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doControl(int number, Map<String, String> params) {
        switch (number) {
            case 14: {
                if (this.shared) {
                    SessionObject sessionObject = this.specimen;
                    synchronized (sessionObject) {
                        this.specimen.value = this.specimen.value.multiply(new BigInteger(params.get("integer"), this.radix));
                    }
                } else {
                    this.value = this.value.multiply(new BigInteger(params.get("integer"), this.radix));
                }
                return;
            }
            case 13: {
                if (this.shared) {
                    SessionObject sessionObject = this.specimen;
                    synchronized (sessionObject) {
                        this.specimen.value = this.specimen.value.remainder(new BigInteger(params.get("integer"), this.radix));
                    }
                } else {
                    this.value = this.value.remainder(new BigInteger(params.get("integer"), this.radix));
                }
                return;
            }
            case 12: {
                if (this.shared) {
                    SessionObject sessionObject = this.specimen;
                    synchronized (sessionObject) {
                        this.specimen.value = this.specimen.value.divide(new BigInteger(params.get("integer"), this.radix));
                    }
                } else {
                    this.value = this.value.divide(new BigInteger(params.get("integer"), this.radix));
                }
                return;
            }
            case 0: {
                if (this.shared) {
                    SessionObject sessionObject = this.specimen;
                    synchronized (sessionObject) {
                        this.specimen.value = this.specimen.initialValue;
                    }
                } else {
                    this.value = this.initialValue;
                }
                return;
            }
            case 1: {
                if (this.shared) {
                    SessionObject sessionObject = this.specimen;
                    synchronized (sessionObject) {
                        this.specimen.value = new BigInteger(params.get("value_arg"), this.radix);
                    }
                } else {
                    this.value = new BigInteger(params.get("value_arg"), this.radix);
                }
                return;
            }
            case 2: {
                if (this.shared) {
                    SessionObject sessionObject = this.specimen;
                    synchronized (sessionObject) {
                        this.specimen.value = this.specimen.value.add(BigInteger.ONE);
                    }
                } else {
                    this.value = this.value.add(BigInteger.ONE);
                }
                return;
            }
            case 3: {
                if (this.shared) {
                    SessionObject sessionObject = this.specimen;
                    synchronized (sessionObject) {
                        this.specimen.value = this.specimen.value.subtract(BigInteger.ONE);
                    }
                } else {
                    this.value = this.value.subtract(BigInteger.ONE);
                }
                return;
            }
            case 4: {
                if (this.shared) {
                    SessionObject sessionObject = this.specimen;
                    synchronized (sessionObject) {
                        this.specimen.value = this.specimen.value.add(new BigInteger(params.get("value_arg"), this.radix));
                    }
                } else {
                    this.value = this.value.add(new BigInteger(params.get("value_arg"), this.radix));
                }
                return;
            }
            case 5: {
                if (this.shared) {
                    SessionObject sessionObject = this.specimen;
                    synchronized (sessionObject) {
                        this.specimen.value = this.specimen.value.subtract(new BigInteger(params.get("value_arg"), this.radix));
                    }
                } else {
                    this.value = this.value.subtract(new BigInteger(params.get("value_arg"), this.radix));
                }
                return;
            }
        }
        throw new Error("Fatal error in ISAC's Counter plug-in: unknown control identifier " + number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGet(String lengthStr) {
        String result;
        if ((lengthStr = lengthStr.trim()).startsWith(GET_INC)) {
            result = this.getAndSet(2);
            lengthStr = lengthStr.substring(GET_INC.length());
        } else if (lengthStr.startsWith(GET_DEC)) {
            result = this.getAndSet(3);
            lengthStr = lengthStr.substring(GET_DEC.length());
        } else if (this.shared) {
            SessionObject sessionObject = this.specimen;
            synchronized (sessionObject) {
                result = this.specimen.value.toString(this.radix);
            }
        } else {
            result = this.value.toString(this.radix);
        }
        if (lengthStr.length() > 1 && lengthStr.startsWith(GET_SEP)) {
            lengthStr = lengthStr.substring(GET_SEP.length());
        }
        if (lengthStr.length() != 0) {
            try {
                int length = Integer.parseInt(lengthStr);
                while (result.length() < length) {
                    result = " ".concat(result);
                }
            }
            catch (Exception ex) {
                throw new IsacRuntimeException("Bad number format for Counter value: " + lengthStr, ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAndSet(int control) {
        String result;
        if (this.shared) {
            SessionObject sessionObject = this.specimen;
            synchronized (sessionObject) {
                result = this.specimen.value.toString(this.radix);
                this.doControl(control, null);
            }
        } else {
            result = this.value.toString(this.radix);
            this.doControl(control, null);
        }
        return result;
    }

    public Object createNewSessionObject() {
        return new SessionObject(this);
    }

    public void close() {
    }

    public void reset() {
        this.value = this.initialValue;
    }
}

