/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.clif.manifest;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.ow2.clif.manifest.LibDirectory;

@Mojo(name="tycho-manifest", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class ClifManifestGenerator
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.name}")
    private String name;
    @Parameter(required=true, defaultValue="${project.version}")
    private String version;
    @Parameter(required=true)
    private LibDirectory[] directories;
    @Parameter
    private String[] additionals;
    @Parameter(required=true)
    private String activator;
    @Parameter(required=true)
    private String symbolicName;
    @Parameter
    private String requirebundle;
    @Parameter
    private String exportpackage;
    @Parameter
    private String importpackage;
    @Parameter(defaultValue="false")
    private boolean unpack;

    protected String getManifestContent() throws MojoExecutionException {
        String strBundleShape;
        String strImportPackage;
        String strExportPackage;
        this.getLog().info((CharSequence)("generating MANIFEST.MF content for " + this.getName()));
        String result = "Bundle-ManifestVersion: 2\nBundle-RequiredExecutionEnvironment: JavaSE-1.6\nBundle-Name: " + this.getName() + "\nBundle-SymbolicName: " + this.getSymbolicName() + "\nBundle-Version: " + this.getBundleVersion() + "\nBundle-Activator: " + this.getActivator() + "\nBundle-Vendor: France Telecom\nBundle-ActivationPolicy: lazy\nBundle-ClassPath:" + this.getBundleClassPath() + "\n";
        String strRequireBundle = this.getRequireBundle();
        if (strRequireBundle != null) {
            result = result + strRequireBundle + "\n";
        }
        if ((strExportPackage = this.getExportPackage()) != null) {
            result = result + strExportPackage + "\n";
        }
        if ((strImportPackage = this.getImportPackage()) != null) {
            result = result + strExportPackage + "\n";
        }
        if ((strBundleShape = this.getEclipseBundleShape()) != null) {
            result = result + strBundleShape + "\n";
        }
        return result;
    }

    private String getSymbolicName() throws MojoExecutionException {
        if (this.symbolicName == null || this.symbolicName.isEmpty()) {
            throw new MojoExecutionException("invalid symbolic name: null or empty isn't allowed.");
        }
        return this.symbolicName;
    }

    private String getRequireBundle() {
        String result = this.requirebundle;
        if (result != null && !result.isEmpty()) {
            result = "Require-Bundle: " + result;
            result = result.replaceAll("\\s\\s+", " ");
            result = result.replaceAll(",\\s", ",\n ");
        }
        return result;
    }

    private String getExportPackage() {
        String result = this.exportpackage;
        if (result != null && !result.isEmpty()) {
            result = "Export-Package: " + result;
            result = result.replaceAll("\\s\\s+", " ");
            result = result.replaceAll(",\\s", ",\n ");
        }
        return result;
    }

    private String getImportPackage() {
        String result = this.importpackage;
        if (result != null && !result.isEmpty()) {
            result = "Import-Package: " + result;
            result = result.replaceAll("\\s\\s+", " ");
            result = result.replaceAll(",\\s", ",\n ");
        }
        return result;
    }

    private String getBundleClassPath() throws MojoExecutionException {
        int i;
        if (this.directories == null) {
            throw new MojoExecutionException("no lib directory has been specified.");
        }
        this.getLog().info((CharSequence)"generating Bundle-ClassPath");
        LibDirectory.MojoLog = this.getLog();
        String result = null;
        if (this.additionals != null) {
            for (i = 0; i < this.additionals.length; ++i) {
                this.getLog().info((CharSequence)("adding jar: " + this.additionals[i]));
                result = result == null ? " " + this.additionals[i] : result + ",\n " + this.additionals[i];
            }
        }
        for (i = 0; i < this.directories.length; ++i) {
            this.getLog().info((CharSequence)("retreiving jars from " + this.directories[i]));
            String list = this.directories[i].getJarList();
            if (list == null) continue;
            result = result == null ? list : result + ",\n" + list;
        }
        return result;
    }

    private String getActivator() throws MojoExecutionException {
        if (this.activator == null || this.activator.isEmpty()) {
            throw new MojoExecutionException("invalid activator: null or empty string aren't allowed.");
        }
        return this.activator;
    }

    private String getBundleVersion() throws MojoExecutionException {
        String result = this.version;
        if (result == null) {
            throw new MojoExecutionException("invalid version: null isn't allowed.");
        }
        result = result.replaceAll("-SNAPSHOT", ".qualifier");
        return result;
    }

    private String getEclipseBundleShape() {
        String result = null;
        if (this.unpack) {
            result = "Eclipse-BundleShape: dir";
        }
        return result;
    }

    private String getName() {
        return this.name;
    }

    public void execute() throws MojoExecutionException {
        File targetDirectory = new File(this.outputDirectory, "META-INF");
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        this.getLog().debug((CharSequence)("target directory created: " + targetDirectory.getPath()));
        File targetFile = new File(targetDirectory, "MANIFEST.MF");
        FileWriter w = null;
        try {
            w = new FileWriter(targetFile);
            w.write(this.getManifestContent());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file " + targetFile, (Exception)e);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

