/**
 * Petals Master - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * EndpointManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.deployment;

import java.util.List;

import javax.jws.WebService;

import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.EndpointManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.service.DragonFault;

/**
 * @author ofabre - ebmwebsourcing
 * 
 */
@WebService(endpointInterface = "org.ow2.dragon.service.deployment.EndpointManagerService")
public class EndpointManagerServiceImpl implements EndpointManagerService {

    private EndpointManager endpointManager;

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.service.deployment.EndpointManager#addCategory(java.lang
     * .String, java.lang.String, java.lang.String, java.lang.String)
     */
    public void addCategory(String endpointId, String categoryId, String categoryValue,
            String categoryDesc) throws DragonFault {
        try {
            endpointManager.addCategory(endpointId, categoryId, categoryValue, categoryDesc);
        } catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.service.deployment.EndpointManager#addCategory(java.lang
     * .String, java.lang.String, java.lang.String)
     */
    public void addCategory(String endpointId, String categoryId, String categoryValueId)
            throws DragonFault {
        try {
            endpointManager.addCategory(endpointId, categoryId, categoryValueId);
        } catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.service.deployment.EndpointManager#getAllEndpoints(org
     * .ow2.dragon.api.to.RequestOptionsTO)
     */
    public List<EndpointTO> getAllEndpoints(RequestOptionsTO requestOptions) throws DragonFault {
        List<EndpointTO> result = null;
        try {
            result = endpointManager.getAllEndpoints(requestOptions);
        } catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.service.deployment.EndpointManager#getCategoriesForEndpoint
     * (java.lang.String)
     */
    public List<KeyedRefTO> getCategoriesForEndpoint(String endpointId) throws DragonFault {
        try {
            return endpointManager.getCategoriesForEndpoint(endpointId);
        } catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.service.deployment.EndpointManager#getEndpoint(java.lang
     * .String)
     */
    public EndpointTO getEndpoint(String endpointId) throws DragonFault {
        EndpointTO result = null;
        try {
            result = endpointManager.getEndpoint(endpointId, null);
        } catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.service.deployment.EndpointManager#getEndpointsByService
     * (java.lang.String, org.ow2.dragon.api.to.RequestOptionsTO)
     */
    public List<EndpointTO> getEndpointsByService(String serviceId, RequestOptionsTO requestOptions)
            throws DragonFault {
        List<EndpointTO> result = null;
        try {
            result = endpointManager.getEndpointsByTechService(serviceId, requestOptions);
        } catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.service.deployment.EndpointManager#removeCategories(java
     * .lang.String, java.util.List)
     */
    public void removeCategories(String endpointId, List<String> categoryIds) {
        endpointManager.removeCategories(endpointId, categoryIds);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.service.deployment.EndpointManager#removeService(java.
     * lang.String)
     */
    public void removeEndpoint(String endpointId) throws DragonFault {
        try {
            endpointManager.removeEndpoint(endpointId);
        } catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.service.deployment.EndpointManager#updateEndpoint(org.
     * ow2.dragon.api.to.deployment.EndpointTO)
     */
    public String updateEndpoint(EndpointTO endpointTO) throws DragonFault {
        try {
            return endpointManager.updateEndpoint(endpointTO);
        } catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public void setEndpointManager(EndpointManager endpointManager) {
        this.endpointManager = endpointManager;
    }

}
