/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ServiceManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import javax.activation.DataHandler;
import javax.jws.WebService;
import javax.mail.util.ByteArrayDataSource;

import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.ServiceSearchProperties;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.metadata.SimpleFileTO;
import org.ow2.dragon.service.DragonFault;
import org.ow2.dragon.util.InputStreamUtil;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@WebService(endpointInterface = "org.ow2.dragon.service.deployment.ServiceManagerService")
public class ServiceManagerServiceImpl implements ServiceManagerService {

    private TechServiceManager techServiceManager;

    public void removeService(String serviceId) throws DragonFault {
        try {
            techServiceManager.removeTechService(serviceId);
        } catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public List<TechnicalServiceTO> getAllTechServices(RequestOptionsTO requestOptions)
            throws DragonFault {
        List<TechnicalServiceTO> result = null;
        try {
            result = techServiceManager.getAllTechServices(requestOptions);
        } catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return result;
    }

    public void setTechServiceManager(TechServiceManager techServiceManager) {
        this.techServiceManager = techServiceManager;
    }

    public TechnicalServiceTO getService(String serviceId) throws DragonFault {
        TechnicalServiceTO result = null;
        try {
            result = techServiceManager.getTechService(serviceId, null);
        } catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return result;
    }

    public String addRelatedDoc(String serviceId, String mimetype, AttachedDocument attachedDocument)
            throws DragonFault {
        String result = null;
        try {
            DataHandler desc = attachedDocument.getDocument();
            byte[] docContent = InputStreamUtil.getBytes(desc.getInputStream());
            result = techServiceManager.registerRelatedDoc(serviceId, mimetype, docContent);
        } catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        } catch (IOException e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return result;
    }

    public void addCategory(String techServiceId, String categoryId, String categoryValue,
            String categoryDesc) throws DragonFault {
        try {
            techServiceManager.addCategory(techServiceId, categoryId, categoryValue, categoryDesc);
        } catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public void addCategory(String techServiceId, String categoryId, String categoryValueId)
            throws DragonFault {
        try {
            techServiceManager.addCategory(techServiceId, categoryId, categoryValueId);
        } catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public List<KeyedRefTO> getCategoriesForTechServ(String techServiceId) throws DragonFault {
        try {
            return techServiceManager.getCategoriesForTechServ(techServiceId);
        } catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public AttachedDocument getRelatedDocContent(String relatedDocId) throws DragonFault {
        AttachedDocument attachedDocument = null;
        try {
            attachedDocument = new AttachedDocument();
            InputStream inputStream = techServiceManager.getRelatedDocContent(relatedDocId);
            attachedDocument
                    .setDocument(new DataHandler(new ByteArrayDataSource(inputStream, null)));
        } catch (Exception e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return attachedDocument;
    }

    public List<SimpleFileTO> getRelatedDocsForTechServ(String techServiceId) throws DragonFault {
        try {
            return techServiceManager.getRelatedDocsForTechServ(techServiceId);
        } catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public void removeCategories(String techServiceId, List<String> categoryIds) {
        techServiceManager.removeCategories(techServiceId, categoryIds);
    }

    public List<TechnicalServiceTO> searchTechService(String searchCriteria,
            List<ServiceSearchProperties> searchedProperties, RequestOptionsTO iOptions)
            throws DragonFault {
        try {
            return techServiceManager.searchTechService(searchCriteria, searchedProperties,
                    iOptions);
        } catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public String updateTechService(TechnicalServiceTO techServiceTO) throws DragonFault {
        try {
            return techServiceManager.updateTechService(techServiceTO);
        } catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

}
