/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * OrganizationManagerServiceImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.organization;

import java.util.List;

import javax.jws.WebService;

import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.OrganizationManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.organization.OrganizationSearchProperties;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.ow2.dragon.service.DragonFault;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@WebService(endpointInterface = "org.ow2.dragon.service.organization.OrganizationManagerService")
public class OrganizationManagerServiceImpl implements OrganizationManagerService {

    private OrganizationManager organizationManager;

    /*
     * (non-Javadoc)
     * 
     * @seeorg.ow2.dragon.service.organization.OrganizationManagerService#
     * getAllOrganizations(org.ow2.dragon.ui.model.dataaccess.RequestOptions)
     */
    public List<OrganizationUnitTO> getAllOrganizations(final RequestOptionsTO requestOptionsTO) {
        return this.organizationManager.getAllOrganizations(requestOptionsTO);
    }

    /*
     * (non-Javadoc)
     * 
     * @seeorg.ow2.dragon.service.organization.OrganizationManagerService#
     * getOrganization(java.lang.String)
     */
    public OrganizationUnitTO getOrganization(final String organizationId) throws DragonFault {
        try {
            return this.organizationManager.getOrganization(organizationId);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public OrganizationManager getOrganizationManager() {
        return this.organizationManager;
    }

    /*
     * (non-Javadoc)
     * 
     * @seeorg.ow2.dragon.service.organization.OrganizationManagerService#
     * removeOrganization(java.lang.String)
     */
    public void removeOrganization(final String organizationId) {
        this.organizationManager.removeOrganization(organizationId);

    }

    /*
     * (non-Javadoc)
     * 
     * @seeorg.ow2.dragon.service.organization.OrganizationManagerService#
     * searchOrganization(java.lang.String, boolean, boolean, boolean, boolean,
     * org.ow2.dragon.ui.model.dataaccess.RequestOptions)
     */
    public List<OrganizationUnitTO> searchOrganization(final String searchCriteria,
            List<OrganizationSearchProperties> searchedProperties,
            final RequestOptionsTO requestOptionsTO) throws DragonFault {
        try {
            return this.organizationManager.searchOrganization(searchCriteria, searchedProperties,
                    requestOptionsTO);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @seeorg.ow2.dragon.service.organization.OrganizationManagerService#
     * setOrganization
     * (org.ow2.dragon.ui.model.to.organization.OrganizationUnitTO)
     */
    public String createOrganization(final OrganizationUnitTO organizationUnitTO)
            throws DragonFault {
        try {
            return this.organizationManager.createOrganization(organizationUnitTO);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }

    }

    public void addPost(String organizationId, String postId) throws DragonFault {
        try {
            this.organizationManager.addPost(organizationId, postId);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public void setOrganizationManager(final OrganizationManager organizationManager) {
        this.organizationManager = organizationManager;
    }

    public List<KeyedRefTO> getCategoriesForOrg(String orgId) throws DragonFault {
        try {
            return organizationManager.getCategoriesForOrg(orgId);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public List<KeyedRefTO> getIdentifiersForOrg(String orgId) throws DragonFault {
        try {
            return organizationManager.getIdentifiersForOrg(orgId);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public void removePost(String organizationId, String postId) throws DragonFault {
        try {
            organizationManager.removePost(organizationId, postId);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public String updateOrganization(OrganizationUnitTO organizationUnitTO) throws DragonFault {
        try {
            return organizationManager.updateOrganization(organizationUnitTO);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

}
