/**
 * Petals Master - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * RoleOfPartyManagerService.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.organization;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import org.ow2.dragon.api.service.organization.RoleOfPartyManager.LINK_TYPE;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.OrgToEndpointTO;
import org.ow2.dragon.api.to.organization.OrgToTechServiceTO;
import org.ow2.dragon.api.to.organization.PersonToEndpointTO;
import org.ow2.dragon.api.to.organization.PersonToTechServiceTO;
import org.ow2.dragon.service.DragonFault;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@WebService
public interface RoleOfPartyManagerService {

    @WebMethod(operationName = "createEndpointRole")
    String createEndpointRole(@WebParam(name = "partyId") String partyId,
            @WebParam(name = "endpointId") String endpointId, @WebParam(name = "type") String type)
            throws DragonFault;

    @WebMethod(operationName = "createServiceRole")
    String createTechServiceRole(@WebParam(name = "partyId") String partyId,
            @WebParam(name = "serviceId") String technicalServiceId,
            @WebParam(name = "type") String type) throws DragonFault;

    @WebMethod(operationName = "getOrgRolesByEndpoint")
    List<OrgToEndpointTO> getOrgRolesByEndpoint(@WebParam(name = "endpointId") String endpointId,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO)
            throws DragonFault;

    @WebMethod(operationName = "getOrgRolesByService")
    List<OrgToTechServiceTO> getOrgRolesByTechService(
            @WebParam(name = "serviceId") String techServiceId,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO)
            throws DragonFault;

    @WebMethod(operationName = "getPersonRolesByEndpoint")
    List<PersonToEndpointTO> getPersonRolesByEndpoint(
            @WebParam(name = "endpointId") String endpointId,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO)
            throws DragonFault;

    @WebMethod(operationName = "getPersonRolesByService")
    List<PersonToTechServiceTO> getPersonRolesByTechService(
            @WebParam(name = "serviceId") String techServiceId,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO)
            throws DragonFault;

    @WebMethod(operationName = "getRolesTypes")
    String[] getRolesTypes(@WebParam(name = "linkType") LINK_TYPE linkType,
            @WebParam(name = "requestOptions") RequestOptionsTO iOptions) throws DragonFault;

    @WebMethod(operationName = "removeRole")
    void removeRole(@WebParam(name = "roleId") String roleId) throws DragonFault;
}
