
package org.ow2.dragon.service.sla;

import javax.jws.WebService;

import org.ow2.dragon.api.service.sla.SLAServiceException;

@WebService
public interface SLAManagerService {

    /**
     * export WS-agreement description
     * 
     * @param the
     *            id where the agreement is stored
     * @return the agreement
     * @throws SLAServiceException
     *             error to export
     */
    String exportServiceDefFile(String id) throws SLAServiceException;

    /**
     * import WS-agreement description
     * 
     * @param wsdlURI
     *            the uri of ws-agreement description
     * @return the id where the agreement is stored
     * @throws SLAServiceException
     *             error to import
     */
    String importServiceDefFile(String slaURI) throws SLAServiceException;

}
