/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TechnologyManager.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.technology;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.technology.EnvironmentFederationTO;
import org.ow2.dragon.api.to.technology.ExecEnvManagerSearchProperties;
import org.ow2.dragon.api.to.technology.ExecEnvSearchProperties;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentManagerTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.api.to.technology.FederationSearchProperties;
import org.ow2.dragon.api.to.technology.ProcessorSearchProperties;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.service.DragonFault;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@WebService
public interface TechnologyManagerService {

    @WebMethod(operationName = "addRuntimeManager")
    String addRuntimeManager(@WebParam(name = "address") String address) throws DragonFault;

    @WebMethod(operationName = "getAllEnvironmentFederations")
    List<EnvironmentFederationTO> getAllEnvironmentFederations(
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO);

    @WebMethod(operationName = "getAllExecutionEnvironmentManagers")
    List<ExecutionEnvironmentManagerTO> getAllExecutionEnvironmentManagers(
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO);

    @WebMethod(operationName = "getAllExecutionEnvironments")
    List<ExecutionEnvironmentTO> getAllExecutionEnvironments(
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO);

    @WebMethod(operationName = "getAllProcessors")
    List<ProcessorTO> getAllProcessors(
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO);

    @WebMethod(operationName = "getEnvironmentFederation")
    EnvironmentFederationTO getEnvironmentFederation(@WebParam(name = "envFedId") String envFedId);

    @WebMethod(operationName = "getEpsHostedOnExecEnv")
    List<EndpointTO> getEpsHostedOnExecEnv(@WebParam(name = "execEnvId") String execEnvId,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO);

    @WebMethod(operationName = "getEpsHostedOnProcessor")
    List<EndpointTO> getEpsHostedOnProcessor(@WebParam(name = "processorId") String processorId,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO);

    @WebMethod(operationName = "getExecEnvsHostedOnProcessor")
    List<ExecutionEnvironmentTO> getExecEnvsHostedOnProcessor(
            @WebParam(name = "processorId") String processorId,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO);

    @WebMethod(operationName = "getExecEnvsInFederation")
    List<ExecutionEnvironmentTO> getExecEnvsInFederation(
            @WebParam(name = "envFedId") String envFedId,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO);

    @WebMethod(operationName = "getExecutionEnvironment")
    ExecutionEnvironmentTO getExecutionEnvironment(@WebParam(name = "execEnvId") String execEnvId);

    @WebMethod(operationName = "getManagedExecEnv")
    List<ExecutionEnvironmentTO> getManagedExecEnv(
            @WebParam(name = "runtimeManagerId") String runtimeManagerId,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO);

    @WebMethod(operationName = "getProcessor")
    ProcessorTO getProcessor(@WebParam(name = "processorId") String processorId);

    @WebMethod(operationName = "getRuntimeManager")
    ExecutionEnvironmentManagerTO getRuntimeManager(
            @WebParam(name = "runtimeManagerId") String runtimeManagerId);

    @WebMethod(operationName = "searchEnvironmentFederations")
    List<EnvironmentFederationTO> searchEnvironmentFederations(
            @WebParam(name = "searchCriteria") String searchCriteria,
            @WebParam(name = "searchedProperties") List<FederationSearchProperties> searchedProperties,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO)
            throws DragonFault;

    @WebMethod(operationName = "searchExecutionEnvironmentManagers")
    List<ExecutionEnvironmentManagerTO> searchExecutionEnvironmentManagers(
            @WebParam(name = "searchCriteria") String searchCriteria,
            @WebParam(name = "searchedProperties") List<ExecEnvManagerSearchProperties> searchedProperties,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO)
            throws DragonFault;

    @WebMethod(operationName = "searchExecutionEnvironments")
    List<ExecutionEnvironmentTO> searchExecutionEnvironments(
            @WebParam(name = "searchCriteria") String searchCriteria,
            @WebParam(name = "searchedProperties") List<ExecEnvSearchProperties> searchedProperties,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO)
            throws DragonFault;

    @WebMethod(operationName = "searchProcessors")
    List<ProcessorTO> searchProcessors(
            @WebParam(name = "searchCriteria") String searchCriteria,
            @WebParam(name = "searchedProperties") List<ProcessorSearchProperties> searchedProperties,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO)
            throws DragonFault;

    @WebMethod(operationName = "synchronizeManagedExecEnv")
    void synchronizeManagedExecEnv(@WebParam(name = "runtimeManagerId") String runtimeManagerId)
            throws DragonFault;

}
